var app = new Vue({
	el: "#appagencia",
	data: {
		Nombre: '<h6 class="mb-0 lang" key="Nombre">Nombre</h6>',
		Correo: '<h6 class="mb-0 lang" key="Correo">Correo</h6>',
		Telefono: '<h6 class="mb-0 lang" key="Teléfono">Teléfono</h6>',
		Whatsapp: '<h6 class="mb-0>Whatsapp</h6>',
		Direccion: '<h6 class="mb-0 lang" key="Dirección">Dirección</h6>',
		codpostal: '<h6 class="mb-0 lang" key="Código postal">Código postal</h6>',
		Ciudad: '<h6 class="mb-0 lang" key="Ciudad">Ciudad</h6>',
		Estado: '<h6 class="mb-0 lang" key="Estado">Estado</h6>',
		nombre: "",
		detalle_agencia: [],
		baseUrl: baseUrl,
		datos: {},
	},
	created: function () {
		this.listaragencia();
	},
	methods: {
		viewagencia: function (id_agencia) {
			return this.baseUrl + '/proveedores/view/id/' + id_proveedor
		},
		eliminarAgencia: function (modelo) {
			this.modalEliminar(modelo);
		},
		modalEliminar: function (modelo) {
			Swal.fire({
				title: '¿Estas seguro que desea eliminarlo?',
				text: "Se eliminara permanentemente",
				icon: 'warning',
				showCancelButton: true,
				confirmButtonColor: '#3085d6',
				cancelButtonColor: '#d33',
				confirmButtonText: 'Eliminar',
				cancelButtonText: 'Cancelar'
			}).then((result) => {
				if (result.isConfirmed) {
					this.$http.get(this.baseUrl + "/proveedores/eliminarProveedor/id/" + modelo).then(function (response) {
						if (response.data.estatus == 200) {
							toastr.success("Se ha eliminado correctamente", "Proveedor Eliminado", {
								timeOut: 2000,
								closeButton: !0,
								debug: !1,
								newestOnTop: !0,
								progressBar: !0,
								positionClass: "toast-bottom-right",
								preventDuplicates: !0,
								onclick: null,
								showDuration: "300",
								hideDuration: "100",
								extendedTimeOut: "100",
								showEasing: "swing",
								hideEasing: "linear",
								showMethod: "fadeIn",
								hideMethod: "fadeOut",
								tapToDismiss: !1
							})
						} else {
							Swal.fire({
								title: 'Error',
								timer: 2000,
								icon: 'error',
								text: response.data.mensaje,
							})
						}
					}, function (error) {
						Swal.fire( {
							title: 'Error',
							timer: 2000,
							icon: 'error',
							text: 'Ha ocurrido un error',
						})
					});
				}
			})
		},
		listaragencia: function () {
			this.$http
				.get(
					this.baseUrl + '/agencia/agenciaapi'
				)
				.then(function (response) {
					this.detalle_agencia = response.data;
					this.datos = response.data;
				})
				.catch(function (error) {
					console.log(error)
				});
		},
	},
});