Vue.http.options.emulateJSON = true;
const Toastr = Swal.mixin({
    toast: true,
    position: 'top-end',
    showConfirmButton: false,
    timer: 3000,
    timerProgressBar: true,
    didOpen: (toast) => {
        toast.addEventListener('mouseenter', Swal.stopTimer)
        toast.addEventListener('mouseleave', Swal.resumeTimer)
    }
})
var vm = new Vue({
    el: "#grupos",
    data: {

        baseUrl: baseUrl,
        datosServicios: [],
        datatableGrupos: {},
        baseUrl: baseUrl,

    },
    created: function() {
        this.loadServicios();
        this.listarServicios();
    },

    methods: {
        loadServicios: function() {
            this.$http.get(this.baseUrl + '/bodas/bodasapi').then(res => {
                this.datatableGrupos = res.body;
                this.loadTable();
            }).catch(err => {
                console.log(err);

            });
        },
        eliminarServicio: function(servicio) {
            this.modalEliminar(servicio);
        },
        modalEliminar: function(servicio) {
            Swal.fire({
                title: '¿Estas seguro que desea eliminarlo?',
                text: "Se eliminara permanentemente",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Eliminar',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.isConfirmed) {
                    this.$http.get(this.baseUrl + "/ventas/deleteServicios/id/" + servicio).then(function(response) {
                        console.log(response.data.estatus);
                        if (response.data.estatus == 200) {
                            this.listarServicios();
                            toastr.success("Se ha eliminado correctamente", "Servicio Eliminado", {
                                timeOut: 2000,
                                closeButton: !0,
                                debug: !1,
                                newestOnTop: !0,
                                progressBar: !0,
                                positionClass: "toast-bottom-right",
                                preventDuplicates: !0,
                                onclick: null,
                                showDuration: "300",
                                hideDuration: "100",
                                extendedTimeOut: "100",
                                showEasing: "swing",
                                hideEasing: "linear",
                                showMethod: "fadeIn",
                                hideMethod: "fadeOut",
                                tapToDismiss: !1
                            })
                        } else {
                            Swal.fire({
                                title: 'Error',
                                timer: 2000,
                                icon: 'error',
                                text: response.data.mensaje,
                            }, )
                        }
                    }, function(error) {
                        Swal.fire({
                            title: 'Error',
                            timer: 2000,
                            icon: 'error',
                            text: 'Ha ocurrido un error',
                        }, )
                    });

                }
            })
        },
        eliminarVenta: function(venta) {
            this.modalEliminarventa(venta);
        },
        modalEliminarventa: function(venta) {
            var that = this;
            Swal.fire({
                title: '¿Estas seguro que desea eliminarlo?',
                text: "Se eliminara permanentemente",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Eliminar',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.isConfirmed) {
                    that.$http.get(that.baseUrl + "/ventas/eliminarVenta/id/" + venta).then(function(response) {
                        console.log(response.data.estatus);
                        if (response.data.estatus == 200) {
                            that.loadTable();
                            toastr.success("Se ha eliminado correctamente", "Servicio Eliminado", {
                                timeOut: 2000,
                                closeButton: !0,
                                debug: !1,
                                newestOnTop: !0,
                                progressBar: !0,
                                positionClass: "toast-bottom-right",
                                preventDuplicates: !0,
                                onclick: null,
                                showDuration: "300",
                                hideDuration: "100",
                                extendedTimeOut: "100",
                                showEasing: "swing",
                                hideEasing: "linear",
                                showMethod: "fadeIn",
                                hideMethod: "fadeOut",
                                tapToDismiss: !1
                            })
                        } else {
                            Swal.fire({
                                title: 'Error',
                                timer: 2000,
                                icon: 'error',
                                text: response.data.mensaje,
                            }, )
                        }
                    }, function(error) {
                        Swal.fire({
                            title: 'Error',
                            timer: 2000,
                            icon: 'error',
                            text: 'Ha ocurrido un error',
                        }, )
                    });

                }
            })
        },
        loadTable() {
            var table = $(".datatable");
            table.DataTable({
                language: { url: "https://cdn.datatables.net/plug-ins/1.10.24/i18n/Spanish.json" },
                data: this.datatableGrupos,
                scrollX: true,
                // scrollY: 450,
                ajax: "",
                dom: '<"d-flex justify-content-between align-items-center mx-0 row"<"col-sm-12 col-md-6"B><"col-sm-12 col-md-6"f>>t<"d-flex justify-content-between mx-0 row"<"col-sm-12 col-md-6"i><"col-sm-12 col-md-6"p>>',
                bDestroy: true,
                buttons: [{
                    extend: "collection",
                    className: "btn btn-outline-secondary dropdown-toggle me-2",
                    text: feather.icons.share.toSvg({ class: "font-small-4 me-50" }) + "Exportar",
                    buttons: [{
                        extend: "csv",
                        text: feather.icons["file-text"].toSvg({ class: "font-small-4 me-50" }) + "Csv",
                        className: "dropdown-item",
                        //exportOptions: { columns: [3, 4, 5, 6, 7] } 
                    }, {
                        extend: "excel",
                        text: feather.icons.file.toSvg({ class: "font-small-4 me-50" }) + "Excel",
                        className: "dropdown-item",
                    }, {
                        extend: "pdf",
                        text: feather.icons.clipboard.toSvg({ class: "font-small-4 me-50" }) + "Pdf",
                        className: "dropdown-item",
                    }, {
                        extend: "copy",
                        text: feather.icons.copy.toSvg({ class: "font-small-4 me-50" }) + "Copiar",
                        className: "dropdown-item",
                    }],
                    init: function(e, t, a) {
                        $(t).removeClass("btn-secondary"), $(t).parent().removeClass("btn-group"), setTimeout((function() { $(t).closest(".dt-buttons").removeClass("btn-group").addClass("d-inline-flex") }), 50)

                    }
                }],
                scrollCollapse: true,
                columns: [
                    { data: 'idVenta.folio' },
                    { data: 'titulo_evento' },
                    { data: 'idVenta.pasajero_titular' },
                    { data: 'num_habitaciones' },
                    { data: 'noches' },
                    { data: 'hotel' },
                    { data: 'tipo_habitacion' },
                    {
                        data: null,
                        orderable: false,
                        render: function(data) {
                            return '<a href='+ vm.baseUrl +'"/grupos/view/' + data.id_grupo + '" class="edit-rate-record" ><i class="far fa-eye"></i></a></br><a onclick="eliminar(' + data.id_grupo + ')" href="javascript:void(0)" class="delete-rate-record ml-1"><i class="fas fa-trash"></i></a>';
                        }
                    },

                ]
            });
        },
        listarServicios: function() {
            this.$http.get(this.baseUrl + "/ventas/VentasServiciosApi/id_venta/" + id_venta)
                .then(function(response) {
                    this.datosServicios = response.data;
                    console.log(this.datosServicios);
                })
                .catch(function(error) {
                    console.log(error)
                });
        },
    },
});

function eliminar(id) {
    vm.eliminarVenta(id);
}