var chartVentas = [];
var apexchartcustom = new Vue({
    el: '#apexchart',
    data: {
        baseUrl: baseUrl,
        alturaChart: alturaChart,
        graficas: {
            ventas: []
        },
        list_years: [],
        year_selected: moment().format("YYYY"),
        total_ventas: 0,
        loading: true,
        chartInit: '',
    },
    created() {
        this.cargarGraficas();
    },
    methods: {
        cargarGraficas: function() {
            this.cargarGraficaVentas();
        },
        cargarGraficaVentas() {
            this.$http.get(this.baseUrl + '/site/graficaVentas?year=' + this.year_selected).then(response => {
                this.graficas.ventas = response.data;
                this.loading = false;
                if (response.body.length > 0) {
                    this.loadYear();
                    var that = this;
                    this.total_ventas = 0;
                    this.graficas.ventas.forEach(venta => {
                        that.total_ventas += parseFloat(venta.y);
                    });
                    var DarkModeColor = 'gray';
                    var colorPalette = ['#00D8B6', '#008FFB']
                    var options = {
                        series: [{
                            name: "2021",
                            data: this.graficas.ventas,
                        }],
                        chart: {
                            animations: {
                                enabled: true,
                                easing: 'easeinout',
                                speed: 800,
                                animateGradually: {
                                    enabled: true,
                                    delay: 150
                                },
                                dynamicAnimation: {
                                    enabled: true,
                                    speed: 350
                                }
                            },
                            type: 'bar',
                            height: this.alturaChart,
                            width: '100%',
                            stacked: false,
                            toolbar: {
                                export: {
                                    csv: {
                                        filename: 'Reporte de Venta.',
                                        headerCategory: 'Mes',
                                        headerValue: 'Cant. Dinero',
                                    }
                                }
                            },
                        },
                        yaxis: {
                            decimalsInFloat: 2,
                            labels: {
                                style: {
                                    colors: DarkModeColor,
                                    fontWeight: 600,
                                    fontSize: '12px',
                                },
                                formatter: function(value) {
                                    var redondear = Math.ceil(value);
                                    let response = (redondear / 1).toFixed(2).replace(',', '.')
                                    return "$ " + response.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
                                }
                            },
                        },
                        noData: {
                            text: 'Cargando...'
                        },
                        xaxis: {
                            // categories: ['ABC', 'PQR', 'XYZ'],
                            tickPlacement: 'on',
                            labels: {
                                style: {
                                    colors: DarkModeColor,
                                    fontWeight: 900,
                                    fontSize: '13px',
                                },
                                formatter: function(value) {
                                    var mes = "";
                                    switch (value) {
                                        case 'January':
                                            mes = "Enero";
                                            break;
                                        case 'February':
                                            mes = "Febrero";
                                            break;
                                        case 'March':
                                            mes = "Marzo";
                                            break;
                                        case 'April':
                                            mes = "Abril";
                                            break;
                                        case 'May':
                                            mes = "Mayo";
                                            break;
                                        case 'June':
                                            mes = "Junio";
                                            break;
                                        case 'July':
                                            mes = "Julio";
                                            break;
                                        case 'August':
                                            mes = "Agosto";
                                            break;
                                        case 'September':
                                            mes = "Septiembre";
                                            break;
                                        case 'October':
                                            mes = "Octubre";
                                            break;
                                        case 'November':
                                            mes = "Noviembre";
                                            break;
                                        case 'December':
                                            mes = "Diciembre";
                                            break;
                                    }
                                    return mes;
                                }
                            }
                        },
                        plotOptions: {
                            bar: {
                                borderRadius: 7,
                                borderRadiusOnAllStackedSeries: true
                            },
                        },
                        colors: colorPalette,
                        dataLabels: {
                            enabled: true,
                            formatter: function(val, opt) {
                                var redondear = Math.ceil(val);
                                let response = (redondear / 1).toFixed(2).replace(',', '.')
                                return "$ " + response.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
                            },
                        },
                    };

                    Vue.nextTick(function() {
                        chartVentas = new ApexCharts(document.querySelector("#ventas-chart"), options);
                        chartVentas.render();
                    })
                }
            }, response => console.log(response));
        },
        formatPrice(price) {
            var redondear = Math.ceil(price);
            let response = (redondear / 1).toFixed(2).replace(',', '.')
            return response.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
        },
        changeYear(year) {
            this.year_selected = year;
            this.$http.get(this.baseUrl + '/site/graficaVentas?year=' + this.year_selected).then(response => {
                this.loadYear();
                this.graficas.ventas = response.data;
                var that = this;
                this.total_ventas = 0;
                this.graficas.ventas.forEach(venta => {
                    that.total_ventas += parseFloat(venta.y);
                });
                chartVentas.updateSeries([{
                    name: "2021",
                    data: this.graficas.ventas,
                }]);
            }, response => console.log(response));
        },
        loadYear: function() {
            // ObtenerFechasPorVentas
            this.$http.get(this.baseUrl + '/site/ObtenerFechasPorVentas').then(response => {
                this.list_years = response.data;
            }, response => console.log(response));
        }
    }
});