Vue.http.options.emulateJSON = true;
var vm = new Vue({
    el: "#clients-app",
    data: {
        datosClientes: [],
        datosClientesVenta: [],

        Fechaventa: '<span class="lang" key="Fecha de venta">Fecha de venta</span>',
        Pasajerotitular: '<span class="lang" key="Pasajero titular">Pasajero titular</span>',
        Descripcion: '<span class="lang" key="Descripción">Descripción</span>',
        Observaciones: '<span class="lang" key="Observaciones">Observaciones</span>',
        // tarifatotal:'<span class="lang" key="Tarifa total">Tarifa total</span>',
        baseUrl: baseUrl,
    },
    created: function() {
        this.loadClientes();
    },
    methods: {
        loadClientes: function() {
            // this.$http.get(urlRmt + "/test/usuarios?limit=20").then(res => {
            this.$http.get(this.baseUrl + '/clientes/clientesapi').then(res => {
                this.datosClientes = res.body;
                //console.log(this.datosClientes);
                this.loadTable();
            }).catch(err => {
                console.log(err);
            });
        },
        loadTable: function() {
            var table = $("#clients-table");

            table.DataTable({
                language: { url: "https://cdn.datatables.net/plug-ins/1.10.24/i18n/Spanish.json" },
                data: this.datosClientes,
                responsive: true,
                // scrollY: 400,
                scrollX: true,
                ajax: "",
                dom: 'Bfrtip',
                bDestroy: true,
                buttons: [
                    'copy', 'csv', 'excel', 'pdf', 'print',
                ],
                columns: [
                    { data: 'id_cliente' },
                    { data: 'nombre' },
                    {
                        data: 'telefono',
                        render: function(data, type, row, meta) {
                            var phone = row.telefono.replace(/[^\w\s]/gi, '');
                            phone = phone.replace(/\s/g, '');
                            return "<a href='https://web.whatsapp.com/send?phone=52" + phone + "' target='_blank'>" + row.telefono + "</a>";
                        }
                    },
                    { data: 'correo' },
                    {
                        data: null,
                        orderable: false,
                        render: function(data) {
                            return '<a href="' + vm.baseUrl + '/clientes/view/id/' + data.id_cliente + '" class="edit-rate-record">' + feather.icons.eye.toSvg() + '</a><a onclick="eliminar(' + data.id_cliente + ')" href="javascript:void(0)" class="delete-rate-record ms-25">' + feather.icons.trash.toSvg() + '</a>';
                        }
                    },
                ]
            });
        },
        deleteClient: function(venta) {
            var that = this;
            Swal.fire({
                title: '¿Estas seguro que desea eliminarlo?',
                text: "Se eliminara permanentemente",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Eliminar',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.isConfirmed) {
                    that.$http.get(that.baseUrl + "/clientes/delete/" + venta).then(function(response) {
                        console.log(response.data.estatus);
                        if (response.data.estatus == 200) {
                            that.loadTable();
                            toastr.success("Se ha eliminado correctamente", "Servicio Eliminado", {
                                timeOut: 2000,
                                closeButton: !0,
                                debug: !1,
                                newestOnTop: !0,
                                progressBar: !0,
                                positionClass: "toast-bottom-right",
                                preventDuplicates: !0,
                                onclick: null,
                                showDuration: "300",
                                hideDuration: "100",
                                extendedTimeOut: "100",
                                showEasing: "swing",
                                hideEasing: "linear",
                                showMethod: "fadeIn",
                                hideMethod: "fadeOut",
                                tapToDismiss: !1
                            })
                        } else {
                            Swal.fire({
                                title: 'Error',
                                timer: 2000,
                                icon: 'error',
                                text: response.data.mensaje,
                            }, )
                        }
                    }, function(error) {
                        Swal.fire({
                            title: 'Error',
                            timer: 2000,
                            icon: 'error',
                            text: 'Ha ocurrido un error',
                        }, )
                    });
                }
            })
        },
    }
});

function eliminar(id) {
    vm.deleteClient(id);
}