var formatter = new Intl.NumberFormat('en-US', {
    style: 'currency',
    currency: 'USD',
    minimumFractionDigits: 2
});

$.ajax({
    type: "POST",
    url: baseUrl + "/caja/getServicesSalesAgency",
    data: {
        "year": 1,
    },
    dataType: "json",
    success: function(response) {
        obtenerTotales(response);
    }
});

function obtenerTotales(services_array) {
    var total_cobrar = 0;
    var total_pagar = 0;
    var total_ventas = 0;
    var total_dinero_ingreso = 0;

    services_array.forEach(service => {
        total_ventas += parseFloat(service.tarifa_publica);
        var fee = parseFloat(service.fee) ? parseFloat(service.fee) : 0;
        //if (parseFloat(service.fee)) total_ventas += parseFloat(service.fee);
        total_ventas += fee;

        if (service.estatus != "pagado") {
            total_cobrar += (parseFloat(service.tarifa_publica) + fee);
        }

        if (service.pagado_proveedor == 0) {
            total_pagar += parseFloat(service.costo);
        }

        service.pagosDetalles.forEach(payment => {
            total_dinero_ingreso += parseFloat(payment.monto);
        });
    });
    $("#totalPorCobrarID").html(formatter.format(total_cobrar));
    $("#totalPorPagarID").html(formatter.format(total_pagar));
    $("#totalVentasID").html(formatter.format(total_ventas));
    $("#totalIngresosID").html(formatter.format(total_dinero_ingreso));
}

$(document).ready(function() {
    $.ajax({
        type: "GET",
        url: baseUrl + "/site/ObtenerServiciosProximasAVencer",
        dataType: "json",
        success: function(response) {
            var table = $(".datatable");
            table.dataTable({
                language: { url: "https://cdn.datatables.net/plug-ins/1.10.24/i18n/Spanish.json" },
                data: response,
                scrollX: true,
                ajax: "",
                scrollY: '200px',
                scrollCollapse: true,
                paging: false,
                order: false,
                // ordering: true,
                "searching": false,
                scrollCollapse: true,
                columns: [{
                    data: "folio",
                    className: 'text-center',
                    render: function(data, type, row) {
                        return "<a href='/admin/ventas/update/" + row.id_venta + "'>" + row.folio + "</a>";
                    }
                }, {
                    data: null,
                    className: 'text-right',
                    render: function(data) {
                        var fee = parseFloat(data.fee);
                        var tarifa_publica = parseFloat(data.tarifa_publica);
                        if (isNaN(fee) || typeof fee == 'undefined') {
                            fee = 0;
                        }
                        if (isNaN(tarifa_publica) || typeof tarifa_publica == 'undefined') {
                            tarifa_publica = 0;
                        }
                        return formatter.format(parseFloat(tarifa_publica) + parseFloat(fee));
                    }
                }, {
                    data: null,
                    className: 'text-center',
                    render: function(data) {
                        return moment(data.fecha_limite).format('DD/MM/YYYY')
                    }
                }],
                footerCallback: function(row, data, start, end, display) {
                    var api = this.api();
                    var fee = 0;
                    var total = 0;
                    var tarifa_publica = 0;
                    console.log(data);
                    data.forEach(servicio => {
                        if (servicio.fee) {
                            fee += parseFloat(servicio.fee);
                        }
                        if (servicio.tarifa_publica) {
                            tarifa_publica += parseFloat(servicio.tarifa_publica);
                        }

                        if (isNaN(fee) || typeof fee == 'undefined') {
                            fee = 0;
                        }
                        if (isNaN(tarifa_publica) || typeof tarifa_publica == 'undefined') {
                            tarifa_publica = 0;
                        }
                    });

                    $(api.column(1).footer()).html(
                        formatter.format(parseFloat(tarifa_publica) + parseFloat(fee))
                    );
                }
            });
        }
    });
});