var app = new Vue({
    el: "#appproveedor",
    data: {
        nomproveedor: '<span class="lang" key="Nombre del proveedor">Nombre del proveedor</span>',
        Correo: '<span class="lang" key="Correo">Correo</span>',
        Estado: '<span class="lang" key="Estado">Estado</span>',
        detalles: '<span class="lang" key="Más detalles">Más detalles</span>',
        Eliminar: '<span class="lang" key="Eliminar">Eliminar</span>',
        nombre: "",
        detalle_proveedor: [],
        datos_generales_proveedor: [],
        contactos_proveedor: [],
        detalle_bancario: [],
        tipo_servicios: [],
        filter_tipo_servicio: "",
        filter_tipo_proveedor: "",
        baseUrl: baseUrl,
        datos: {},
    },
    created: function() {
        this.listarproveedores();
        this.tiposervicios();
        if(typeof idproveedor != "undefined") {
            this.proveedorescontactos();
            this.datosBancarios();
            this.datosGeneralesproveedor();
        }
    },
    methods: {
        viewproveedor: function(id_proveedor) {
            return this.baseUrl + '/proveedores/view/id/' + id_proveedor
        },
        eliminarProveedor: function(modelo) {
            this.modalEliminar(modelo);
        },
        modalEliminar: function(modelo) {
            Swal.fire({
                title: '¿Estas seguro que desea eliminarlo?',
                text: "Se eliminara permanentemente",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Eliminar',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.isConfirmed) {
                    this.$http.get(this.baseUrl + "/proveedores/eliminarProveedor/id/" + modelo).then(function(response) {
                        if (response.data.estatus == 200) {
                            this.listarproveedores();

                            toastr.optionsOverride = 'positionclass = "toast-bottom-right"';
                            toastr.options.positionClass = 'toast-bottom-right';
                            toastr.success('Se ha eliminado correctamente');
                        } else {
                            Swal.fire({
                                title: 'Error',
                                timer: 2000,
                                icon: 'error',
                                text: response.data.mensaje,
                            })
                        }
                    }, function(error) {
                        Swal.fire({
                            title: 'Error',
                            timer: 2000,
                            icon: 'error',
                            text: 'Ha ocurrido un error',
                        })
                    });
                }
            })
        },
        eliminarContacto: function(modelocontacto) {
            this.modalEliminarContacto(modelocontacto);
        },
        modalEliminarContacto: function(modelocontacto) {
            Swal.fire({
                title: '¿Estas seguro que desea eliminarlo?',
                text: "Se eliminara permanentemente",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Eliminar',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.isConfirmed) {
                    this.$http.get(this.baseUrl + "/proveedoresContacto/eliminarContacto/id/" + modelocontacto).then(function(response) {
                        if (response.data.estatus == 200) {
                            this.proveedorescontactos();
                            toastr.optionsOverride = 'positionclass = "toast-bottom-right"';
                            toastr.options.positionClass = 'toast-bottom-right';
                            toastr.success('Se ha eliminado correctamente');
                        } else {
                            Swal.fire({
                                title: 'Error',
                                timer: 2000,
                                icon: 'error',
                                text: response.data.mensaje,
                            }, )
                        }
                    }, function(error) {
                        Swal.fire({
                            title: 'Error',
                            timer: 2000,
                            icon: 'error',
                            text: 'Ha ocurrido un error',
                        }, )
                    });

                }
            })
        },
        listarproveedores: function() {
            this.$http
                .get(
                    this.baseUrl + '/proveedores/proveedoresapi/id/' + id_agencia
                )
                .then(function(response) {
                    this.detalle_proveedor = response.data;
                    this.datos = response.data;
                })
                .catch(function(error) {
                    console.log(error)
                });
        },
        tiposervicios: function() {
            this.$http
                .get(
                    this.baseUrl + '/tipoServicios/serviciosapi'
                )
                .then(function(response) {
                    this.tipo_servicios = response.data;
                })
                .catch(function(error) {
                    console.log(error)
                });
        },
        proveedorescontactos: function() {
            this.$http
                .get(
                    this.baseUrl + '/proveedoresContacto/proveedorescontactoapi/id/' + idproveedor
                )
                .then(function(response) {

                    this.contactos_proveedor = response.data;
                    this.datos = response.data;
                })
                .catch(function(error) {
                    console.log(error)
                });
        },
        eliminarBancario: function(modelobancario) {
            this.modalEliminarDatosBancarios(modelobancario);
        },
        modalEliminarDatosBancarios: function(modelobancario) {
            Swal.fire({
                title: '¿Estas seguro que desea eliminarlo?',
                text: "Se eliminara permanentemente",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Eliminar',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.isConfirmed) {
                    this.$http.get(this.baseUrl + "/proveedoresDetallesBanco/eliminarBancario/id/" + modelobancario).then(function(response) {
                        if (response.data.estatus == 200) {
                            this.datosBancarios();
                            toastr.optionsOverride = 'positionclass = "toast-bottom-right"';
                            toastr.options.positionClass = 'toast-bottom-right';
                            toastr.success('Se ha eliminado correctamente');
                        } else {
                            Swal.fire({
                                title: 'Error',
                                timer: 2000,
                                icon: 'error',
                                text: response.data.mensaje,
                            })
                        }
                    }, function(error) {
                        Swal.fire({
                            title: 'Error',
                            timer: 2000,
                            icon: 'error',
                            text: 'Ha ocurrido un error',
                        }, )
                    });

                }
            })
        },
        datosBancarios: function() {
            this.$http
                .get(
                    this.baseUrl + '/proveedoresDetallesBanco/proveedoresbancoapi/id/' + idproveedor
                )
                .then(function(response) {
                    this.detalle_bancario = response.data;
                    console.log(this.detalle_bancario);
                    this.datos = response.data;
                })
                .catch(function(error) {
                    console.log(error)
                });
        },
        datosGeneralesproveedor: function() {
            this.$http
                .get(
                    this.baseUrl + '/proveedores/proveedor/idproveedor/' + idproveedor
                )
                .then(function(response) {
                    this.datos_generales_proveedor = response.data;
                    console.log(this.datos_generales_proveedor);
                    this.datos = response.data;
                })
                .catch(function(error) {
                    console.log(error)
                });
        },
        getSoldServices: function(provider) {
            var services = provider.map(item => item.idTipoServicio.tipo_servicio);
            var string_services = services.join(", ");
            return string_services.length > 0 ? string_services : "Sin registro";
        },
        setTipoServicio: function() {
            if(this.filter_tipo_proveedor != "turistico") {
                this.filter_tipo_servicio = "";
            }
        }
    },
    computed: {
        filterProviders: function() {
            var that = this;
            return this.detalle_proveedor.filter(tp => {
                if(this.filter_tipo_proveedor != "") {
                    return tp.tipo_proveedor == this.filter_tipo_proveedor;
                }
                return tp;
            })
            .filter(tsp => {
                if(this.filter_tipo_servicio != "") {
                    return tsp.tiposerviciosProveedores.some(tipo_servicio => {
                        return tipo_servicio.id_tipo_servicio == that.filter_tipo_servicio;
                    })
                }
                return tsp;
            })
        }
    }
});