Vue.http.options.emulateJSON = true;
var formatter = new Intl.NumberFormat('en-US', {
    style: 'currency',
    currency: 'USD',
    minimumFractionDigits: 2
        // These options are needed to round to whole numbers if that's what you want.
        //minimumFractionDigits: 0, // (this suffices for whole numbers, but will print 2500.10 as $2,500.1)
        //maximumFractionDigits: 0, // (causes 2500.99 to be printed as $2,501)
});

const Toastr = Swal.mixin({
    toast: true,
    position: 'top-end',
    showConfirmButton: false,
    timer: 3000,
    timerProgressBar: true,
    didOpen: (toast) => {
        toast.addEventListener('mouseenter', Swal.stopTimer)
        toast.addEventListener('mouseleave', Swal.resumeTimer)
    }
})

var vm = new Vue({
    el: "#app-table",
    data: {
        Fechaventa: '<span class="lang" key="Fecha de venta">Fecha de venta</span>',
        Pasajerotitular: '<span class="lang" key="Pasajero titular">Pasajero titular</span>',
        Descripcion: '<span class="lang" key="Descripción">Descripción</span>',
        Observaciones: '<span class="lang" key="Observaciones">Observaciones</span>',
        tarifatotal: '<span class="lang" key="Tarifa total">Tarifa total</span>',
        costototal: '<span class="lang" key="Costo total">Costo total</span>',
        baseUrl: baseUrl,
        datatableServicios: {},
        baseUrl: baseUrl,
    },
    created: function() {
        // this.loadServicios();
    },
    mounted: function() {
        this.loadServicios();
    },
    methods: {
        loadServicios: function() {
            $("#ventas_agencia thead tr").clone(!0).appendTo("#ventas_agencia thead"), $("#ventas_agencia thead tr:eq(1) th").each((function(t) {
                var a = $(this).text();
                if(t != 10) {
                    $(this).html('<input type="text" class="form-control form-control-sm" placeholder="BUSCAR ' + a + '" />'), $("input", this).on("keyup change", (function() {
                        vm.ventas_table.column(t).search() !== this.value && vm.ventas_table.column(t).search(this.value).draw()
                    }))
                }
            }));

            var url_rq = this.baseUrl + "/ventas/ventasapi"
            var that = this;
            this.ventas_table = $("#ventas_agencia").DataTable({
                language: { url: "https://cdn.datatables.net/plug-ins/1.10.24/i18n/Spanish.json" },
                scrollX: true,
                ajax: {
                    url: url_rq,
                    dataSrc: function(json) {
                        this.datatableServicios = json;
                        return json;
                    }
                },
                dom: '<"d-flex justify-content-between align-items-center mx-0 row"<"col-sm-12 col-md-6"B><"col-sm-12 col-md-6"f>>t<"d-flex justify-content-between mx-0 row"<"col-sm-12 col-md-6"i><"col-sm-12 col-md-6"p>>',
                bDestroy: true,
                buttons:[{
                    extend: "collection",
                    className: "btn btn-outline-secondary dropdown-toggle me-2",
                    text: feather.icons.share.toSvg({ class: "font-small-4 me-50" }) + "Exportar",
                    buttons: [{
                        extend: "csv",
                        text: feather.icons["file-text"].toSvg({ class: "font-small-4 me-50" }) + "Csv",
                        className: "dropdown-item",
                        //exportOptions: { columns: [3, 4, 5, 6, 7] } 
                    }, {
                        extend: "excel",
                        text: feather.icons.file.toSvg({ class: "font-small-4 me-50" }) + "Excel",
                        className: "dropdown-item",
                    }, {
                        extend: "pdf",
                        text: feather.icons.clipboard.toSvg({ class: "font-small-4 me-50" }) + "Pdf",
                        className: "dropdown-item",
                    }, {
                        extend: "copy",
                        text: feather.icons.copy.toSvg({ class: "font-small-4 me-50" }) + "Copiar",
                        className: "dropdown-item",
                    }],
                    init: function(e, t, a) {
                        $(t).removeClass("btn-secondary"), $(t).parent().removeClass("btn-group"), setTimeout((function() { $(t).closest(".dt-buttons").removeClass("btn-group").addClass("d-inline-flex") }), 50)

                    }
                }],
                "drawCallback": function(settings, json) {
                    vm.addCssToTable();
                },
                scrollCollapse: true,
                columns: [{
                        data: null, //folio
                        className: "text-center",
                        render: function(data) {

                            return "<a href='" + this.baseUrl + "/ventas/update/" + data.id_venta + "'>" + data.folio + "</a>";
                        }
                    },
                    {
                        data: null, //fecha
                        className: "text-center",
                        render: function(data) {
                            return moment(data.fecha).format('DD/MM/YYYY');
                        }
                    },
                    {
                        data: null, //fecha
                        className: "text-center",
                        render: function(data) {
                            return data.agente;
                        }
                    },
                    {
                        data: null, //tarifa publica
                        className: "text-right",
                        render: function(data) {
                            var dataServicio = data.ventasServicioses;
                            var total = 0;
                            dataServicio.forEach(servicio => {
                                var tarifa_publica = parseFloat(servicio.tarifa_publica);
                                total += tarifa_publica;
                            });
                            return formatter.format(total);
                        }
                    },
                    {
                        data: null, //costo
                        className: "text-right",
                        render: function(data) {
                            var aux = parseFloat(data.costototalporventa);
                            if(isNaN(aux) || typeof aux == "undefined") {
                                return formatter.format(0);
                            }
                            return formatter.format(data.costototalporventa);
                        }
                    },
                    {
                        data: null, //fee
                        className: 'text-center',
                        render: function(data) {
                            var dataServicio = data.ventasServicioses;
                            var total = 0;
                            dataServicio.forEach(servicio => {
                                var fee = parseFloat(servicio.fee);
                                if (isNaN(fee) || typeof fee == 'undefined') {
                                    fee = 0;
                                }
                                total += fee;
                            });
                            return formatter.format(total);
                        }
                    },
                    {
                        data: null, //cargo por servicios
                        className: 'text-center',
                        render: function(data) {
                            if(parseFloat(data.cargo_servicios)) {
                                return formatter.format(parseFloat(data.cargo_servicios));
                            }
                            return "$ 0.00";
                        }
                    },
                    {
                        data: null, //cargo por servicios / 2
                        className: 'text-center',
                        render: function(data) {
                            if(parseFloat(data.cargo_servicios)) {
                                return formatter.format(parseFloat(data.cargo_servicios) / 2);
                            }
                            return "$ 0.00";
                        }
                    },
                    {
                        data: null, //total
                        className: "text-right",
                        render: function(data) {
                            var dataServicio = data.ventasServicioses;
                            var total = 0;
                            dataServicio.forEach(servicio => {
                                var tarifa_publica = parseFloat(servicio.tarifa_publica);
                                var fee = parseFloat(servicio.fee);
                                if (isNaN(fee) || typeof fee == 'undefined') {
                                    fee = 0;
                                }
                                total += tarifa_publica + fee;
                            });
                            return formatter.format(total);
                        }
                    }, {
                        data: null, //utilidad
                        className: "text-right",
                        render: function(data) {
                            var dataServicio = data.ventasServicioses;
                            var costo = 0;
                            var aux_costo = parseFloat(data.costototalporventa);
                            if(isNaN(aux_costo) || typeof aux_costo == "undefined") {
                                coston = 0;
                            } else {
                                costo = data.costototalporventa;
                            }

                            var total = 0;
                            dataServicio.forEach(servicio => {
                                var tarifa_publica = parseFloat(servicio.tarifa_publica);
                                var fee = parseFloat(servicio.fee);
                                if (isNaN(fee) || typeof fee == 'undefined') {
                                    fee = 0;
                                }
                                total += tarifa_publica + fee;
                            });
                            var utilidad = total - costo;
                            return formatter.format(utilidad);
                        }
                    }
                ],
                "footerCallback": function(row, data, start, end, display) {
                    var api = this.api();
                    var tarifa_publica = 0;
                    var costo_total = 0;
                    var feePublic = 0;
                    var cargo_servicios = 0;
                    var total = 0;
                    var utilidad = 0;
                    data.forEach(venta => {
                        venta.ventasServicioses.forEach(servicio => {
                            var fee = parseFloat(servicio.fee);
                            var tpublic = parseFloat(servicio.tarifa_publica);
                            var costo = parseFloat(servicio.costo);
                            if (isNaN(fee) || typeof fee == 'undefined') {
                                fee = 0;
                            }
                            if (isNaN(tpublic) || typeof tpublic == 'undefined') {
                                tpublic = 0;
                            }
                            tarifa_publica += tpublic;
                            costo_total += costo;
                            feePublic += fee;
                            total = tarifa_publica + feePublic;
                        });
                        if(parseFloat(venta.cargo_servicios)) cargo_servicios += parseFloat(venta.cargo_servicios);
                    });
                    utilidad = total - costo_total;
                    $(api.column(3).footer()).html(
                        formatter.format(tarifa_publica)
                    );
                    $(api.column(4).footer()).html(
                        formatter.format(costo_total)
                    );
                    $(api.column(5).footer()).html(
                        formatter.format(feePublic)
                    );
                    $(api.column(6).footer()).html(
                        formatter.format(cargo_servicios)
                    );
                    $(api.column(7).footer()).html(
                        formatter.format(cargo_servicios / 2)
                    );
                    $(api.column(8).footer()).html(
                        formatter.format(total)
                    );
                    $(api.column(9).footer()).html(
                        formatter.format(utilidad)
                    );
                }

            });
        },
        addCssToTable: function() {
            setTimeout(() => {}, 1000);
        },
    },
});