var app = new Vue({
    el: "#appusuarios",
    data: {
        Activado: '<span class="badge rounded-pill bg-success lang" key="Activo">Activo</span>',
        Desactivado: '<span class="badge rounded-pill bg-danger lang" key="Desactivado">Desactivado</span>',
        Editar: '<p class="mb-0 lang" key="Editar">Editar</p>',
        Eliminar: '<p class="mb-0 lang" key="Eliminar">Eliminar</p>',
        infodetallada: '<span class="lang" key="Información detallada de">Información detallada de</span>',
        Nombre: '<span class="lang" key="Nombre">Nombre</span>',
        Usuario: '<span class="lang" key="Usuario">Usuario</span>',
        Correo: '<span class="lang" key="Correo">Usuario</span>',
        Telefono: '<span class="lang" key="Teléfono">Teléfono</span>',
        Direccion: '<span class="lang" key="Dirección">Dirección</span>',
        nacimiento: '<span class="lang" key="Fecha de nacimiento">Fecha de nacimiento</span>',
        visita: '<span class="lang" key="Última visita">Última visita</span>',
        Rol: '<span class="lang" key="Rol">Rol</span>',
        Aceptar: '<button type="button" class="btn btn-primary lang" key="Aceptar" data-bs-dismiss="modal">Aceptar</button>',
        nombre: "",
        detalle_usuario: [],
        baseUrl: baseUrl,
        datos: {},
    },
    created: function() {
        this.promociones();
    },
    methods: {
        viewproveedor: function(id_proveedor) {
            return this.baseUrl + '/proveedores/view/id/' + id_proveedor
        },
        eliminarUsuario: function(modelo) {
            this.modalEliminar(modelo);
        },
        modalEliminar: function(modelo) {
            Swal.fire({
                title: '¿Estas seguro que desea eliminarlo?',
                text: "Se eliminara permanentemente",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Eliminar',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.isConfirmed) {
                    this.$http.get(this.baseUrl + "/usuariosAgencias/eliminarUsuario/id/" + modelo).then(function(response) {
                        if (response.data.estatus == 200) {
                            this.promociones();
                            Swal.fire({
                                title: 'Eliminado',
                                timer: 2000,
                                icon: 'success',
                                text: 'Se ha eliminado correctamente el mensaje',
                            }, )
                        } else {
                            Swal.fire({
                                title: 'Error',
                                timer: 2000,
                                icon: 'error',
                                text: response.data.mensaje,
                            }, )
                        }
                    }, function(error) {
                        Swal.fire({
                            title: 'Error',
                            timer: 2000,
                            icon: 'error',
                            text: 'Ha ocurrido un error',
                        }, )
                    });
                }
            })
        },
        promociones: function() {
            this.$http
                .get(
                    this.baseUrl + '/usuariosAgencias/usuariosApi/id/' + id_agencia
                )
                .then(function(response) {
                    this.detalle_usuario = response.data;
                    this.datos = response.data;
                })
                .catch({});
        },
        formatDate: function(date_string, format) {
            return moment(date_string).format(format);
        }
    },
});