
var vm = new Vue({
	el: "#ventas_cliente",
	data: {
		datosServicios: [],
		tableclienteVentas: {},
		baseUrl: baseUrl,
	},
	created: function () {
		this.loadclienteVentas();
	},
	methods: {
		loadclienteVentas: function () {
			this.$http.get(this.baseUrl + '/clientes/clienteventa/' + id_cliente).then(res => {
				this.tableclienteVentas = res.body;
				console.log(this.tableclienteVentas);
				this.loadTable();
			}).catch(err => {
				console.log(err);
			});
		},
		loadTable() {
			var table = $(".datatable");
			table.DataTable(
				{
					language: { url: "https://cdn.datatables.net/plug-ins/1.10.24/i18n/Spanish.json" },
					data: this.tableclienteVentas,
					responsive: true,
					scrollY: 400,
					ajax: "",
					dom: 'Bfrtip',
					bDestroy: true,
					buttons: [
						'copy', 'csv', 'excel', 'pdf', 'print',
					],
					columns: [
						{ data: 'folio' },
						{ data: 'fecha' },
						{ data: 'pasajero_titular' },
						{ data: 'descripcion' },
						{ data: 'observaciones' },
						{
							data: null,
							orderable: false,
							render: function (data) {
								// return '<a href="'+ vm.baseUrl +'/ventas/update/' + data.id_venta + '" class="edit-rate-record" ><i class="far fa-eye"></i></a></br><a onclick="eliminar(' + data.id_venta + ')" href="javascript:void(0)" class="delete-rate-record ml-1"><i class="fas fa-trash"></i></a>';
								// return '<a href="'+ vm.baseUrl +'/ventas/update/' + data.id_venta + '" class="edit-rate-record" ><i class="far fa-eye"></i></a></br><a onclick="eliminar(' + data.id_venta + ')" href="javascript:void(0)" class="delete-rate-record ms-25">' + feather.icons["x-circle"].toSvg() + '</a>';
								return '<a href="'+ vm.baseUrl +'/ventas/update/' + data.id_venta + '" class="edit-rate-record" ><i class="far fa-eye"></i></a>';
							}
						}
					]
				}
			);
		},
		eliminarVenta: function(venta) {
            this.modalEliminarventa(venta);
        },
        modalEliminarventa: function(venta) {
            var that = this;
            Swal.fire({
                title: '¿Estas seguro que desea eliminarlo?',
                text: "Cambiará el estatus de la venta y los servicios",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Eliminar',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.isConfirmed) {
                    that.$http.get(that.baseUrl + "/ventas/delete/" + venta).then(function(response) {
                        if (response.data.success) {
                            that.loadTable();
                            Toast.fire({
                                icon: 'success',
                                title: 'Se ha cambiado el estatus de la venta y servicios'
                            });
                        } else {
                            Swal.fire({
                                title: 'Error',
                                timer: 2000,
                                icon: 'error',
                                text: response.data.mensaje,
                            }, )
                        }
                    }, function(error) {
                        Swal.fire({
                            title: 'Error',
                            timer: 2000,
                            icon: 'error',
                            text: 'Ha ocurrido un error',
                        }, )
                    });
                }
            })
        },

		// eliminarVenta: function (venta) {
		// 	this.modalEliminarventa(venta);
		// },
		// modalEliminarventa: function (venta) {
		// 	var that = this;
		// 	Swal.fire({
		// 		title: '¿Estas seguro que desea eliminarlo?',
		// 		text: "Se eliminara permanentemente",
		// 		icon: 'warning',
		// 		showCancelButton: true,
		// 		confirmButtonColor: '#3085d6',
		// 		cancelButtonColor: '#d33',
		// 		confirmButtonText: 'Eliminar',
		// 		cancelButtonText: 'Cancelar'
		// 	}).then((result) => {
		// 		if (result.isConfirmed) {
		// 			that.$http.get(that.baseUrl + "/ventas/eliminarVenta/id/" + venta).then(function (response) {
		// 				console.log(response.data.estatus);
		// 				if (response.data.estatus == 200) {
		// 					that.loadTable();
		// 					toastr.success("Se ha eliminado correctamente", "Servicio Eliminado",
		// 						{
		// 							timeOut: 2000,
		// 							closeButton: !0,
		// 							debug: !1,
		// 							newestOnTop: !0,
		// 							progressBar: !0,
		// 							positionClass: "toast-bottom-right",
		// 							preventDuplicates: !0,
		// 							onclick: null,
		// 							showDuration: "300",
		// 							hideDuration: "100",
		// 							extendedTimeOut: "100",
		// 							showEasing: "swing",
		// 							hideEasing: "linear",
		// 							showMethod: "fadeIn",
		// 							hideMethod: "fadeOut",
		// 							tapToDismiss: !1
		// 						})
		// 				} else {
		// 					Swal.fire(
		// 						{
		// 							title: 'Error',
		// 							timer: 2000,
		// 							icon: 'error',
		// 							text: response.data.mensaje,
		// 						},
		// 					)
		// 				}
		// 			}, function (error) {
		// 				Swal.fire(
		// 					{
		// 						title: 'Error',
		// 						timer: 2000,
		// 						icon: 'error',
		// 						text: 'Ha ocurrido un error',
		// 					},
		// 				)
		// 			});
		// 		}
		// 	})
		// },
	},
});
function eliminar(id) {
	vm.eliminarVenta(id);
}