const Toast = Swal.mixin({
    toast: true,
    position: 'bottom-end',
    timer: 3000,
    showConfirmButton: false,
    //timerProgressBar: true,
});

Vue.http.options.emulateJSON = true;
var vm = new Vue({
    el: "#ventas_agencia",
    data: {
        Fechaventa: '<span class="lang" key="Fecha de venta">Fecha de venta</span>',
        Pasajerotitular: '<span class="lang" key="Pasajero titular">Pasajero titular</span>',
        Descripcion: '<span class="lang" key="Descripción">Descripción</span>',
        Observaciones: '<span class="lang" key="Observaciones">Observaciones</span>',
        tarifatotal: '<span class="lang" key="Tarifa total">Tarifa total</span>',
        costototal: '<span class="lang" key="Costo total">Costo total</span>',
        baseUrl: baseUrl,
        datosServicios: [],
        datatableServicios: {},
        baseUrl: baseUrl,
    },
    created: function() {
        this.loadServicios();
    },
    methods: {
        loadServicios: function() {
            this.$http.get(this.baseUrl + '/ventas/ventasapi').then(res => {
                this.datatableServicios = res.body;
                this.loadTable();
            }).catch(err => {
                console.log(err);
            });
        },
        eliminarServicio: function(servicio) {
            this.modalEliminar(servicio);
        },
        modalEliminar: function(servicio) {
            Swal.fire({
                title: '¿Estas seguro que desea eliminarlo?',
                text: "Se eliminara permanentemente",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Eliminar',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.isConfirmed) {
                    this.$http.get(this.baseUrl + "/ventas/deleteServicios/id/" + servicio).then(function(response) {
                        if (response.data.estatus == 200) {
                            this.listarServicios();
                            toastr.success("Se ha eliminado correctamente", "Servicio Eliminado", {
                                timeOut: 2000,
                                closeButton: !0,
                                debug: !1,
                                newestOnTop: !0,
                                progressBar: !0,
                                positionClass: "toast-bottom-right",
                                preventDuplicates: !0,
                                onclick: null,
                                showDuration: "300",
                                hideDuration: "100",
                                extendedTimeOut: "100",
                                showEasing: "swing",
                                hideEasing: "linear",
                                showMethod: "fadeIn",
                                hideMethod: "fadeOut",
                                tapToDismiss: !1
                            })
                        } else {
                            Swal.fire({
                                title: 'Error',
                                timer: 2000,
                                icon: 'error',
                                text: response.data.mensaje,
                            }, )
                        }
                    }, function(error) {
                        Swal.fire({
                            title: 'Error',
                            timer: 2000,
                            icon: 'error',
                            text: 'Ha ocurrido un error',
                        }, )
                    });
                }
            })
        },
        eliminarVenta: function(venta) {
            this.modalEliminarventa(venta);
        },
        modalEliminarventa: function(venta) {
            var that = this;
            Swal.fire({
                title: '¿Estas seguro que desea eliminarlo?',
                text: "Cambiará el estatus de la venta y los servicios",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Eliminar',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.isConfirmed) {
                    that.$http.get(that.baseUrl + "/ventas/delete/" + venta).then(function(response) {
                        if (response.data.success) {
                            that.loadServicios();
                            Toast.fire({
                                icon: 'success',
                                title: 'Se ha cambiado el estatus de la venta y servicios'
                            });
                        } else {
                            Swal.fire({
                                title: 'Error',
                                timer: 2000,
                                icon: 'error',
                                text: response.data.mensaje,
                            }, )
                        }
                    }, function(error) {
                        Swal.fire({
                            title: 'Error',
                            timer: 2000,
                            icon: 'error',
                            text: 'Ha ocurrido un error',
                        }, )
                    });
                }
            })
        },
        loadTable() {
            var table = $(".datatable");
            table.DataTable({
                language: { url: "https://cdn.datatables.net/plug-ins/1.10.24/i18n/Spanish.json" },
                data: this.datatableServicios,
                scrollX: true,
                dom: '<"d-flex justify-content-between align-items-center mx-0 row"<"col-sm-12 col-md-6"B><"col-sm-12 col-md-6"f>>t<"d-flex justify-content-between mx-0 row"<"col-sm-12 col-md-6"i><"col-sm-12 col-md-6"p>>',
                bDestroy: true,
                buttons: [{
                    extend: "collection",
                    className: "btn btn-outline-secondary dropdown-toggle me-2",
                    text: feather.icons.share.toSvg({ class: "font-small-4 me-50" }) + "Exportar",
                    buttons: [{
                        extend: "csv",
                        text: feather.icons["file-text"].toSvg({ class: "font-small-4 me-50" }) + "Csv",
                        className: "dropdown-item",
                        //exportOptions: { columns: [3, 4, 5, 6, 7] } 
                    }, {
                        extend: "excel",
                        text: feather.icons.file.toSvg({ class: "font-small-4 me-50" }) + "Excel",
                        className: "dropdown-item",
                    }, {
                        extend: "pdf",
                        text: feather.icons.clipboard.toSvg({ class: "font-small-4 me-50" }) + "Pdf",
                        className: "dropdown-item",
                    }, {
                        extend: "copy",
                        text: feather.icons.copy.toSvg({ class: "font-small-4 me-50" }) + "Copiar",
                        className: "dropdown-item",
                    }],
                    init: function(e, t, a) {
                        $(t).removeClass("btn-secondary"), $(t).parent().removeClass("btn-group"), setTimeout((function() { $(t).closest(".dt-buttons").removeClass("btn-group").addClass("d-inline-flex") }), 50)

                    }
                }],
                order: [[ 2, "desc" ]],
                scrollCollapse: true,
                columns: [{
                    data: 'folio',
                    title: '# Folio'
                }, {
                    data: 'fecha',
                    title: 'Fecha de venta',
                    render: $.fn.dataTable.render.moment('DD/MM/YYYY'),
                    /* render: function(data) {
                        return moment(data).format("DD/MM/YYYY");
                    } */
                }, {
                    data: 'pasajero_titular',
                    title: 'Pasajero Titular',
                }, {
                    data: 'descripcion',
                    title: 'Descripción',
                }, {
                    data: 'observaciones',
                    title: 'Observaciones'
                }, {
                    data: null,
                    title: '',
                    width: "9%",
                    orderable: false,
                    render: function(data, row) {
                        return '<a href="' + vm.baseUrl + '/caja/accountDetail/' + data.id_venta + '" target="_blank">' + feather.icons.eye.toSvg() + '</a><a href="' + vm.baseUrl + '/ventas/update/' + data.id_venta + '" class="edit-rate-record ms-25">' + feather.icons.edit.toSvg() + '</a><a onclick="eliminar(' + data.id_venta + ')" href="javascript:void(0)" class="delete-rate-record ms-25">' + feather.icons["x-circle"].toSvg() + '</a>';
                    }
                }, ]
            });
        },
    },
});

function eliminar(id) {
    vm.eliminarVenta(id);
}