<?php

class AgenciaController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout = '//layouts/column1';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array(
				'allow',  // allow all users to perform 'index' and 'view' actions
				'actions' => array('index', 'view', 'miAgencia', 'update', 'usuarios', 'usuariosapi', 'agenciaApi', 'eliminarUsuario', 'cuentas', 'terminos', 'firmadigital'),
				'users' => array('@'),
			),
			array(
				'allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions' => array('create', 'update', 'GeneratePdf', 'GenerateExcel', 'eliminarUsuario'),
				'users' => array('@'),
			),
			array(
				'allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions' => array('admin', 'delete', 'eliminarUsuario'),
				'users' => array('admin'),
			),
			array(
				'deny',  // deny all users
				'users' => array('*'),
			),
		);
	}

	public function actionFirmaDigital() {
		$this->render('firmadigital');
	}

	public function actionTerminos() {
		$this->render('terminos');
	}

	public function actionCuentas() {
		$this->render('cuentas');
	}

	public function actionUsuariosApi()
	{
		$usuarios = UsuariosAgencias::model()->with(array('idUsuario', 'idUsuario.profiles'))->findAll('t.id_agencia=' . $_SESSION['Agencia']->id_agencia);
		$general = Yii::app()->createController('general')[0];
		$usuario = $general->convertModelToArray($usuarios);
		echo json_encode($usuario);
	}

	public function actionagenciaApi()
	{
		$agenciaapi = Agencia::model()->findByPk($_SESSION['Agencia']->id_agencia);
		echo CJSON::encode($agenciaapi);
	}

	public function actionUsuarios()
	{
		$this->render('usuarios');
	}

	public function actionmiAgencia()
	{
		$this->render('miagencia');
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view', array(
			'model' => $this->loadModel($id),
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model = new Agencia;

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if (isset($_POST['Agencia'])) {
			$model->attributes = $_POST['Agencia'];
			if ($model->save())
				$this->redirect(array('view', 'id' => $model->id_agencia));
		}
		$this->render('create', array(
			'model' => $model,
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model = $this->loadModel($id);
		$fotologo = $model->logotipo;
		if (isset($_POST['Agencia'])) {
			$replaceList = array(")", "(", "-", " ");
			$_POST['Agencia']['telefono'] = trim(str_replace($replaceList, "", $_POST['Agencia']['telefono']));
			$_POST['Agencia']['whatsapp'] = trim(str_replace($replaceList, "", $_POST['Agencia']['whatsapp']));
			$model->attributes = $_POST['Agencia'];

			$target_dir = "images/agencia/";
			$target_file = $target_dir . date("is") . str_replace(' ', '-', $_FILES['Agencia']['name']['logotipo']);
			if ($_FILES['Agencia']['tmp_name']['logotipo'] != "") {
				if (move_uploaded_file($_FILES['Agencia']['tmp_name']['logotipo'], $target_file)) {
					$model->logotipo = date("is") . str_replace(' ', '-', $_FILES['Agencia']['name']['logotipo']);
				}
			}

			if ($model->save()) {
				if ($fotologo != "" && $_FILES['Agencia']['tmp_name']['logotipo'] != "") {
					unlink($target_dir . $fotologo);
				}
				Yii::app()->user->setFlash('success', "Los cambios han sido guardados.");
				$this->redirect(array('miagencia'));
			}
		}

		if ($_SESSION['Agencia']->id_agencia == $model->id_agencia) {
			$this->render('update', array('model' => $model));
		} else {
			$this->redirect(array('update', 'id' => $_SESSION['Agencia']->id_agencia));
		}
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		if (Yii::app()->request->isPostRequest) {
			// we only allow deletion via POST request
			$this->loadModel($id)->delete();

			// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
			if (!isset($_GET['ajax']))
				$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
		} else
			throw new CHttpException(400, 'Invalid request. Please do not repeat this request again.');
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		$session = new CHttpSession;
		$session->open();
		$criteria = new CDbCriteria();

		$model = new Agencia('search');
		$model->unsetAttributes();  // clear any default values

		if (isset($_GET['Agencia'])) {
			$model->attributes = $_GET['Agencia'];
			if (!empty($model->id_agencia)) $criteria->addCondition("id_agencia = '" . $model->id_agencia . "'");

			if (!empty($model->nombre_comercial)) $criteria->addCondition("nombre_comercial = '" . $model->nombre_comercial . "'");

			if (!empty($model->telefono)) $criteria->addCondition("telefono = '" . $model->telefono . "'");

			if (!empty($model->correo)) $criteria->addCondition("correo = '" . $model->correo . "'");

			if (!empty($model->direccion)) $criteria->addCondition("direccion = '" . $model->direccion . "'");

			if (!empty($model->cuidad)) $criteria->addCondition("cuidad = '" . $model->cuidad . "'");

			if (!empty($model->estado)) $criteria->addCondition("estado = '" . $model->estado . "'");

			if (!empty($model->codigo_postal)) $criteria->addCondition("codigo_postal = '" . $model->codigo_postal . "'");

			if (!empty($model->logotipo)) $criteria->addCondition("logotipo = '" . $model->logotipo . "'");

			if (!empty($model->sitio_web)) $criteria->addCondition("sitio_web = '" . $model->sitio_web . "'");

			if (!empty($model->estatus)) $criteria->addCondition("estatus = '" . $model->estatus . "'");

			if (!empty($model->log)) $criteria->addCondition("log = '" . $model->log . "'");

			$session['Agencia_records'] = Agencia::model()->findAll($criteria);
		}

		$this->render('index', array(
			'model' => $model,
		));
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model = new Agencia('search');
		$model->unsetAttributes();  // clear any default values
		if (isset($_GET['Agencia']))
			$model->attributes = $_GET['Agencia'];

		$this->render('admin', array(
			'model' => $model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer the ID of the model to be loaded
	 */
	public function loadModel($id)
	{
		$model = Agencia::model()->findByPk($id);
		if ($model === null)
			throw new CHttpException(404, 'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param CModel the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if (isset($_POST['ajax']) && $_POST['ajax'] === 'agencia-form') {
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}

	public function actionGenerateExcel()
	{
		$session = new CHttpSession;
		$session->open();

		if (isset($session['Agencia_records'])) {
			$model = $session['Agencia_records'];
		} else
			$model = Agencia::model()->findAll();

		Yii::app()->request->sendFile(
			date('YmdHis') . '.xls',
			$this->renderPartial('excelReport', array(
				'model' => $model
			), true)
		);
	}

	public function actionGeneratePdf()
	{
		$session = new CHttpSession;
		$session->open();
		Yii::import('application.extensions.bootstrap.gii.*');
		require_once('bootstrap/tcpdf/tcpdf.php');
		require_once('bootstrap/tcpdf/config/lang/eng.php');

		if (isset($session['Agencia_records'])) {
			$model = $session['Agencia_records'];
		} else
			$model = Agencia::model()->findAll();

		$html = $this->renderPartial('expenseGridtoReport', array(
			'model' => $model
		), true);

		//die($html);

		$pdf = new TCPDF();
		$pdf->SetCreator(PDF_CREATOR);
		$pdf->SetAuthor(Yii::app()->name);
		$pdf->SetTitle('Agencia Report');
		$pdf->SetSubject('Agencia Report');
		//$pdf->SetKeywords('example, text, report');
		$pdf->SetHeaderData('', 0, "Report", '');
		$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, "Example Report by " . Yii::app()->name, "");
		$pdf->setHeaderFont(array('helvetica', '', 8));
		$pdf->setFooterFont(array('helvetica', '', 6));
		$pdf->SetMargins(15, 18, 15);
		$pdf->SetHeaderMargin(5);
		$pdf->SetFooterMargin(10);
		$pdf->SetAutoPageBreak(TRUE, 0);
		$pdf->SetFont('dejavusans', '', 7);
		$pdf->AddPage();
		$pdf->writeHTML($html, true, false, true, false, '');
		$pdf->LastPage();
		$pdf->Output("Agencia_002.pdf", "I");
	}
}
