<?php

class BodasController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout = '//layouts/column1';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array(
				'allow', 
				'actions' => array('apiBoda'),
				'users' => array('*'),
			),
			array(
				'allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions' => array('BodasApi', 'index', 'view', 'sendInvitations', 'updateInvitation'),
				'users' => array('@'),
			),
			array(
				'allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions' => array('admin', 'delete'),
				'users' => array('admin'),
			),
			array(
				'deny',  // deny all users
				'users' => array('*'),
			),
		);
	}

	public function actionIndex() {
		$this->render('/grupos/index', array(
			"group_type" => "bodas"
		));
	}

	public function actionView($id) {
		$this->render('/grupos/view', array(
			"group_type" => "boda"
		));
	}

	public function actionUpdateInvitation() {
		$invitation = Invitaciones::model()->findByPk($_POST["id_invitacion"]);
		$invitation->attributes = $_POST;

		if(is_uploaded_file($_FILES["file_invitacion"]["tmp_name"])) {
			$file_name = $invitation->id_invitacion .'-'. str_replace(' ', '-', $_FILES['file_invitacion']['name']);
			$file_url = 'images/invitaciones/'. $file_name;
			move_uploaded_file($_FILES['file_invitacion']['tmp_name'], $file_url);
			if(!is_null($invitation->img)) {
				$last_img = "images/invitaciones/". $invitation->img;
				unlink($last_img);
			}
			$invitation->img = $file_name;
		}

		if($invitation->save()) {
			echo CJSON::encode($invitation);
		} else {
			echo CJSON::encode($invitation->getErrors());
		}
	}

	public function actionSendInvitations() {
		Yii::import('application.extensions.phpmailer.*');
		$invitation = Invitaciones::model()->findByPk($_POST["id_invitacion"]);
		$response = array();

		$guests_array = explode(",", $_POST["guests"]);
		foreach ($guests_array as $key => $value) {
			$guest = HabitacionesHuespedes::model()->findByPk($value);
			$mail = new JPhpMailer;
			$mail->IsSMTP();
			$mail->Host = Yii::app()->params->host;
			$mail->SMTPAuth = true;
			$mail->Username = Yii::app()->params->username;
			$mail->Port = '26';
			$mail->Password = Yii::app()->params->password;
			$mail->SMTPKeepAlive = true;
			$mail->Mailer = "smtp";
			$mail->IsSMTP();
			$mail->SMTPAuth = true;
			$mail->CharSet = 'utf-8';
			$mail->SMTPDebug  = 0;
	
			$mail->SetFrom($_SESSION["Usuario"]->idUsuario->email, "");
			$mail->Subject = "Invitación boda - " . $invitation->idBoda->titulo_evento;
			$mail->AddAddress($guest->correo, ($guest->nombres ." ". $guest->apellidos));
	
			$mail->addAttachment($_SERVER["DOCUMENT_ROOT"] .'/admin/images/invitaciones/'. $invitation->img);
	
			$mail->AltBody = "To view the message, please use an HTML compatible email viewer!";
			$mail->MsgHTML($invitation->texto);
	
			if ($mail->send()) {
				array_push($response, array(
					"success" => true,
					"guest" => $guest
				));
			} else {
				array_push($response, array(
					"success" => false,
					"guest" => $guest
				));
			}
		}

		echo CJSON::encode($response);
	}

	public function actionBodasApi() {
		//$additional_sql = $_SESSION["Usuario"]->rol == "Agente" ? " AND idVenta.id_usuario = ". Yii::app()->user->id : "";
		$bodas = Grupos::model()->with('idAgencia', 'idVentaservicio.idVenta', 'idCliente')->findAll('t.id_agencia = "'. $_SESSION['Agencia']->id_agencia .'" AND t.tipo = "Boda"'. $additional_sql);
		$general = Yii::app()->createController('general')[0];
		$array = $general->convertModelToArray($bodas);
		echo json_encode($array);
	}

	public function actionapiBoda($id) {
		header('Access-Control-Allow-Origin: *');
		header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
		header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
		header("Allow: GET, POST, OPTIONS, PUT, DELETE");
		
		$bodas = Grupos::model()->with('idAgencia','idVentaservicio','idVentaservicio.idVenta')->findAll('t.id_cliente="'.$id.'" AND t.tipo="Boda"');
		$general = Yii::app()->createController('general')[0];
		$array = $general->convertModelToArray($bodas);
		echo json_encode($array);
	}
}