<?php
Yii::import('application.extensions.bootstrap.gii.*');
require_once('bootstrap/tcpdf/tcpdf.php');
require_once('bootstrap/tcpdf/config/lang/eng.php');

class CajaController extends Controller {
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout = '//layouts/column1';

	/**
	 * @return array action filters
	 */
	public function filters() {
		return array(
			'accessControl', // perform access control for CRUD operations
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules() {
		return array(
			array(
				'allow',  // allow all users to perform 'index' and 'view' actions
				'actions' => array('index', 'view'),
				'users' => array('@'),
			),
			array(
				'allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions' => array('create', 'update', 'GeneratePdf', 'GenerateExcel', 'getAgencySales', 'getPaidSales', 'savePayment', 'updatePayment', 'deletePayment', 'getWaysToPay', 'getAgencyAccounts', 'viewInvoice', 'sendInvoice', 'getServicesSalesAgency', 'accountDetail', 'getAgencyDashboardTotal', 'getSalePayments'),
				'users' => array('@'),
			),
			array(
				'allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions' => array('admin', 'delete'),
				'users' => array('admin'),
			),
			array(
				'deny',  // deny all users
				'users' => array('*'),
			),
		);
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex() {
		$this->render('index');
	}

	public function actionGetSalePayments($id) {
		$model = Pagos::model()->with("pagosDetalles.idVentaservicio.idVenta.idCliente", "idFormaPago")->findAll("idVenta.id_venta = ". $id);
		$general = Yii::app()->createController('general')[0];
		$response = $general->convertModelToArray($model);
		echo json_encode($response);
	}

	public function actionGetAgencyAccounts() {
		$model = CuentasAgencia::model()->findAll("id_agencia =". $_SESSION["Agencia"]->id_agencia ." AND estatus = 1");
		echo CJSON::encode($model);
	}

	public function actionGetWaysToPay() {
		$model = FormaPago::model()->findAll();
		echo CJSON::encode($model);
	}

	public function actionGetPaidSales() {
		$criteria = new CDbCriteria;
		$criteria->addCondition("t.id_agencia = " . $_SESSION['Agencia']->id_agencia . " AND t.estatus = 'pagado'");
		$model = Ventas::model()->with("ventasServicioses.idTipoServicio", "ventasServicioses.idProveedor", "idCliente", "idUsuario")->findAll($criteria);

		$general = Yii::app()->createController('general')[0];
		$response = $general->convertModelToArray($model);
		echo json_encode($response);
	}

	public function actionGetAgencySales() {
		$criteria = new CDbCriteria;
		$criteria->addCondition("t.id_agencia = " . $_SESSION['Agencia']->id_agencia . " AND t.estatus != 'cancelado'");

		$relations_array = [ "ventasServicioses.idTipoServicio", "ventasServicioses.idProveedor", "ventasServicioses.pagosDetalles", "idCliente", "idUsuario" ];
		if($_POST["providerPayments"]) array_push($relations_array, "ventasServicioses.pagosProveedores");

		$model = Ventas::model()->with($relations_array)->findAll($criteria);
		$general = Yii::app()->createController('general')[0];
		$response = $general->convertModelToArray($model);
		echo json_encode($response);
	}

	public function actionGetAgencyDashboardTotal() {
		$totals_query = "SELECT SUM(VS.tarifa_publica + VS.fee) AS total_publico, SUM(VS.costo) AS total_neto FROM tbl_ventas V INNER JOIN tbl_ventas_servicios VS ON VS.id_venta = V.id_venta WHERE V.id_agencia = ". $_SESSION["Agencia"]->id_agencia ." AND VS.estatus = 'venta'";
		$agency_totals = Yii::app()->db->createCommand($totals_query)->queryRow();

		$total_clients_payments_query = "SELECT SUM(PD.monto) AS pagos_clientes FROM tbl_ventas V INNER JOIN tbl_ventas_servicios VS ON VS.id_venta = V.id_venta INNER JOIN tbl_pagos_detalle PD ON PD.id_ventaservicio = VS.id_ventaservicio WHERE V.id_agencia = ". $_SESSION["Agencia"]->id_agencia ." AND VS.estatus = 'venta'";
		$total_clients_payments = Yii::app()->db->createCommand($total_clients_payments_query)->queryRow();

		$provider_payments_query = "SELECT SUM(PP.monto) AS pagos_proveedores FROM tbl_ventas V INNER JOIN tbl_ventas_servicios VS ON VS.id_venta = V.id_venta INNER JOIN tbl_pagos_proveedores PP ON PP.id_ventaservicio = VS.id_ventaservicio WHERE V.id_agencia = ". $_SESSION["Agencia"]->id_agencia ." AND VS.estatus NOT LIKE 'cancelado'";
		$provider_payments = Yii::app()->db->createCommand($provider_payments_query)->queryRow();

		$month_payments_query = "SELECT SUM(PD.monto) AS pagos_mes FROM tbl_ventas V INNER JOIN tbl_ventas_servicios VS ON VS.id_venta = V.id_venta INNER JOIN tbl_pagos_detalle PD ON PD.id_ventaservicio = VS.id_ventaservicio INNER JOIN tbl_pagos P ON P.id_pago = PD.id_pago WHERE V.id_agencia = ". $_SESSION["Agencia"]->id_agencia ." AND VS.estatus = 'venta' AND P.log LIKE '". date("Y-m") ."%'";
		$month_payments = Yii::app()->db->createCommand($month_payments_query)->queryRow();

		$response = array(
			"total_cobrar" => ($agency_totals["total_publico"] - $total_clients_payments["pagos_clientes"]),
			"total_pagar" => ($agency_totals["total_neto"] - $provider_payments["pagos_proveedores"]),
			"total_ventas" => $agency_totals["total_publico"],
			"pagos_mes" => $month_payments["pagos_mes"]
		);
		echo json_encode($response);
	}

	public function actionGetServicesSalesAgency() {
		$criteria = new CDbCriteria;
		$criteria->addCondition("idVenta.id_agencia = ". $_SESSION['Agencia']->id_agencia ." AND idVenta.estatus != 'cancelado' AND pagado_proveedor = 0");
	
		//FILTRO DE FECHAS INICIO Y FIN DE SERVICIO
		if (isset($_POST['minDate']) && isset($_POST['maxDate'])) {
			$criteria->addCondition('t.inicio_servicio >= "'. $_POST['minDate'] .'" AND t.inicio_servicio <= "'. $_POST['maxDate'] .'"');
			$criteria->addCondition('t.fin_servicio >= "'. $_POST['minDate'] .'" AND t.fin_servicio <= "'. $_POST['maxDate'] .'" OR t.fin_servicio IS NULL OR t.fin_servicio="0000-00-00"');
		}
		//FILTRO DE FECHAS INICIO Y FIN DE SERVICIO

		//FILTRO DE PROVEEDOR
		if (isset($_POST['proveedorSelected'])) {
			if ($_POST['proveedorSelected'] != "0") {
				$criteria->addCondition('t.id_proveedor = "'. $_POST['proveedorSelected'] .'"');
			}
		}
		//FILTRO DE PROVEEDOR

		//FILTRO DE PROVEEDOR
		if (isset($_POST['servicioSelected'])) {
			if ($_POST['servicioSelected'] != "0") {
				$criteria->addCondition('t.id_tipo_servicio = "'. $_POST['servicioSelected'] .'"');
			}
		}
		//FILTRO DE PROVEEDOR

		//FILTRO AÑO ACTUAL
		if (isset($_POST['year'])) {
			if ($_POST['year'] == "1") {
				$criteria->addCondition('idVenta.fecha >= "'. date('Y') .'-01-01' .'"');
				$criteria->addCondition('idVenta.fecha <= "'. date('Y') .'-12-31' .'"');
			}
		}
		//FILTRO AÑO ACTUAL

		//FILTRO MES ACTUAL
		if (isset($_POST['month'])) {
			if ($_POST['month'] == "1") {
				$criteria->addCondition('idVenta.fecha >= "'. date('Y') .'-'. date('m') .'-01'. '"');
				$criteria->addCondition('idVenta.fecha <= "'. date('Y') .'-'. date('m') .'-31'. '"');
			}
		}
		//FILTRO MES ACTUAL

		$model = VentasServicios::model()->with("idVenta.idCliente", "idProveedor", "idTipoServicio", "pagosProveedores", "pagosDetalles","idVenta.idTipoVenta","idVenta.perteneceA")->findAll($criteria);
		$general = Yii::app()->createController('general')[0];
		$response = $general->convertModelToArray($model);
		echo json_encode($response);
	}

	public function actionSavePayment() {
		$model = new Pagos;
		$model->attributes = $_POST;
		$model->id_usuario = Yii::app()->user->id;
		$model->log = date("Y-m-d H:m:s");
		$cuentas_forma_pago = [ 1, 11, 12 ];
		if ($_POST["id_cuenta"] == "" || in_array(intval($_POST["id_forma_pago"]), $cuentas_forma_pago)) {
			$model->id_cuenta = NULL;
		}

		if(is_uploaded_file($_FILES["file_comprobante"]["tmp_name"])) {
			$fecha = date("dmY");
			$file_name = $fecha .'-'. str_replace(' ', '-', $_FILES['file_comprobante']['name']);
			$file_url = 'images/comprobantes/pagos/'. $file_name;
			move_uploaded_file($_FILES['file_comprobante']['tmp_name'], $file_url);
			$model->comprobante = $file_name;
		} else {
			$model->comprobante = NULL;
		}
		
		if($model->save()) {
			$vs_array = array();
			foreach ($_POST["payment_details"] as $key => $payment) {
				$aux = json_decode($payment, true);
				array_push($vs_array, $aux["id_ventaservicio"]);
				if(isset($aux["monto"]) || $aux["monto"] != 0) {
					$detalle_pago = new PagosDetalle;
					$detalle_pago->attributes = $aux;
					$detalle_pago->id_pago = $model->id_pago;
					$detalle_pago->save();
				}
			}
			$vs_to_find = implode(", ", $vs_array);
			$total_pagos = Yii::app()->db->createCommand("SELECT SUM(P.monto) AS 'total' FROM tbl_pagos_detalle P WHERE P.id_ventaservicio IN ($vs_to_find)")->queryAll();
			$venta = VentasServicios::model()->findByPk($detalle_pago->id_ventaservicio)->id_venta;
			$total_servicios = Yii::app()->db->createCommand("SELECT SUM(cargo) AS total FROM (SELECT SUM(VS.tarifa_publica + COALESCE(VS.fee, 0)) AS cargo FROM tbl_ventas_servicios VS WHERE VS.id_venta = $venta UNION ALL SELECT cargo_servicios AS cargo FROM tbl_ventas V WHERE V.id_venta = $venta) AS suma")->queryAll();
			if(floatval($total_pagos[0]["total"]) >= floatval($total_servicios[0]["total"])) {
				$model_venta = Ventas::model()->findByPk($venta);
				$model_venta->estatus = "pagado";
				$model_venta->save();
			}

			$pago_guardado = Pagos::model()->with("pagosDetalles")->findByPk($model->id_pago);
			$general = Yii::app()->createController('general')[0];
			$response = $general->convertModelToArray($pago_guardado);
			echo json_encode($response);
		} else {
			echo CJSON::encode($model->getErrors());
		}
	}

	public function actionUpdatePayment() {
		$model = Pagos::model()->findByPk($_POST["id_pago"]);
		$model->attributes = $_POST;
		$cuentas_forma_pago = [ 1, 11, 12 ];
		if ($_POST["id_cuenta"] == "" || in_array(intval($_POST["id_forma_pago"]), $cuentas_forma_pago)) {
			$model->id_cuenta = NULL;
		}

		if(is_uploaded_file($_FILES["file_comprobante"]["tmp_name"])) {
			$fecha = date("dmY");
			$file_name = $fecha .'-'. str_replace(' ', '-', $_FILES['file_comprobante']['name']);
			$file_url = 'images/comprobantes/pagos/'. $file_name;
			move_uploaded_file($_FILES['file_comprobante']['tmp_name'], $file_url);
			$model->comprobante = $file_name;
		} else {
			if(is_null($model->comprobante) || $model->comprobante == "null") {
				$model->comprobante = NULL;
			}
		}

		if($model->save()) {
			$vs_array = array();
			foreach ($_POST["payment_details"] as $key => $value) {
				$aux = json_decode($value, true);
				if(isset($aux["monto"]) || $aux["monto"] != 0) {
					if($aux["id_pago_detalle"]) {
						$detail = PagosDetalle::model()->findByPk($aux["id_pago_detalle"]);
					} else {
						$detail = new PagosDetalle;
					}
					
					$detail->attributes = $aux;
					$detail->save();
					array_push($vs_array, $detail->id_ventaservicio);
				}
			}

			$vs_to_find = implode(", ", $vs_array);
			$total_pagos = Yii::app()->db->createCommand("SELECT SUM(P.monto) AS 'total' FROM tbl_pagos_detalle P WHERE P.id_ventaservicio IN ($vs_to_find)")->queryAll();
			$venta = VentasServicios::model()->findByPk($detail->id_ventaservicio)->id_venta;
			$total_servicios = Yii::app()->db->createCommand("SELECT SUM(cargo) AS total FROM (SELECT SUM(VS.tarifa_publica + COALESCE(VS.fee, 0)) AS cargo FROM tbl_ventas_servicios VS WHERE VS.id_venta = $venta UNION ALL SELECT cargo_servicios AS cargo FROM tbl_ventas V WHERE V.id_venta = $venta) AS suma")->queryAll();
			$model_venta = Ventas::model()->findByPk($venta);
			if(floatval($total_pagos[0]["total"]) >= floatval($total_servicios[0]["total"])) {
				$model_venta->estatus = "pagado";
			} else {
				$model_venta->estatus = "venta";
			}
			$model_venta->save();

			$saved_payment = Pagos::model()->with("pagosDetalles")->findByPk($model->id_pago);
			$general = Yii::app()->createController('general')[0];
			$response = $general->convertModelToArray($saved_payment);
			echo json_encode($response);
		} else {
			echo CJSON::encode($model->getErrors());
		}
	}

	public function actionDeletePayment($id) {
		$detail = PagosDetalle::model()->findAll("id_pago = ". $id);
		foreach ($detail as $key => $value) {
			$value->delete();
		}
		$payment = Pagos::model()->findByPk($id);
		if($payment->delete()) {
			echo json_encode(array(
				"success" => true
			));
		} else {
			echo json_encode(array(
				"success" => false
			));
		}
	}

	public function actionSavePaymentV1() {
		$model = new Pagos;
		$model->attributes = $_POST;
		$model->log = date("Y-m-d H:m:s");
		$cuentas_forma_pago = [ 1, 11, 12 ];
		if ($_POST["id_cuenta"] == "" || in_array(intval($_POST["id_forma_pago"]), $cuentas_forma_pago)) {
			$model->id_cuenta = null;
		}
		if ($model->save()) {
			$venta = Ventas::model()->findByPk($model->id_venta);
			$pagos = Pagos::model()->findAll('id_venta = '. $model->id_venta);
			$total_servicios = Yii::app()->db->createCommand("SELECT SUM(VS.tarifa_publica + VS.fee) AS 'total' FROM tbl_ventas_servicios VS WHERE VS.id_venta = ". $venta->id_venta)->queryAll();
			$total = 0;
			foreach ($pagos as $key => $value) {
				$total += floatval($value->monto);
			}
			if($total >= floatval($total_servicios[0]["total"])) {
				$venta->estatus = "pagado";
				$venta->save();
			}
			echo CJSON::encode($model);
		} else {
			echo CJSON::encode($model->getErrors());
		}
	}

	public function actionSendInvoice($id_pago, $email) {
		Yii::import('application.extensions.phpmailer.*');
		$message = "Por este medio se le envia el recibo de su pago generado por la agencia \"". $_SESSION["Agencia"]->nombre_comercial ."\".";

		$mail = new JPhpMailer;
		$mail->IsSMTP();
		$mail->Host = Yii::app()->params->host;
		$mail->SMTPAuth = true;
		$mail->Username = Yii::app()->params->username;
		$mail->Port = '26';
		$mail->Password = Yii::app()->params->password;
		$mail->SMTPKeepAlive = true;
		$mail->Mailer = "smtp";
		$mail->IsSMTP();
		$mail->SMTPAuth = true;
		$mail->CharSet = 'utf-8';
		$mail->SMTPDebug  = 0;

		$mail->SetFrom($_SESSION["Usuario"]->idUsuario->email, "");
		$mail->AddReplyTo($user_model->email);
		$mail->Subject = "Recibo de pago - " . $_SESSION["Agencia"]->nombre_comercial;
		$mail->AddAddress($email, $customer_model->nombre);

		$invoice_pdf = $this->getPdfInvoice($id_pago, "S");
		$mail->addStringAttachment($invoice_pdf, ("recibo-" . date("dmY") . $id_pago . ".pdf"));

		$mail->AltBody = "To view the message, please use an HTML compatible email viewer!";
		$mail->MsgHTML($message);

		if ($mail->send()) {
			echo json_encode(array(
				"success" => true,
			));
		} else {
			echo json_encode(array(
				"success" => false,
			));
		}
	}

	public function actionViewInvoice($id) {
		$this->getPdfInvoice($id, "I");
	}

	public function getPdfInvoice($id_pago, $output) {
		$payment_model = Pagos::model()->findByPk($id_pago);
		$agency_model = Agencia::model()->findByPk($_SESSION["Agencia"]->id_agencia);

		$pdf = new MYPDF();
		$pdf->SetCreator(PDF_CREATOR);
		$pdf->SetAuthor(Yii::app()->name);
		$pdf->SetTitle("Recibo-". date_format(date_create($payment_model->log), "dmY") . $id_pago);
		$pdf->SetSubject("Recibo-". date_format(date_create($payment_model->log), "dmY") . $id_pago);
		$pdf->SetMargins(20, 55, 20);

		$pdf->setPrintHeader(true);
		$pdf->SetHeaderMargin(10);

		$pdf->setPrintFooter(false);
		$pdf->SetFooterMargin(10);

		$pdf->SetAutoPageBreak(TRUE, 30); //SEGUNDO PARAMETRO PARA MARGIN BOTTOM
		$pdf->SetFont('helvetica', '', 10);
		// $pdf->setPageOrientation('L');

		preg_match('/^(\d{3})(\d{3})(\d{4})$/', $agency_model->telefono, $matches);
		$formatted_phone = "(". $matches[1] . ") ". $matches[2] ."-". $matches[3];
		preg_match('/^(\d{3})(\d{3})(\d{4})$/', $agency_model->whatsapp, $matches_whatsapp);
		$formatted_phone_whatsapp = "(" . $matches_whatsapp[1] . ") " . $matches_whatsapp[2] . "-" . $matches_whatsapp[3];

		$url = $_SERVER['DOCUMENT_ROOT'] ."/";
		$agency_logo = $url."admin/images/agencia/". $agency_model->logotipo;

		if ($agency_model->rnt != null) { $sectur =  "No. De registro ante SECTUR: " . $agency_model->rnt . "<br>"; }
		if ($agency_model->rfc != null) { $rfc =  "RFC: " . $agency_model->rfc . "<br>"; }
		if ($agency_model->whatsapp != null) { $whatsapp =  "Whatsapp: " . $formatted_phone_whatsapp . "<br>"; }
		
		if (empty($agency_model->logotipo) || !is_readable($agency_logo)) {
			$agency_logo = "https://2businesstravel.com/rentas/images/businesses/logo-agencia-no-definido.png";
		}
		$pdf_header = '
		<table style="margin-bottom=0px; font-size:28px;">
			<tr>
				<td><img height="80" src="' . $agency_logo . '">
				<br>'.
				$agency_model->nombre_comercial . '
				</td>
				<td align="right">
					' . $sectur . '
					' . $rfc . '
					Dirección: ' . $agency_model->direccion . '
					<br>
					' . $whatsapp . '
					Teléfono: ' . $formatted_phone . '
					<br>
					Correo: ' . $agency_model->correo . '
					<br>
					' . $agency_model->sitio_web . '
				</td>
			</tr>
		</table>';
		$pdf->pdf_header = $pdf_header;

		$pdf->AddPage();

		$html = $this->renderPartial("invoice-template", array(
			"payment_code" => $id_pago,
		), true);
		$pdf->writeHTML($html, true, false, true, false, '');
		$pdf->LastPage();
		if ($output == "S") {
			return $pdf->Output("Recibo-". $payment_model->id_pago .".pdf", $output);
		}
		$pdf->Output("Recibo-". $payment_model->id_pago .".pdf", $output);
	}

	public function actionAccountDetail($id) {
		$this->getAccountDetail($id, "I");
	}

	public function getAccountDetail($id_venta, $output) {
		$sale_model = Ventas::model()->findByPk($id_venta);
		$agency_model = Agencia::model()->findByPk($_SESSION["Agencia"]->id_agencia);

		$pdf = new MYPDF();
		$pdf->SetCreator(PDF_CREATOR);
		$pdf->SetAuthor(Yii::app()->name);
		$pdf->SetTitle("Recibo-". date_format(date_create($sale_model->log), "dmY") . $id_venta);
		$pdf->SetSubject("Recibo-". date_format(date_create($sale_model->log), "dmY") . $id_venta);
		$pdf->SetMargins(20, 50, 20);

		$pdf->setPrintHeader(true);
		$pdf->SetHeaderMargin(10);

		$pdf->setPrintFooter(false);
		$pdf->SetFooterMargin(10);

		$pdf->SetAutoPageBreak(TRUE, 30); //SEGUNDO PARAMETRO PARA MARGIN BOTTOM
		$pdf->SetFont('courier', '', 10);
		// $pdf->setPageOrientation('L');

		preg_match('/^(\d{3})(\d{3})(\d{4})$/', $agency_model->telefono, $matches);
		$formatted_phone = "(". $matches[1] . ") ". $matches[2] ."-". $matches[3];
		preg_match('/^(\d{3})(\d{3})(\d{4})$/', $agency_model->whatsapp, $matches_whatsapp);
		$formatted_phone_whatsapp = "(" . $matches_whatsapp[1] . ") " . $matches_whatsapp[2] . "-" . $matches_whatsapp[3];
		$url = $_SERVER['DOCUMENT_ROOT'] ."/";
		$agency_logo = $url."admin/images/agencia/". $agency_model->logotipo;
		
		$height = 80;
		if (empty($agency_model->logotipo) || !is_readable($agency_logo)) {
			$agency_logo = "https://2businesstravel.com/rentas/images/businesses/logo-agencia-no-definido.png";
		} else {
			list($ancho, $alto, $tipo, $atributos) = getimagesize($_SERVER["DOCUMENT_ROOT"] ."/admin/images/agencia/". $agency_model->logotipo);
			if($ancho < $alto) {
				$height = 80;
			}
		}
		if ($agency_model->rnt != null) { $sectur =  "No. De registro ante SECTUR: " . $agency_model->rnt . "<br>"; }
		if ($agency_model->rfc != null) { $rfc =  "RFC: " . $agency_model->rfc . "<br>"; }
		if ($agency_model->whatsapp != null) { $whatsapp =  "Whatsapp: " . $formatted_phone_whatsapp . "<br>"; }
		$pdf_header = '
		<table style="margin-bottom=0px; font-size:28px;">
			<tr>
				<td><img height="80" src="' . $agency_logo . '">
				<br>'.
				$agency_model->nombre_comercial . '
				</td>
				<td align="right">
					' . $sectur . '
					' . $rfc . '
					Dirección: ' . $agency_model->direccion . '
					<br>
					' . $whatsapp . '
					Teléfono: ' . $formatted_phone . '
					<br>
					Correo: ' . $agency_model->correo . '
					<br>
					' . $agency_model->sitio_web . '
				</td>
			</tr>
		</table>';
		$pdf->pdf_header = $pdf_header;

		$pdf->AddPage();

		$html = $this->renderPartial("account-detail", array(
			"sale_code" => $id_venta,
		), true);
		$pdf->writeHTML($html, true, false, true, false, '');

		$payment_promises = PromesasPagos::model()->findAll("id_venta = ". $sale_model->id_venta);
		if(count($payment_promises) > 0) {
			$pdf->AddPage();
			$promises_html = $this->renderPartial("payment-promises", array(
				"promises_array" => $payment_promises,
			), true);
			$pdf->writeHTML($promises_html, true, false, true, false, '');
		}

		if($sale_model->estatus == "pagado") {
			$tipoLetra = "Helvetica";
			$tamanoLetra = 72;
			$estiloLetra = "B";
	
			// Calcular ancho de la cadena
			$widthCadena = $pdf->GetStringWidth(trim("PAGADO"), $tipoLetra, $estiloLetra, $tamanoLetra, false );
			$factorCentrado = round(($widthCadena * sin(deg2rad(45))) / 2 ,0);
	
			// Get the page width/height
			$myPageWidth = $pdf->getPageWidth();
			$myPageHeight = $pdf->getPageHeight();
	
			// Find the middle of the page and adjust.
			$myX = ( $myPageWidth / 2 ) - $factorCentrado;
			$myY = ( $myPageHeight / 2 ) + $factorCentrado;
	
			// Set the transparency of the text to really light
			$pdf->SetAlpha(0.09);
	
			// Rotate 45 degrees and write the watermarking text
			$pdf->StartTransform();
			$pdf->Rotate(45, $myX, $myY);
			$pdf->SetFont($tipoLetra, $estiloLetra, $tamanoLetra);
			$pdf->Text($myX, $myY - 20, trim("PAGADO"));
			$pdf->StopTransform();
	
			// Reset the transparency to default
			$pdf->SetAlpha(1);
		}

		$pdf->LastPage();
		if ($output == "S") {
			return $pdf->Output("Recibo-". $sale_model->folio .".pdf", $output);
		}
		$pdf->Output("Recibo-". $sale_model->folio .".pdf", $output);
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer the ID of the model to be loaded
	 */
	public function loadModel($id) {
		$model = Agencia::model()->findByPk($id);
		if ($model === null)
			throw new CHttpException(404, 'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param CModel the model to be validated
	 */
	protected function performAjaxValidation($model) {
		if (isset($_POST['ajax']) && $_POST['ajax'] === 'agencia-form') {
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
}

class MYPDF extends TCPDF {
	public $pdf_header;

	//Page header
	public function Header() {
		$this->SetFont('helvetica', '', 11);
		$this->writeHTML($this->pdf_header, false, true, false, true);
	}
}