<?php

class ClientesController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout = '//layouts/column1';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array(
				'allow',
				'actions' => array('clienteVenta'),
				'users' => array('*'),
			),
			array(
				'allow',  // allow all users to perform 'index' and 'view' actions
				'actions' => array('index', 'view', 'clientesApi', 'Clientes', 'clienteslikeApi', 'clientesApiv2'),
				'users' => array('@'),
			),
			array(
				'allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions' => array('create', 'update', 'GeneratePdf', 'GenerateExcel', 'Clientes', 'delete', 'createApi', 'updateApi', 'setBillingData', 'createClientUser', 'test'),
				'users' => array('@'),
			),
			array(
				'allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions' => array('admin', 'delete'),
				'users' => array('admin'),
			),
			array(
				'deny',  // deny all users
				'users' => array('*'),
			),
		);
	}

	public function actionCreateClientUser()
	{
		$response = array(
			"success" => true,
			"error" => "",
			"user" => array(),
			"profile" => array(),
			"agency_user" => array(),
			"client_user" => array(),
		);

		$transaction = Yii::app()->db->beginTransaction();
		$client_model = Clientes::model()->findByPk($_POST["code"]);

		$model_aux_correo = Users::model()->find("username = '" . $_POST["user"] . "'");
		if (count($model_aux_correo) > 0) {
			$response["success"] = 500;
			$response["error"] = "Ya existe este usuario, intente con otro.";
			echo CJSON::encode($response);
			exit;
		}
		$user_model = new User;
		$user_model->username = $_POST["user"];
		$user_model->password = UserModule::encrypting($_POST["pwd"]);
		$user_model->email = $client_model->correo;
		$user_model->activkey = UserModule::encrypting(microtime() . $_POST["pwd"]);
		$user_model->status = 1;
		if ($user_model->save()) {
			$profile = new Profile;
			$profile->user_id = $user_model->id;
			$profile->firstname = $_POST["firstname"];
			$profile->lastname = $_POST["lastname"];

			if ($profile->save()) {
				$agency_user = new UsuariosAgencias;
				$agency_user->id_usuario = $user_model->id;
				$agency_user->id_agencia = $client_model->id_agencia;
				$agency_user->fecha_nacimiento = "0000-00-00";
				$agency_user->telefono = $client_model->telefono;
				$agency_user->direccion = $client_model->direccion;
				$agency_user->foto = NULL;
				$agency_user->rol = "Cliente";
				$agency_user->status_laboral = 1;

				if ($agency_user->save()) {
					$client_user = new UsuariosClientes;
					$client_user->id_user = $user_model->id;
					$client_user->id_cliente = $client_model->id_cliente;

					if ($client_user->save()) {
						$response["user"] = $user_model;
						$response["profile"] = $profile;
						$response["agency_user"] = $agency_user;
						$response["client_user"] = $client_user;
					} else {
						$transaction->rollback();
						$response["success"] = false;
						$response["error"] = "client_user";
						$response["client_user"] = $client_user->getErrors();
					}
				} else {
					$transaction->rollback();
					$response["success"] = false;
					$response["error"] = "agency_user";
					$response["agency_user"] = $agency_user->getErrors();
				}
			} else {
				$transaction->rollback();
				$response["success"] = false;
				$response["error"] = "profile";
				$response["profile"] = $profile->getErrors();
			}
		} else {
			$transaction->rollback();
			$response["success"] = false;
			$response["error"] = "user";
			$response["user"] = $user_model->getErrors();
		}

		if ($response["success"]) $transaction->commit();
		echo CJSON::encode($response);
	}

	public function actionSetBillingData()
	{
		if ($_POST["id_cliente_info_fiscal"] > 0) {
			$model = ClienteInfoFiscal::model()->findByPk($_POST["id_cliente_info_fiscal"]);
		} else {
			$model = new ClienteInfoFiscal;
		}
		$model->attributes = $_POST;
		$model = $this->checkNullFields($model);
		if ($model->save()) {
			echo CJSON::encode($model);
		} else {
			echo CJSON::encode($model->getErrors());
		}
	}

	public function actionclientesApi()
	{
		try {
			$clientesresult = Clientes::model()->with('idAgencia', 'clienteInfoFiscal')->findAll('t.id_agencia = "' . $_SESSION['Agencia']->id_agencia . '"');
			$general = Yii::app()->createController('general')[0];
			$array = $general->convertModelToArray($clientesresult);
			foreach ($array as $key => $customer) {
				$user_info = UsuariosClientes::model()->find("id_cliente = " . $customer["id_cliente"]);
				$array[$key]["usuarioCliente"] = array();
				if (!is_null($user_info)) {
					$array[$key]["usuarioCliente"] = $general->convertModelToArray($user_info);
				}
			}
			echo json_encode($array);
		} catch (Exception $e) {
			echo json_encode($e);
		}
	}

	public function actionclientesApiv2()
	{
		$criteria = new CDbCriteria;
		$criteria->condition = 't.id_agencia = "' . $_SESSION['Agencia']->id_agencia . '" AND nombre LIKE "%' . $_GET["search"] . '%" ';
		$criteria->limit = 7;
		$clientesresult = Clientes::model()->with('idAgencia')->findAll($criteria);
		$response = array();
		//$response['results'] = array();
		foreach ($clientesresult as $key => $value) {
			//$clientesresult[$key]['result'];
			array_push($response, array(
				"value" => $value->id_cliente,
				"label" => $value->nombre,
				"correo" => $value->correo,
				"telefono" => $value->telefono,
			));
		}
		echo CJSON::encode($response);
	}

	public function actionclienteslikeApi($nombre)
	{
		$clienteslike = Clientes::model()->with('idAgencia')->findAll('t.id_agencia = "' . $_SESSION['Agencia']->id_agencia . '" AND nombre="' . $nombre . '"');
		$general = Yii::app()->createController('general')[0];
		$arraylike = $general->convertModelToArray($clienteslike);
		echo json_encode($arraylike);
	}

	// public function actionclienteVenta($id_cliente){		
	// 	$ventacliente = Ventas::model()->with('idAgencia', 'idCliente', 'ventasServicioses', 'ventasServicioses.idTipoServicio', 'ventasServicioses.idProveedor')->findAll('t.id_agencia = "' . $_SESSION['Agencia']->id_agencia . '" AND t.id_cliente= "' . $id_cliente . '"');
	// 	$general = Yii::app()->createController('general')[0];
	// 	$arraylike = $general->convertModelToArray($clienteslike);
	// 	echo json_encode($array);
	// }
	public function actionclienteVenta($id)
	{
		header('Access-Control-Allow-Origin: *');
		header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
		header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
		header("Allow: GET, POST, OPTIONS, PUT, DELETE");

		//$ventacliente = Ventas::model()->findAll('id_cliente=' . $id);
		$ventasresult = Ventas::model()->with('ventasServicioses')->findAll('id_cliente=' . $id);
		$array = $this->convertModelToArray($ventasresult);
		$sumaservicios = 0;
		foreach ($array as $index1 => $ventas) {
			$sumaserviciosporventa = 0;
			$costototalporventa = 0;
			$subtotal = 0;
			foreach ($ventas['ventasServicioses'] as $index => $servicio) {

				// suma de las tarifas de todas las ventas
				$sumaservicios += $servicio['tarifa_publica']; //todos los servicios de todas las ventas
				$costototal += $servicio['costo'];
				$sumaserviciosporventa += $servicio['tarifa_publica']; //unaventa todos servicio
				$costototalporventa += $servicio['costo'];
				$subtotal += floatval($servicio['tarifa_publica']) + floatval($servicio['fee']);
				$array[$index1]['sumatotalporventa'] = $sumaserviciosporventa;
				$array[$index1]['costototalporventa'] = $costototalporventa;
				$array[$index1]['subtotal'] = $subtotal;
			}
			$array[$index1]['sumatotal'] = $sumaservicios;
			$array[$index1]['costototal'] = $costototal;
			$array[$index1]['subtotal'] = $subtotal + floatval($ventas['cargo_servicios']);
			$array[$index1]['id_contrato'] = Contratos::model()->find('id_venta = ' . $ventas['id_venta'])->id_contrato;
		}
		echo CJSON::encode($array);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$model = $this->loadModel($id);

		if ($_SESSION['Agencia']->id_agencia == $model->idAgencia->id_agencia) {
			$this->render('view', array(
				'model' => $this->loadModel($id),
			));
		} else {
			$this->render('clientes');
		}
	}

	public function actionUpdateApi()
	{
		$model = Clientes::model()->findByPk($_POST["id_cliente"]);
		$model->attributes = $_POST;
		$model = $this->checkNullFields($model);
		if ($model->save()) {
			echo CJSON::encode($model);
		} else {
			echo CJSON::encode($model->getErrors());
		}
	}

	public function actionCreateApi()
	{
		$model_aux = Clientes::model()->find("nombre LIKE '" . $_POST["nombre"] . "' AND id_agencia = " . $_SESSION['Agencia']->id_agencia);

		$model_aux_correo = Users::model()->find("email = '" . $_POST["correo"] . "'");
		$count_correo = count($model_aux_correo);

		if (!isset($model_aux) && !isset($model_aux_correo)) {
			$model = new Clientes;
			$model->attributes = $_POST;
			$model = $this->checkNullFields($model);
			if ($model->save()) {
				echo json_encode(array(
					"id" => $model->id_cliente,
					"text" => $model->nombre,
					"phone" => $model->telefono,
					"mail" => $model->correo,
				));
			} else {
				echo CJSON::encode($model->getErrors());
			}
		} elseif ($count_correo > 0) {
			echo json_encode(array(
				"nombre" => "Ya existe un registro con este correo"
			));
		} else {
			echo json_encode(array(
				"nombre" => "Ya existe un cliente con este nombre"
			));
		}
	}

	public function checkNullFields($model)
	{
		foreach ($model as $key => $value) {
			if (empty($value)) {
				$model[$key] = NULL;
			}
		}

		return $model;
	}

	public function actionTest()
	{
		$model = Agencia::model()->findByPk(1);
		foreach ($model as $key => $value) {
			echo $key;
		}
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model = new Clientes;

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if (isset($_POST['Clientes'])) {
			$model->attributes = $_POST['Clientes'];
			if ($model->save())
				$this->redirect(array('view', 'id' => $model->id_cliente));
		}

		$this->render('create', array(
			'model' => $model,
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$modeloventas = $this->loadmodelventa($id);
		$model = $this->loadModel($modeloventas->id_cliente);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if (isset($_POST['Clientes'])) {
			$model->attributes = $_POST['Clientes'];
			if ($model->save())
				$this->redirect(array('ventas/view', 'id' => $modeloventas->id_venta));
		}

		$this->render('update', array(
			'model' => $model,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		$modelo = Clientes::model()->findByPk($id);
		$response = array();
		if ($modelo) {
			if ($modelo->delete()) {
				$response = array(
					"estatus" => 200,
					"mensaje" => "Se ha eliminado correctamente"
				);
			} else {
				$response = array(
					"estatus" => 404,
					"mensaje" => "No se ha podido elminar el contacto"
				);
			}
		} else {
			$response = array(
				"estatus" => 404,
				"mensaje" => "No se ha encontrado ningún contacto"
			);
		}
		echo CJSON::encode($response);
	}

	/**
	 * Lists all models.
	 */
	public function actionIndexV1()
	{
		$session = new CHttpSession;
		$session->open();
		$criteria = new CDbCriteria();

		$model = new Clientes('search');
		$model->unsetAttributes();  // clear any default values

		if (isset($_GET['Clientes'])) {
			$model->attributes = $_GET['Clientes'];

			if (!empty($model->id_cliente)) $criteria->addCondition("id_cliente = '" . $model->id_cliente . "'");

			if (!empty($model->id_agencia)) $criteria->addCondition("id_agencia = '" . $model->id_agencia . "'");

			if (!empty($model->nombre)) $criteria->addCondition("nombre = '" . $model->nombre . "'");

			if (!empty($model->telefono)) $criteria->addCondition("telefono = '" . $model->telefono . "'");

			if (!empty($model->correo)) $criteria->addCondition("correo = '" . $model->correo . "'");

			if (!empty($model->log)) $criteria->addCondition("log = '" . $model->log . "'");

			$session['Clientes_records'] = Clientes::model()->findAll($criteria);
		}

		$this->render('index', array(
			'model' => $model,
		));
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model = new Clientes('search');
		$model->unsetAttributes();  // clear any default values
		if (isset($_GET['Clientes']))
			$model->attributes = $_GET['Clientes'];

		$this->render('admin', array(
			'model' => $model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer the ID of the model to be loaded
	 */
	public function loadModel($id)
	{
		$model = Clientes::model()->with('idAgencia')->findByPk($id);
		if ($model === null)
			throw new CHttpException(404, 'The requested page does not exist.');
		return $model;
	}

	public function loadmodelventa($id)
	{
		$model = Ventas::model()->with('idAgencia', 'ventasServicioses', 'idCliente')->findByPk($id);
		if ($model === null)
			throw new CHttpException(404, 'The requested page does not exist.');
		return $model;
	}

	public function convertModelToArray($models)
	{
		if (is_array($models))
			$arrayMode = TRUE;
		else {
			$models = array($models);
			$arrayMode = FALSE;
		}
		$result = array();
		foreach ($models as $model) {
			$attributes = $model->getAttributes();
			$relations = array();
			foreach ($model->relations() as $key => $related) {
				if ($model->hasRelated($key)) {
					if ($model->$key) {
						$relations[$key] = $this->convertModelToArray($model->$key);
					} else {
						$relations[$key] = [];
					}
				}
			}

			$all = array_merge($attributes, $relations);
			if ($arrayMode)
				array_push($result, $all);
			else
				$result = $all;
		}
		return $result;
	}

	/**
	 * Performs the AJAX validation.
	 * @param CModel the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if (isset($_POST['ajax']) && $_POST['ajax'] === 'clientes-form') {
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}

	public function actionGenerateExcel()
	{
		$session = new CHttpSession;
		$session->open();

		if (isset($session['Clientes_records'])) {
			$model = $session['Clientes_records'];
		} else
			$model = Clientes::model()->findAll();


		Yii::app()->request->sendFile(
			date('YmdHis') . '.xls',
			$this->renderPartial('excelReport', array(
				'model' => $model
			), true)
		);
	}

	public function actionGeneratePdf()
	{
		$session = new CHttpSession;
		$session->open();
		Yii::import('application.extensions.bootstrap.gii.*');
		require_once('bootstrap/tcpdf/tcpdf.php');
		require_once('bootstrap/tcpdf/config/lang/eng.php');

		if (isset($session['Clientes_records'])) {
			$model = $session['Clientes_records'];
		} else
			$model = Clientes::model()->findAll();



		$html = $this->renderPartial('expenseGridtoReport', array(
			'model' => $model
		), true);

		//die($html);

		$pdf = new TCPDF();
		$pdf->SetCreator(PDF_CREATOR);
		$pdf->SetAuthor(Yii::app()->name);
		$pdf->SetTitle('Clientes Report');
		$pdf->SetSubject('Clientes Report');
		//$pdf->SetKeywords('example, text, report');
		$pdf->SetHeaderData('', 0, "Report", '');
		$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, "Example Report by " . Yii::app()->name, "");
		$pdf->setHeaderFont(array('helvetica', '', 8));
		$pdf->setFooterFont(array('helvetica', '', 6));
		$pdf->SetMargins(15, 18, 15);
		$pdf->SetHeaderMargin(5);
		$pdf->SetFooterMargin(10);
		$pdf->SetAutoPageBreak(TRUE, 0);
		$pdf->SetFont('dejavusans', '', 7);
		$pdf->AddPage();
		$pdf->writeHTML($html, true, false, true, false, '');
		$pdf->LastPage();
		$pdf->Output("Clientes_002.pdf", "I");
	}

	public function actionIndex()
	{
		$this->render('clientes');
	}
}
