<?php

class ContratosController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column1';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view','firma','signContract'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update','GeneratePdf','GenerateExcel','getContracts','sendLinkSignature', 'uploadPreviousContract'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	public function actionUploadPreviousContract() {
		$model = Contratos::model()->findByPk($_POST["id_contrato"]);
		if(is_uploaded_file($_FILES["previous_contract"]["tmp_name"])) {
			$file_name = "Contrato-". $model->idVenta->folio ."-V". $model->version .".pdf";
			$file_url = 'files/previous-contracts/'. $file_name;
			move_uploaded_file($_FILES['previous_contract']['tmp_name'], $file_url);
		}
		$model->version = $model->version + 1;
		if($model->save()) {
			echo CJSON::encode($model);
		} else {
			echo CJSON::encode($model->getErrors());
		}
	}

	public function actionGetContracts() {
		$model = Contratos::model()->with("idCotizacion.idCliente", "idUserCreo.profiles")->findAll("t.id_agencia = ". $_SESSION["Agencia"]->id_agencia);
		$general = Yii::app()->createController('general')[0];
		$response = $general->convertModelToArray($model);
		echo json_encode($response);
	}

	public function actionSendLinkSignature() {
		Yii::import('application.extensions.phpmailer.*');
		$url = "https://". $_SERVER["SERVER_NAME"] . Yii::app()->createUrl("contratos/firma", array("c"=>$_POST["contract_code"], "iu"=>$_POST["customer_code"]));
		$message = "Por este medio se le envia el <a href='". $url ."'>link</a> para que firme el contrato con la agencia \"". $_SESSION["Agencia"]->nombre_comercial ."\".";
		$customer_model = Clientes::model()->findByPk($_POST["customer_code"]);

		$mail = new JPhpMailer;
		$mail->IsSMTP();
		$mail->Host = Yii::app()->params->host;
		$mail->SMTPAuth = true;
		$mail->Username = Yii::app()->params->username;
		$mail->Port = '26';
		$mail->Password = Yii::app()->params->password;
		$mail->SMTPKeepAlive = true;
		$mail->Mailer = "smtp";
		$mail->IsSMTP();
		$mail->SMTPAuth = true;
		$mail->CharSet = 'utf-8';
		$mail->SMTPDebug  = 0;

		$mail->SetFrom($_SESSION["Usuario"]->idUsuario->email, $_SESSION["Agencia"]->nombre_comercial);
		$mail->AddReplyTo($user_model->email);
		$mail->Subject = "Firma de contrato - ". $_SESSION["Agencia"]->nombre_comercial;
		$mail->AddAddress($_POST["email"], $customer_model->nombre);

		$mail->AltBody = "To view the message, please use an HTML compatible email viewer!";
		$mail->MsgHTML($message);

		if ($mail->send()) {
			echo json_encode(array(
				"success" => true,
			));
		} else {
			echo json_encode(array(
				"success" => false,
			));
		}
	}

	public function actionSignContract() {
		$model = Contratos::model()->findByPk($_POST["c"]);
		$model->id_user_firmo = UsuariosClientes::model()->find("id_cliente = " . $_POST["iu"])->id_user;
		$model->hora = date("H:i:s");
		$model->fecha = date("Y-m-d");
		$model->ip = $_SERVER['REMOTE_ADDR'];
		$model->estatus = "S";

		$customer_signature = Firmas::model()->find("id_user = ". $model->id_user_firmo);
		if (is_null($customer_signature->id_firma) || $_POST["edited"] == 1) {
			$firmas = Yii::app()->createController('firmas')[0];
			$firmas->uploadSignature($_POST["base64img"], $model->id_user_firmo);
		}

		if($model->save()) {
			$this->sendAdviceSignedContract($model->id_contrato);
			echo CJSON::encode($model);
		} else {
			echo CJSON::encode($model->getErrors());
		}
	}

	public function sendAdviceSignedContract($id) {
		Yii::import('application.extensions.phpmailer.*');
		$model = Contratos::model()->findByPk($_POST["c"]);
		$url = "https://". $_SERVER["SERVER_NAME"] . Yii::app()->createUrl("formatos/contrato", array("id" => $id));
		$message = "Buenas tardes. Es un gusto saludarle. <br>Por este medio le confirmamos que su contrato con folio: <b>" . $model->id_contrato  . ". </b> ha sido firmado con éxito. Acceda a él mediante el siguiente <a href='". $url ."'>link</a>.";
		
		$user_creo = UsuariosAgencias::model()->with("idUsuario.profiles", "idAgencia")->find("id_usuario = ". $model->id_user_creo);
		$user_firmo = UsuariosClientes::model()->find("id_user = ". $model->id_user_firmo);
		$user_firmo = Clientes::model()->findByPk($user_firmo->id_cliente);
		$agencia = Agencia::model()->findByPk($user_creo->id_agencia);

		$mail = new JPhpMailer;
		$mail->IsSMTP();
		$mail->Host = Yii::app()->params->host;
		$mail->SMTPAuth = true;
		$mail->Username = Yii::app()->params->username;
		$mail->Port = '26';
		$mail->Password = Yii::app()->params->password;
		$mail->SMTPKeepAlive = true;
		$mail->Mailer = "smtp";
		$mail->IsSMTP();
		$mail->SMTPAuth = true;
		$mail->CharSet = 'utf-8';
		$mail->SMTPDebug  = 0;

		$mail->SetFrom($user_creo->idUsuario->email, ($user_creo->idUsuario->profiles->firstname ." ". $user_creo->idUsuario->profiles->lastname));
		$mail->AddReplyTo($user_creo->idUsuario->email);
		$mail->Subject = "Contrato firmado - ". $agencia->nombre_comercial;
		$mail->AddAddress($user_firmo->correo, $user_firmo->nombre);

		$mail->AltBody = "To view the message, please use an HTML compatible email viewer!";
		$mail->MsgHTML($message);

		if ($mail->send()) {
			return array(
				"success" => true,
			);
		} else {
			return array(
				"success" => false,
			);
		}
	}

	public function actionFirma($c, $iu) {
		$this->layout = "//layouts/guest_layout";
		$this->render("contrato_firma");
	}
}