<?php

class CotizacionesController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column1';

	/**
	 * @return array action filters
	 */
	public function filters() {
		return array(
			'accessControl', // perform access control for CRUD operations
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules() {
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('getPriceInfoPdf'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('index', 'view', 'create', 'update', 'GeneratePdf', 'GenerateExcel', 'getPrices', 'getPricesRequest', 'getPriceInfo', 'createApi', 'updateApi', 'deleteApi', 'convertPriceToContract', 'converter'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	public function actionConverter($id) {
		$this->render("converter");
	}

	public function actionConvertPriceToContract($id) {
		$transaction = Yii::app()->db->beginTransaction();
		$price = Cotizaciones::model()->findByPk($id);
		$price_details = CotizacionDetalles::model()->findAll("id_cotizacion = ". $price->id_cotizacion);

		$contract = new Contratos;
		$contract->id_user_creo = Yii::app()->user->id;
		$contract->estatus = "C";
		$contract->id_agencia = $_SESSION["Agencia"]->id_agencia;
		$contract->id_cliente = $price->id_cliente;
		$contract->id_cotizacion = $price->id_cotizacion;

		if($contract->save()) {
			$response = array(
				"success" => true,
				"error" => "",
				"contract" => $contract,
				"details" => array(),
			);
			
			foreach ($price_details as $key => $detail) {
				$contract_detail = new ContratoDesglose;
				$contract_detail->desglose = $detail->desglose;
				$contract_detail->observaciones = $detail->observaciones;
				$contract_detail->comision = $detail->comision;
				$contract_detail->comision_pesos = $detail->comision_pesos;
				$contract_detail->fee = $detail->fee;
				$contract_detail->total_neto = $detail->total_neto;
				$contract_detail->total_publico = $detail->total_publico;
				$contract_detail->id_proveedor = $detail->id_proveedor;
				$contract_detail->id_tipo_servicio = $detail->id_tipo_servicio;
				$contract_detail->id_contrato = $contract->id_contrato;

				if($contract_detail->save()) {
					array_push($response["details"], $contract_detail);
				} else {
					$transaction->rollback();
					$response["success"] = false;
					$response["error"] = $contract_detail->getErrors();
					break;
				}
			}
			
			if($response["success"]) $transaction->commit();
			echo CJSON::encode($response);
		} else {
			$transaction->rollback();
			echo CJSON::encode(array(
				"success" => false,
				"error" => $contract->getErrors()
			));
		}
	}

	public function actionGetPrices() {
		$model = Cotizaciones::model()->with("contrato", "cotizacionDetalles", "idUsuario", "idCliente")->findAll("t.id_agencia = ". $_SESSION["Agencia"]->id_agencia);
		$general = Yii::app()->createController('general')[0];
		$response = $general->convertModelToArray($model, "desglose");
		echo json_encode($response);
	}

	public function actionGetPricesRequest($id) {
		$model = Cotizaciones::model()->with("contrato", "cotizacionDetalles", "idUsuario", "idCliente")->findAll("id_solicitud = ". $id);
		$general = Yii::app()->createController('general')[0];
		$response = $general->convertModelToArray($model, "desglose");
		echo json_encode($response);
	}

	public function actionGetPriceInfo($id) {
		$relations = array("cotizacionDetalles.idTipoServicio");
		$aux = Cotizaciones::model()->findByPk($id);
		if(is_null($aux->id_solicitud)) array_push($relations, "idCliente");
		else array_push($relations, "idSolicitud.idCliente");
		$model = Cotizaciones::model()->with($relations)->findByPk($id);
		$general = Yii::app()->createController('general')[0];
		$response = $general->convertModelToArray($model, "desglose");
		echo json_encode($response);
	}

	public function actionGetPriceInfoPdf($id) {
		$model = Cotizaciones::model()->with("idSolicitud.idCliente", "cotizacionDetalles.idTipoServicio")->findByPk($id);
		$general = Yii::app()->createController('general')[0];
		$response = $general->convertModelToArray($model, "desglose");
		echo json_encode($response);
	}

	public function actionCreateApi() {
		$transaction = Yii::app()->db->beginTransaction();
		$model = new Cotizaciones;
		$model->attributes = $_POST["price"];
		$model->id_agencia = $_SESSION["Agencia"]->id_agencia;
		$model->id_usuario = Yii::app()->user->id;
		
		$response = array(
			"success" => true,
			"price" => $model,
			"price_detail" => array(
				"errors" => 0,
				"response" => array()
			),
			"errors" => array()
		);
		if($model->save()) {

			foreach ($_POST["price_array"] as $key => $value) {
				$detail = new CotizacionDetalles();
				$detail->attributes = $value;
				$detail->id_cotizacion = $model->id_cotizacion;
				if($detail->id_tipo_servicio == 2 || $detail->id_tipo_servicio == 6) {
					$value["desglose"]["redondo"] = intval($value["desglose"]["redondo"]);
					if($detail->id_tipo_servicio == 6) $value["desglose"]["escala"] = intval($value["desglose"]["escala"]);
				}
				$detail->desglose = json_encode($value["desglose"]);
				if($detail->save()) {
					array_push($response["price_detail"]["response"], $detail);
				} else {
					$transaction->rollback();
					$response["success"] = false;
					$response["price_detail"]["errors"]++;
					array_push($response["price_detail"]["response"], $detail->getErrors());
				}
			}

			if($response["price_detail"]["errors"] == 0) $transaction->commit();
		} else {
			$transaction->rollback();
			$response["success"] = false;
			$response["errors"] = $model->getErrors();
		}

		echo CJSON::encode($response);
	}

	public function actionUpdateApi() {
		$model = Cotizaciones::model()->findByPk($_POST["price"]["id_cotizacion"]);
		$model->attributes = $_POST["price"];

		if($model->save()) {
			$cotizaciones = CotizacionDetalles::model()->findAll("id_cotizacion = " . $model->id_cotizacion);
			foreach ($cotizaciones as $key => $value) {
				$index = array_search($value->id_cotizacion_detalle, array_column($_POST["price_array"], 'id_cotizacion_detalle'));
				if (!$index && gettype($index) == "boolean") {
					$value->delete();
				}
			}

			$response = array(
				"price" => $model,
				"price_detail" => array(
					"errors" => 0,
					"response" => array()
				)
			);

			foreach ($_POST["price_array"] as $key => $value) {
				if ($value["id_cotizacion_detalle"]) {
					$detail = CotizacionDetalles::model()->findByPk($value["id_cotizacion_detalle"]);
				} else {
					$detail = new CotizacionDetalles;
				}
				$detail->attributes = $value;
				if($detail->id_tipo_servicio == 2 || $detail->id_tipo_servicio == 6) {
					$value["desglose"]["redondo"] = intval($value["desglose"]["redondo"]);
					if($detail->id_tipo_servicio == 6) $value["desglose"]["escala"] = intval($value["desglose"]["escala"]);
				}
				$detail->desglose = json_encode($value["desglose"]);
				$detail->id_cotizacion = $model->id_cotizacion;
				$detail->observaciones = $value["observaciones"];
				if($detail->save()) {
					array_push($response["price_detail"]["response"], $detail);
				} else {
					$response["price_detail"]["errors"]++;
					array_push($response["price_detail"]["response"], $detail->getErrors());
				}
			}
		} else {
			$response["price"] = $model->getErrors();
		}

		echo CJSON::encode($response);
	}

	public function actionDeleteApi($id) {
		$details = CotizacionDetalles::model()->findAll("id_cotizacion = " . $id);
		foreach ($details as $key => $value) {
			$value->delete();
		}

		$price = Cotizaciones::model()->findByPk($id);
		if($price->delete()) {
			echo json_encode(array(
				"success" => true
			));
		} else {
			echo json_encode(array(
				"success" => false
			));
		}
	}

	public function actionCreate($id = 0) {
		$with = $id != 0;
		$this->render("cu_form", array(
			"with" => $with,
			"action" => "create"
		));
	}

	public function actionUpdate($id) {
		$this->render("cu_form", array(
			"with" => false,
			"action" => "update"
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		if(Yii::app()->request->isPostRequest)
		{
			// we only allow deletion via POST request
			$this->loadModel($id)->delete();

			// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
			if(!isset($_GET['ajax']))
				$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
		}
		else
			throw new CHttpException(400,'Invalid request. Please do not repeat this request again.');
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex() {
		$this->render('index',array(
			'model'=>$model,
		));
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin() {
		$model=new Cotizaciones('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['Cotizaciones']))
			$model->attributes=$_GET['Cotizaciones'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer the ID of the model to be loaded
	 */
	public function loadModel($id) {
		$model=Cotizaciones::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param CModel the model to be validated
	 */
	protected function performAjaxValidation($model) {
		if(isset($_POST['ajax']) && $_POST['ajax']==='cotizaciones-form') {
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
}