<?php

class CuentasAgenciaController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout = '//layouts/column1';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array(
				'allow',  // allow all users to perform 'index' and 'view' actions
				'actions' => array('index', 'view'),
				'users' => array('@'),
			),
			array(
				'allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions' => array('create', 'update', 'delete', 'GeneratePdf', 'GenerateExcel', 'GetAgencyAccounts'),
				'users' => array('@'),
			),
			array(
				'allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions' => array('admin'),
				'users' => array('admin'),
			),
			array(
				'deny',  // deny all users
				'users' => array('*'),
			),
		);
	}

	public function actionGetAgencyAccounts() {
		$criteria = new CDbCriteria;
		$criteria->addCondition("id_agencia = '" . $_SESSION["Agencia"]->id_agencia . "'");
		$model = CuentasAgencia::model()->findAll($criteria);
		echo CJSON::encode($model);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view', array(
			'model' => $this->loadModel($id),
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate() {
		$model = new CuentasAgencia;
		$model->attributes = $_POST;
		$model->id_agencia = $_SESSION["Agencia"]->id_agencia;
		$model->estatus = 1;
		if ($model->save()) {
			echo CJSON::encode($model);
		} else {
			echo CJSON::encode($model->getErrors());
		}
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate() {
		$model = $this->loadModel($_POST["id_cuenta"]);
		$model->attributes = $_POST;
		$model->id_agencia = $_SESSION["Agencia"]->id_agencia;
		if ($model->save()) {
			echo CJSON::encode($model);
		} else {
			echo CJSON::encode($model->getErrors());
		}
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id) {
		$model = CuentasAgencia::model()->findByPk($id);
		$model->estatus = 0;
		if($model->save()) {
			echo json_encode(array(
				"success" => true,
			));
		} else {
			echo json_encode(array(
				"success" => false,
			));
		}
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		$session = new CHttpSession;
		$session->open();
		$criteria = new CDbCriteria();

		$model = new CuentasAgencia('search');
		$model->unsetAttributes();  // clear any default values

		if (isset($_GET['CuentasAgencia'])) {
			$model->attributes = $_GET['CuentasAgencia'];



			if (!empty($model->id_cuenta)) $criteria->addCondition("id_cuenta = '" . $model->id_cuenta . "'");


			if (!empty($model->cuenta)) $criteria->addCondition("cuenta = '" . $model->cuenta . "'");


			if (!empty($model->descripcion)) $criteria->addCondition("descripcion = '" . $model->descripcion . "'");


			if (!empty($model->id_agencia)) $criteria->addCondition("id_agencia = '" . $model->id_agencia . "'");


			if (!empty($model->estatus)) $criteria->addCondition("estatus = '" . $model->estatus . "'");


			$session['CuentasAgencia_records'] = CuentasAgencia::model()->findAll($criteria);
		}


		$this->render('index', array(
			'model' => $model,
		));
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model = new CuentasAgencia('search');
		$model->unsetAttributes();  // clear any default values
		if (isset($_GET['CuentasAgencia']))
			$model->attributes = $_GET['CuentasAgencia'];

		$this->render('admin', array(
			'model' => $model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer the ID of the model to be loaded
	 */
	public function loadModel($id)
	{
		$model = CuentasAgencia::model()->findByPk($id);
		if ($model === null)
			throw new CHttpException(404, 'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param CModel the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if (isset($_POST['ajax']) && $_POST['ajax'] === 'cuentas-agencia-form') {
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
	public function actionGenerateExcel()
	{
		$session = new CHttpSession;
		$session->open();

		if (isset($session['CuentasAgencia_records'])) {
			$model = $session['CuentasAgencia_records'];
		} else
			$model = CuentasAgencia::model()->findAll();


		Yii::app()->request->sendFile(
			date('YmdHis') . '.xls',
			$this->renderPartial('excelReport', array(
				'model' => $model
			), true)
		);
	}
	public function actionGeneratePdf()
	{
		$session = new CHttpSession;
		$session->open();
		Yii::import('application.extensions.bootstrap.gii.*');
		require_once('bootstrap/tcpdf/tcpdf.php');
		require_once('bootstrap/tcpdf/config/lang/eng.php');

		if (isset($session['CuentasAgencia_records'])) {
			$model = $session['CuentasAgencia_records'];
		} else
			$model = CuentasAgencia::model()->findAll();



		$html = $this->renderPartial('expenseGridtoReport', array(
			'model' => $model
		), true);

		//die($html);

		$pdf = new TCPDF();
		$pdf->SetCreator(PDF_CREATOR);
		$pdf->SetAuthor(Yii::app()->name);
		$pdf->SetTitle('CuentasAgencia Report');
		$pdf->SetSubject('CuentasAgencia Report');
		//$pdf->SetKeywords('example, text, report');
		$pdf->SetHeaderData('', 0, "Report", '');
		$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, "Example Report by " . Yii::app()->name, "");
		$pdf->setHeaderFont(array('helvetica', '', 8));
		$pdf->setFooterFont(array('helvetica', '', 6));
		$pdf->SetMargins(15, 18, 15);
		$pdf->SetHeaderMargin(5);
		$pdf->SetFooterMargin(10);
		$pdf->SetAutoPageBreak(TRUE, 0);
		$pdf->SetFont('dejavusans', '', 7);
		$pdf->AddPage();
		$pdf->writeHTML($html, true, false, true, false, '');
		$pdf->LastPage();
		$pdf->Output("CuentasAgencia_002.pdf", "I");
	}
}
