<?php

class EventosController extends Controller {
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column1';

	/**
	 * @return array action filters
	 */
	public function filters() {
		return array(
			'accessControl', // perform access control for CRUD operations
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules() {
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view'),
				'users'=>array('@'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update','GeneratePdf','GenerateExcel', 'getComments', 'uploadImages', 'deleteImage', 'saveMultimedia'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id) {
		$this->render('view');
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate() {
		$model = Eventos::model()->findByPk($_POST["id"]);
		$model->attributes = $_POST;

		if($_POST["correo_aux"] == "" || $_POST["correo_aux"] == "null") $model->correo_aux = NULL;

		if($model->save()) {
			echo CJSON::encode($model);
		} else {
			echo CJSON::encode($model->getErrors());
		}
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex() {
        $this->render('index');
	}

	public function actionGetComments($id) {
		$model = EventosComentarios::model()->findAll("id_evento = ". $id);
		echo CJSON::encode($model);
	}

	public function actionUploadImages() { //subir imagenes de la galeria
		$total_leng = count($_FILES["images"]["name"]);
		$response = array();
		for ($i = 0; $i < $total_leng; $i++) {
			$model = new EventosGaleria;
			$model->id_evento = $_POST["event_code"];
			$model->path = str_replace(' ', '-', $_FILES['images']['name'][$i]);

			if ($model->save()) {
				$file_url = "images/eventos/evento_". $_POST["event_code"] ."/galeria/". str_replace(' ', '-', $_FILES['images']['name'][$i]);
				move_uploaded_file($_FILES['images']['tmp_name'][$i], $file_url);
			} else {
				array_push($response, $model->getErrors());
			}
		}

		$images = EventosGaleria::model()->findAll("id_evento = ". $_POST["event_code"]);
		echo CJSON::encode($images);
	}

	public function actionDeleteImage($id) { // ---- id de la imagen ----eliminar imagenes de la galeria
		$model = EventosGaleria::model()->findByPk($id);
		$event_code = $model->id_evento;
		$img_name = $model->path;
		if($model->delete()) {
			unlink("images/eventos/evento_". $event_code ."/galeria/". $img_name);
			echo json_encode(array(
				"success" => true
			));
		} else {
			echo json_encode(array(
				"success" => false
			));
		}
	}

	public function actionSaveMultimedia() {
		$model = EventosMultimedia::model()->find("id_evento = ". $_POST["event_code"] ." AND posicion = '". $_POST["position"] ."'");
		if(is_null($model)) {
			$model = new EventosMultimedia;
			$model->posicion = $_POST["position"];
			$model->orden = 1;
			$model->id_evento = $_POST["event_code"];
		}
		$model->path = str_replace(' ', '-', $_FILES['image']['name']);

		if($model->save()) {
			$file_url = "images/eventos/evento_". $_POST["event_code"] ."/multimedia/". str_replace(' ', '-', $_FILES['image']['name']);
			move_uploaded_file($_FILES['image']['tmp_name'], $file_url);
			echo CJSON::encode($model);
		} else {
			echo CJSON::encode($model->getErrors());
		}
	}
}