<?php

class FirmasController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column1';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view','getSignatureBase64','uploadSignatureBase64','getCustomerSignatureBase64'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update','GeneratePdf','GenerateExcel'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	public function actionGetSignatureBase64($iu) {
		$signature = Firmas::model()->find("id_user = ". $iu);
		if (is_null($signature->id_firma)) {
			echo "not found";
		} else {
			echo base64_encode(file_get_contents($_SERVER['DOCUMENT_ROOT'] . "/admin/images/firmas/" . $iu . "-signature.jpg"));
		}
	}

	public function uploadSignature($data, $user) {
		list($type, $data) = explode(';', $data);
		list(, $data) = explode(',', $data);
		$data = base64_decode($data);
		/*echo $this->root ."/archivos/contratos/". $url ."/image.png";
		exit;*/

		$signature_model = Firmas::model()->find("id_user = ". $user);
		if (!isset($signature_model->id_firma)) {
			$signature_model = new Firmas;
			$signature_model->firma = $user ."-signature.jpg";
			$signature_model->id_user = $user;
			$signature_model->save();
		}

		if (file_put_contents($_SERVER['DOCUMENT_ROOT'] ."/admin/images/firmas/". $signature_model->firma, $data)) {
			return true;
		} else {
			return false;
		}
	}

	public function actionUploadSignatureBase64() {
		$data = $_POST["base64img"];
		$response = $this->uploadSignature($data, Yii::app()->user->id);
		echo json_encode(array("success" => $response));
	}
}