<?php
Yii::import('application.extensions.bootstrap.gii.*');
require_once('bootstrap/tcpdf/tcpdf.php');
require_once('bootstrap/tcpdf/config/lang/eng.php');

class FormatosController extends Controller
{

	public $layout = '//layouts/column1';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array(
				'allow',  // allow all users to perform 'index' and 'view' actions
				'actions' => array('contrato', 'index'),
				'users' => array('*'),
			),
			array(
				'allow',  // allow all users to perform 'index' and 'view' actions
				'actions' => array('contratoV2', 'venta', 'cotizacion'),
				'users' => array('*'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array(
				'deny',  // deny all users
				'users' => array('*'),
			),
		);
	}

	public function actionContrato($id)
	{
		$this->getPdfVenta($id, "I", "Contratos", 3);
	}

	public function actionContratoV1($id)
	{
		$this->getPdfVenta($id, "I", "Contratos");
	}

	public function actionContratoV2($id)
	{
		$this->getPdfVenta($id, "I", "Contratos", 2);
	}

	public function actionCotizacion($id)
	{
		$this->getPdfVenta($id, "I", "Cotizaciones");
	}

	public function actionVenta($id)
	{
		$this->getPdfVenta($id, "I", "Ventas");
	}

	public function getPdfVenta($id, $output, $formato, $v = 0)
	{
		$formato_model = $formato::model()->findByPk($id);
		$id_usuario = $formato == "Contratos" ? $formato_model->id_user_creo : $formato_model->id_usuario;
		$user_model = UsuariosAgencias::model()->find("id_usuario = ". $id_usuario);
		$agency_model = Agencia::model()->findByPk($user_model->id_agencia);
		
		$pdf = new MYPDF();
		$pdf->SetCreator(PDF_CREATOR);
		$pdf->SetAuthor(Yii::app()->name);
		if($formato == "Contratos") {
			$pdf->SetTitle("Contrato-" . date_format(date_create($formato_model->log), "dmY") . $id);
			$pdf->SetSubject("Contrato-" . date_format(date_create($formato_model->log), "dmY") . $id);
		} else if($formato == "Cotizaciones") {
			$pdf->SetTitle("Cotizacion-" . date_format(date_create($formato_model->log), "dmY") . $id);
			$pdf->SetSubject("Cotizacion-" . date_format(date_create($formato_model->log), "dmY") . $id);
		} else {
			$pdf->SetTitle("Recibo-" . date_format(date_create($formato_model->log), "dmY") . $id);
			$pdf->SetSubject("Recibo-" . date_format(date_create($formato_model->log), "dmY") . $id);
		}
		$pdf->SetMargins(20, 47, 20);
		
		$pdf->setFontSubsetting(false);
		$fontname = $pdf->addTTFfont($_SERVER["DOCUMENT_ROOT"] .'/admin/css/fonts/CenturyGothic.ttf', 'TrueTypeUnicode', '', 32);
		$boldfontname = $pdf->addTTFfont($_SERVER["DOCUMENT_ROOT"] .'/admin/css/fonts/GOTHICB.TTF', 'TrueTypeUnicode', '', 32);
		$pdf->AddFont($fontname); //centurygothic
		$pdf->AddFont($boldfontname); //gothicb
		$pdf->setHeaderFont(array($fontname, '', 10));
		$pdf->setPrintHeader(true);
		$pdf->SetHeaderMargin(10);
		
		$pdf->setPrintFooter(true);
		$pdf->SetFooterMargin(14);

		$pdf->SetAutoPageBreak(TRUE, 30); //SEGUNDO PARAMETRO PARA MARGIN BOTTOM
		$pdf->SetFont($fontname, '', 10);
		// $pdf->setPageOrientation('L');

		preg_match('/^(\d{3})(\d{3})(\d{4})$/', $agency_model->telefono, $matches);
		$formatted_phone = "(" . $matches[1] . ") " . $matches[2] . "-" . $matches[3];
		preg_match('/^(\d{3})(\d{3})(\d{4})$/', $agency_model->whatsapp, $matches_whatsapp);
		$formatted_phone_whatsapp = "(" . $matches_whatsapp[1] . ") " . $matches_whatsapp[2] . "-" . $matches_whatsapp[3];
		
		$url = $_SERVER['DOCUMENT_ROOT'] . "/";
		$agency_logo = $url . "admin/images/agencia/" . $agency_model->logotipo;
		
		if (empty($agency_model->logotipo) || !is_readable($agency_logo)) {
			$agency_logo = "https://2businesstravel.com/rentas/images/businesses/logo-agencia-no-definido.png";
		}
		if ($agency_model->rnt != null) { $sectur =  "No. De registro ante SECTUR: " . $agency_model->rnt . "<br>"; }
		if ($agency_model->rfc != null) { $rfc =  "RFC: " . $agency_model->rfc . "<br>"; }
		if ($agency_model->whatsapp != null) { $whatsapp =  "Whatsapp: " . $formatted_phone_whatsapp . "<br>"; }
		$pdf_header = '
		<table style="margin-bottom=0px; font-size:28px;">
			<tr>
				<td><img height="80" src="' . $agency_logo . '">
				<br>'.
				$agency_model->nombre_comercial . '
				</td>
				<td align="right">
					' . $sectur . '
					' . $rfc . '
					Dirección: ' . $agency_model->direccion . '
					<br>
					' . $whatsapp . '
					Teléfono: ' . $formatted_phone . '
					<br>
					Correo: ' . $agency_model->correo . '
					<br>
					' . $agency_model->sitio_web . '
				</td>
			</tr>
		</table>';
		$pdf->pdf_header = $pdf_header;
		if ($formato == "Contratos") $pdf->footer_text = "ORIGINAL";

		$pdf->AddPage();

		if ($formato == "Ventas") {
			$html = $this->renderPartial("venta", array(
				"model" => $formato_model,
			), true);
		} elseif ($formato == "Contratos") {
			if($v == 2) {
				$html = $this->renderPartial("contratoV2", array(
					"model" => $formato_model,
				), true);
			} else if($v == 3) {
				$html = $this->renderPartial("contratoV3", array(
					"model" => $formato_model,
				), true);
			} else {
				$html = $this->renderPartial("contrato", array(
					"model" => $formato_model,
				), true);
			}
		} elseif ($formato == "Cotizaciones") {
			$html = $this->renderPartial("cotizacion", array(
				"model" => $formato_model,
			), true);
		}
		$pdf->writeHTML($html, true, false, true, false, '');
		/* $pdf_footer = '
		<table style="margin-bottom=0px; width:100%; background-color: #88ccba; vertical-align: middle;">
			<tr>
			<td width="30%" style="display: flex; align-items: center;">
			<img width="30" src="' . $agency_logo . '">' . $agency_model->nombre_comercial . '</td>
			<td width="30"><img width="30" src="https://erpv2.2businesstravel.com/admin/images/iconos/icono-wp3.png"></td>
			<td>'. $formatted_phone .'</td>
			<td width="40%"><img width="30" src="https://erpv2.2businesstravel.com/admin/images/iconos/icono-correo.png"> ' . $agency_model->correo . '</td>
			</tr>
		</table>';
		$pdf->pdf_footer = $pdf_footer; */
		$pdf->LastPage();
		if ($output == "S") {
			return $pdf->Output("Recibo-" . $id . ".pdf", $output);
		}
		$pdf->Output("Recibo-" . $id . ".pdf", $output);
	}

	public function actionIndex(){
		$this->layout = "//layouts/vuely"; 
		$this->render("index");
	}
}
class MYPDF extends TCPDF
{
	public $pdf_header;

	//Page header
	public function Header()
	{
		//$this->SetFont('helvetica', '', 11);
		$this->writeHTML($this->pdf_header, false, true, false, true);
	}

	var $angle=0;
	public $footer_text;
	public function Footer()
    {
        //Put the watermark
        $this->SetFont('', 'B', 72);
        $this->SetTextColor(0, 0, 0);
		$this->SetAlpha(0.09);
        $this->RotatedText(55, 170, $this->footer_text, 45);
    }
	
	function Rotate($angle, $x=-1, $y=-1)
	{
		if($x == -1)
			$x = $this->x;
		if($y == -1)
			$y = $this->y;
		if($this->angle != 0)
			$this->_out('Q');
		$this->angle = $angle;
		if($angle != 0)
		{
			$angle *= M_PI / 180;
			$c = cos($angle);
			$s = sin($angle);
			$cx = $x * $this->k;
			$cy = ($this->h-$y) * $this->k;
			$this->_out(sprintf('q %.5F %.5F %.5F %.5F %.2F %.2F cm 1 0 0 1 %.2F %.2F cm', $c, $s, -$s, $c, $cx, $cy, -$cx, -$cy));
		}
	}

	function RotatedText($x, $y, $txt, $angle)
	{
		//Text rotated around its origin
		$this->Rotate($angle, $x, $y);
		$this->Text($x, $y, $txt);
		$this->Rotate(0);
	}

	function _endpage()
	{
		if($this->angle != 0)
		{
			$this->angle = 0;
			$this->_out('Q');
		}
		parent::_endpage();
	}
}