<?php

class GastosController extends Controller {
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column1';

	/**
	 * @return array action filters
	 */
	public function filters() {
		return array(
			'accessControl', // perform access control for CRUD operations
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules() {
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index', 'view'),
				'users'=>array('@'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create', 'update', 'delete', 'getAgencyExpenses'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	public function actionGetAgencyExpenses() {
		//$additional_sql = $_SESSION["Usuario"]->rol == "Agente" ? " AND t.id_usuario = ". Yii::app()->user->id : "";
		$model = Gastos::model()->with("idFormaPago", "idUsuario.profiles", "idCuenta", "idProveedor")->findAll('t.id_agencia = '. $_SESSION["Agencia"]->id_agencia .$additional_sql);
		$general = Yii::app()->createController('general')[0];
		$response = $general->convertModelToArray($model);
		echo json_encode($response);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id) {
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate() {
		$model = new Gastos;
		$model->attributes = $_POST;
		$model->id_usuario = Yii::app()->user->id;
		$model->id_agencia = $_SESSION["Agencia"]->id_agencia;
		
		$model->referencia = $_POST["referencia"] == "" ? NULL : $_POST["referencia"];
		$model->observaciones = $_POST["observaciones"] == "" ? NULL : $_POST["observaciones"];

		if($model->save()) {
			if(is_uploaded_file($_FILES["file_comprobante"]["tmp_name"])) {
				$fecha = date("dmY");
				$file_name = $model->id_gasto .'-'. str_replace(' ', '-', $_FILES['file_comprobante']['name']);
				$file_url = 'images/comprobantes/'. $file_name;
				move_uploaded_file($_FILES['file_comprobante']['tmp_name'], $file_url);
				$model->comprobante = $file_name;
			} else {
				$model->comprobante = NULL;
			}
			$model->save();
			echo CJSON::encode($model);
		} else {
			echo CJSON::encode($model->getErrors());
		}
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate() {
		$model = Gastos::model()->findByPk($_POST["id_gasto"]);
		$model->attributes = $_POST;
		if($_POST["comprobante"] == "" || $_POST["comprobante"] == "null") {
			$model->comprobante = null;
		}
		$model->referencia = $_POST["referencia"] == "" ? null : $_POST["referencia"];
		$model->observaciones = $_POST["observaciones"] == "" ? null : $_POST["observaciones"];

		if($model->save()) {
			if(is_uploaded_file($_FILES["file_comprobante"]["tmp_name"])) {
				if(!is_null($model->comprobante)) {
					$url_img = "images/comprobantes/". $model->comprobante;
					unlink($url_img);
				}

				$fecha = date("dmY");
				$file_name = $model->id_gasto .'-'. str_replace(' ', '-', $_FILES['file_comprobante']['name']);
				$file_url = 'images/comprobantes/'. $file_name;
				move_uploaded_file($_FILES['file_comprobante']['tmp_name'], $file_url);
				$model->comprobante = $file_name;
				$model->save();
			}
			echo CJSON::encode($model);
		} else {
			echo CJSON::encode($model->getErrors());
		}
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id) {
		$model = Gastos::model()->findByPk($id);
		$url_img = "images/comprobantes/". $model->comprobante;
		if($model->delete()) {
			if(!is_null($model->comprobante)) {
				unlink($url_img);
			}
			echo json_encode(array(
				"success" => true,
			));
		} else {
			echo json_encode(array(
				"success" => false,
			));
		}
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex() {
        $this->render('index');
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin() {
		$model=new Gastos('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['Gastos']))
			$model->attributes=$_GET['Gastos'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer the ID of the model to be loaded
	 */
	public function loadModel($id) {
		$model=Gastos::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param CModel the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='gastos-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
}
