<?php

class GeneralController extends Controller
{

    public function convertModelToArray($models, $attribute = null)
    {
        if (is_array($models))
            $arrayMode = TRUE;
        else {
            $models = array($models);
            $arrayMode = FALSE;
        }

        $result = array();

        foreach ($models as $model) {
            if(!is_null($attribute) && $model->hasAttribute($attribute)) {
                $model[$attribute] = json_decode($model[$attribute], true);
            }

            $attributes = $model->getAttributes();
            $relations = array();

            foreach ($model->relations() as $key => $related) {
                if ($model->hasRelated($key)) {
                    if ($model->$key) {
                        $relations[$key] = $this->convertModelToArray($model->$key, $attribute);
                    } else {
                        $relations[$key] = [];
                    }
                }
            }

            $all = array_merge($attributes, $relations);

            if ($arrayMode)
                array_push($result, $all);
            else
                $result = $all;
        }

        return $result;
    }

    public function GetSqlFromCriteria($table, $criteria) {
        $schema = Yii::app()->db->schema;
    	$builder = $schema->commandBuilder;
		$command = $builder->createFindCommand($schema->getTable($table), $criteria);
		$results = $command->text;
		return $results;
    }

    public function actionPhoneFormat($number, $code = null) {
        // Allow only Digits, remove all other characters.
        $number = preg_replace("/[^\d]/", "", $number);

        // get number length.
        $length = strlen($number);

        // if number = 10
        if ($length == 10) {
            $number = preg_replace("/^1?(\d{3})(\d{3})(\d{4})$/", "($1) $2 $3", $number);
        }
        if ($code != null) {
            return "+" . $code . " " . $number;
        } else {
            return $number;
        }
    }
}
