<?php

class GruposController extends Controller {
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout = '//layouts/column1';

	/**
	 * @return array action filters
	 */
	public function filters() {
		return array(
			'accessControl', // perform access control for CRUD operations
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules() {
		return array(
			array(
				'allow',
				'actions' => array('apiGrupo', 'getGroupInfoApi', 'getGroupHabs', 'getInfoForWeb', 'getInfoForWebV2'),
				'users' => array('*'),
			),
			array(
				'allow',  // allow all users to perform 'index' and 'view' actions
				'actions' => array('index', 'view'),
				'users' => array('@'),
			),
			array(
				'allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions' => array('create', 'update', 'delete', 'GeneratePdf', 'GenerateExcel', 'view', 'gruposApi', 'getGroupInfo', 'getGroupHabs', 'createHab', 'updateHab', 'deleteHab', 'uploadFiles', 'getGroupsForSelect2'),
				'users' => array('@'),
			),
			array(
				'allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions' => array('admin', 'view'),
				'users' => array('admin'),
			),
			array(
				'deny',  // deny all users
				'users' => array('*'),
			),
		);
	}

	public function actionCreateHab() {
		$hab = new GrupoHabitaciones;
		$hab->attributes = $_POST['hab'];

		if($hab->save()) {
			$response = array(
				"hab" => $hab,
				"guests" => array()
			);
			foreach ($_POST["guests"] as $key => $value) {
				$guest = new HabitacionesHuespedes;
				$guest->attributes = $value;
				$guest->id_habitacion = $hab->id_habitacion;
				if($guest->correo == "") $guest->correo = NULL;
				if($guest->telefono == "") $guest->telefono = NULL;
				$guest->save();
				array_push($response["guests"], $guest);
			}
			echo CJSON::encode($response);
		} else {
			echo CJSON::encode($hab->getErrors());
		}
	}

	public function actionUpdateHab() {
		$hab = GrupoHabitaciones::model()->findByPk($_POST["hab"]["id_habitacion"]);
		$hab->attributes = $_POST['hab'];
		if($hab->save()) {
			$response = array(
				"hab" => $model,
				"guests" => array()
			);

			$guests = HabitacionesHuespedes::model()->findAll("id_habitacion = " . $hab->id_habitacion);
			foreach ($guests as $key => $value) {
				$index = array_search($value->id_huesped, array_column($_POST["guests"], 'id_huesped'));
				if (!$index && gettype($index) == "boolean") {
					$value->delete();
				}
			}

			foreach ($_POST["guests"] as $key => $value) {
				if ($value["id_huesped"]) {
					$guest = HabitacionesHuespedes::model()->findByPk($value["id_huesped"]);
				} else {
					$guest = new HabitacionesHuespedes;
				}
				$guest->attributes = $value;
				$guest->id_habitacion = $hab->id_habitacion;
				if($guest->correo == "") $guest->correo = NULL;
				if($guest->telefono == "") $guest->telefono = NULL;
				if($guest->save()) {
					array_push($response["guests"], $guest);
				} else {
					array_push($response["guests"], $guest->getErrors());
				}
				echo CJSON::encode($response);
			}
		} else {
			echo CJSON::encode($hab->getErrors());
		}
	}

	public function actionDeleteHab($id) {
		$hab = GrupoHabitaciones::model()->findByPk($id);
		$guests = HabitacionesHuespedes::model()->findAll("id_habitacion = ". $hab->id_habitacion);
		foreach ($guests as $key => $value) {
			$value->delete();
		}
		if($hab->delete()) {
			echo json_encode(array(
				"success" => true
			));
		} else {
			echo json_encode(array(
				"success" => false
			));
		}
	}

	public function actionGruposApi() {
		$additional_sql = $_SESSION["Usuario"]->rol == "Agente" ? " AND idVenta.id_usuario = ". Yii::app()->user->id : "";
		$model = Grupos::model()->with('idAgencia', 'idVentaservicio.idVenta', 'idCliente', 'grupoHabitaciones.habitacionesHuespedes')->findAll('t.id_agencia = "'. $_SESSION['Agencia']->id_agencia .'" AND t.tipo = "Grupo"'. $additional_sql);
		$general = Yii::app()->createController('general')[0];
		$array = $general->convertModelToArray($model);
		echo json_encode($array);
	}

	public function actionGetGroupInfo() {
		header('Access-Control-Allow-Origin: *');
		header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
		header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
		header("Allow: GET, POST, OPTIONS, PUT, DELETE");
		$relations_array = [ 'idAgencia', 'idVentaservicio.idVenta', 'idVentaservicio.idProveedor', 'idVentaservicio.pagosDetalles.idPago', 'idCliente', 'gruposArchivoses', 'grupoHabitaciones' ];
		if ($_POST["tipo"] == "boda" || $_POST["tipo"] == "grupo") {
			array_push($relations_array, "invitaciones");
			array_push($relations_array, "evento.eventoGaleria");
			array_push($relations_array, "evento.eventoMultimedia");
		}
		$model = Grupos::model()->with($relations_array)->find("t.id_grupo = ". $_POST["id"] ." AND t.tipo = '". $_POST["tipo"] ."'");
		$general = Yii::app()->createController('general')[0];
		$response = $general->convertModelToArray($model);
		echo json_encode($response);
	}

	public function actionGetInfoForWeb($id) {
		$model = Grupos::model()->with("idAgencia", "idVentaservicio", "evento.eventoComentarios", "evento.eventoGaleria", "evento.eventoMultimedia")->findByPk($id);
		$general = Yii::app()->createController('general')[0];
		$response = $general->convertModelToArray($model, "desglose");
		echo json_encode($response);
	}

	public function actionGetInfoForWebV2($slug) {
		header('Content-Type: application/json;');
		$event = Eventos::model()->find("slug LIKE '". $slug ."'");
		if(is_null($event)) {
			echo json_encode(array(
				"success" => false
			));
		} else {
			$model = Grupos::model()->with("idAgencia", "idVentaservicio", "evento.eventoComentarios", "evento.eventoGaleria", "evento.eventoMultimedia")->findByPk($event->id_grupo);
			$general = Yii::app()->createController('general')[0];
			$response = $general->convertModelToArray($model, "desglose");
			echo json_encode(array(
				"success" => true,
				"response" => $response
			));
		}
	}

	public function actionGetGroupHabs($id) {
		header('Access-Control-Allow-Origin: *');
		header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
		header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
		header("Allow: GET, POST, OPTIONS, PUT, DELETE");
		$model = GrupoHabitaciones::model()->with("habitacionesHuespedes")->findAll("id_grupo = $id");
		$general = Yii::app()->createController('general')[0];
		$response = $general->convertModelToArray($model);
		echo json_encode($response);
	}

	public function actionUploadFiles() {
		$total_leng = count($_FILES["files"]["name"]);
		$response = array();
		for ($i = 0; $i < $total_leng; $i++) {
			$model = new GruposArchivos;
			$model->id_grupo = $_POST["group_code"];

			$fecha = date("dmY");
			$file_name = $_POST["group_code"] . $fecha .'-'. $_FILES['files']['name'][$i];
			$model->path = $file_name;
			$model->log = date("Y-m-d H:m:s");
			if($model->save()) {
				$file_url = "files/". str_replace(' ', '-', $file_name);
				move_uploaded_file($_FILES['files']['tmp_name'][$i], $file_url);
			} else {
				array_push($response, $model->getErrors());
			}
		}

		$files = GruposArchivos::model()->findAll("id_grupo = ". $_POST["group_code"]);
		echo CJSON::encode($files);
	}

	public function actionGetGroupsForSelect2($type) {
		$criteria = new CDbCriteria;
		$criteria->condition = "idVenta.id_agencia = ". $_SESSION['Agencia']->id_agencia ." AND id_tipo_servicio = $type";
		$criteria->order = "id_ventaservicio DESC";
		$model = VentasServicios::model()->with("idVenta")->findAll($criteria);
		
		$response = array();
		foreach ($model as $key => $item) {
			$find = Grupos::model()->find("id_ventaservicio = ". $item->id_ventaservicio);
			array_push($response, array(
				"id" => $item->idVenta->id_venta,
				"text" => $item->idVenta->folio ." - ". $find->titulo_evento
			));
		}
		echo json_encode($response);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	/* public function actionView($id) {
		$model = $this->loadModel($id);

		if ($_SESSION['Agencia']->id_agencia == $model->idAgencia->id_agencia) {
			$this->render('view', array(
				'model' => $this->loadModel($id),
			));
		} else {
			$this->render('grupos');
		}
	} */
	public function actionView($id) {
		$this->render('view', array(
			"group_type" => "grupo"
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate() {
		$model = new Grupos;

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if (isset($_POST['Grupos'])) {
			$model->attributes = $_POST['Grupos'];
			if ($model->save())
				$this->redirect(array('view', 'id' => $model->id_grupo));
		}

		$this->render('create', array(
			'model' => $model,
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate() {
		$model = Grupos::model()->findByPk($_POST["id_grupo"]);
		$model->attributes = $_POST;
		if($model->save()) {
			echo json_encode(array(
				"success" => true
			));
		} else {
			echo json_encode(array(
				"success" => false
			));
		}
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id) {
		$model = Grupos::model()->findByPk($id);
		$model->estatus = "Desactivado";
		if($model->save()) {
			$venta = Ventas::model()->findByPk($model->id_venta);
			$venta->estatus = "cancelada";
			$venta->save();
			echo json_encode(array(
				"success" => true
			));
		} else {
			echo json_encode(array(
				"success" => false
			));
		}
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex() {
		$this->render('index', array(
			"group_type" => "grupos"
		));
	}
	/**
	 * Manages all models.
	 */
	public function actionAdmin() {
		$model = new Grupos('search');
		$model->unsetAttributes();  // clear any default values
		if (isset($_GET['Grupos']))
			$model->attributes = $_GET['Grupos'];

		$this->render('admin', array(
			'model' => $model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer the ID of the model to be loaded
	 */
	public function loadModel($id) {
		$model = Grupos::model()->with('idAgencia', 'idVenta', 'idCliente', 'habitacionesHuespedes', 'grupoHabitaciones')->findByPk($id);
		if ($model === null)
			throw new CHttpException(404, 'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param CModel the model to be validated
	 */
	protected function performAjaxValidation($model) {
		if (isset($_POST['ajax']) && $_POST['ajax'] === 'grupos-form') {
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}

	public function actionapiGrupo($id) {
		header('Access-Control-Allow-Origin: *');
		header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
		header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
		header("Allow: GET, POST, OPTIONS, PUT, DELETE");

		$bodas = Grupos::model()->with('idAgencia', 'idVentaservicio', 'idVentaservicio.idVenta')->findAll('t.id_cliente="' . $id . '" AND t.tipo="Grupo"');
		$general = Yii::app()->createController('general')[0];
		$array = $general->convertModelToArray($bodas);
		echo json_encode($array);
	}

	public function actionGetGroupInfoApi($id) {
		header('Access-Control-Allow-Origin: *');
		header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
		header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
		header("Allow: GET, POST, OPTIONS, PUT, DELETE");

		$model = Grupos::model()->with('idAgencia', 'idVentaservicio.idVenta', 'idVentaservicio.idProveedor', 'idVentaservicio.pagosDetalles.idPago', 'idCliente', 'gruposArchivoses')->find("t.id_grupo = " . $id);
		$general = Yii::app()->createController('general')[0];
		$response = $general->convertModelToArray($model);
		echo json_encode($response);

		// $relations_array = ['idAgencia', 'idVentaservicio.idVenta', 'idVentaservicio.idProveedor', 'idVentaservicio.pagosDetalles.idPago', 'idCliente', 'gruposArchivoses'];
		// if ($_POST["tipo"] == "boda") array_push($relations_array, "invitaciones");
		// $model = Grupos::model()->with($relations_array)->find("t.id_grupo = " . $_POST["id"] . " AND t.tipo = '" . $_POST["tipo"] . "'");
		// $general = Yii::app()->createController('general')[0];
		// $response = $general->convertModelToArray($model);
		// echo json_encode($response);
	}
}