<?php

class PromesasPagosController extends Controller
{
    /**
     * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
     * using two-column layout. See 'protected/views/layouts/column2.php'.
     */
    public $layout = '//layouts/column1';

    /**
     * @return array action filters
     */
    public function filters()
    {
        return array(
            'accessControl' // perform access control for CRUD operations
        );
    }

    /**
     * Specifies the access control rules.
     * This method is used by the 'accessControl' filter.
     * @return array access control rules
     */
    public function accessRules()
    {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('index', 'view', 'deletePaymentsPromises', 'loadPaymentsPromises'),
                'users' => array('@')
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('create', 'update', 'GeneratePdf', 'GenerateExcel'),
                'users' => array('@')
            ),
            array(
                'allow', // allow admin user to perform 'admin' and 'delete' actions
                'actions' => array('admin', 'delete'),
                'users' => array('admin')
            ),
            array(
                'deny', // deny all users
                'users' => array('*')
            )
        );
    }

    /**
     * Displays a particular model.
     * @param integer $id the ID of the model to be displayed
     */
    public function actionView($id)
    {
        $this->render('view', array(
            'model' => $this->loadModel($id)
        ));
    }

    /**
     * Creates a new model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     */
    public function actionCreate()
    {
        $transaction = Yii::app()->db->beginTransaction();
        $response = array(
            "success" => true,
            "payments" => array()
        );
        foreach ($_POST["payments"] as $key => $value) {
            $model = new PromesasPagos;
            $model->attributes = $value;
            if ($model->save()) {
                array_push($response["payments"], $model);
            } else {
                $transaction->rollback();
                $response["success"] = false;
                array_push($response["payments"], $model->getErrors());
            }
        }
        if ($response["success"]) $transaction->commit();
        echo CJSON::encode($response);
    }

    public function actionDeletePaymentsPromises()
    {
        $transaction = Yii::app()->db->beginTransaction();
        $response = array(
            "success" => true,
            "payments" => array()
        );
        $id_venta = $_POST['id_venta'];
        $model_promesas = PromesasPagos::model()->findAll("id_venta = " . $id_venta);
        foreach ($model_promesas as $key => $promesa) {
            if ($promesa->delete()) {
                array_push($response["payments"], $promesa);
            } else {
                $transaction->rollback();
                $response["success"] = false;
                array_push($response["payments"], $promesa->getErrors());
            }
        }
        if ($response["success"]) $transaction->commit();
        echo CJSON::encode($response);
    }

    public function actionLoadPaymentsPromises(){
        $id_venta = $_POST['id_venta'];
        $model_promesas = PromesasPagos::model()->findAll("id_venta = " . $id_venta);
        echo CJSON::encode($model_promesas);
    }

    /**
     * Updates a particular model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id the ID of the model to be updated
     */
    public function actionUpdate($id)
    {
        $model = $this->loadModel($id);

        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);

        if (isset($_POST['PromesasPagos'])) {
            $model->attributes = $_POST['PromesasPagos'];
            if ($model->save()) {
                $this->redirect(array('view', 'id' => $model->id));
            }
        }

        $this->render('update', array(
            'model' => $model
        ));
    }

    /**
     * Deletes a particular model.
     * If deletion is successful, the browser will be redirected to the 'admin' page.
     * @param integer $id the ID of the model to be deleted
     */
    public function actionDelete($id)
    {
        if (Yii::app()->request->isPostRequest) {
            // we only allow deletion via POST request
            $this->loadModel($id)->delete();

            // if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
            if (!isset($_GET['ajax'])) {
                $this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
            }
        } else {
            throw new CHttpException(400, 'Invalid request. Please do not repeat this request again.');
        }
    }

    /**
     * Lists all models.
     */
    public function actionIndex()
    {
        $session = new CHttpSession();
        $session->open();
        $criteria = new CDbCriteria();

        $model = new PromesasPagos('search');
        $model->unsetAttributes(); // clear any default values

        if (isset($_GET['PromesasPagos'])) {
            $model->attributes = $_GET['PromesasPagos'];

            if (!empty($model->id)) {
                $criteria->addCondition("id = '" . $model->id . "'");
            }

            if (!empty($model->monto)) {
                $criteria->addCondition("monto = '" . $model->monto . "'");
            }

            if (!empty($model->fecha)) {
                $criteria->addCondition("fecha = '" . $model->fecha . "'");
            }

            if (!empty($model->id_venta)) {
                $criteria->addCondition("id_venta = '" . $model->id_venta . "'");
            }

            $session['PromesasPagos_records'] = PromesasPagos::model()->findAll($criteria);
        }

        $this->render('index', array(
            'model' => $model
        ));
    }

    /**
     * Manages all models.
     */
    public function actionAdmin()
    {
        $model = new PromesasPagos('search');
        $model->unsetAttributes(); // clear any default values
        if (isset($_GET['PromesasPagos'])) {
            $model->attributes = $_GET['PromesasPagos'];
        }

        $this->render('admin', array(
            'model' => $model
        ));
    }

    /**
     * Returns the data model based on the primary key given in the GET variable.
     * If the data model is not found, an HTTP exception will be raised.
     * @param integer the ID of the model to be loaded
     */
    public function loadModel($id)
    {
        $model = PromesasPagos::model()->findByPk($id);
        if ($model === null) {
            throw new CHttpException(404, 'The requested page does not exist.');
        }

        return $model;
    }

    /**
     * Performs the AJAX validation.
     * @param CModel the model to be validated
     */
    protected function performAjaxValidation($model)
    {
        if (isset($_POST['ajax']) && $_POST['ajax'] === 'promesas-pagos-form') {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }
    }

    public function actionGenerateExcel()
    {
        $session = new CHttpSession();
        $session->open();

        if (isset($session['PromesasPagos_records'])) {
            $model = $session['PromesasPagos_records'];
        } else {
            $model = PromesasPagos::model()->findAll();
        }

        Yii::app()->request->sendFile(
            date('YmdHis') . '.xls',
            $this->renderPartial('excelReport', array(
                'model' => $model
            ), true)
        );
    }

    public function actionGeneratePdf()
    {
        $session = new CHttpSession();
        $session->open();
        Yii::import('application.extensions.bootstrap.gii.*');
        require_once 'bootstrap/tcpdf/tcpdf.php';
        require_once 'bootstrap/tcpdf/config/lang/eng.php';

        if (isset($session['PromesasPagos_records'])) {
            $model = $session['PromesasPagos_records'];
        } else {
            $model = PromesasPagos::model()->findAll();
        }

        $html = $this->renderPartial('expenseGridtoReport', array(
            'model' => $model
        ), true);

        //die($html);

        $pdf = new TCPDF();
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor(Yii::app()->name);
        $pdf->SetTitle('PromesasPagos Report');
        $pdf->SetSubject('PromesasPagos Report');
        //$pdf->SetKeywords('example, text, report');
        $pdf->SetHeaderData('', 0, "Report", '');
        $pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, "Example Report by " . Yii::app()->name, "");
        $pdf->setHeaderFont(array('helvetica', '', 8));
        $pdf->setFooterFont(array('helvetica', '', 6));
        $pdf->SetMargins(15, 18, 15);
        $pdf->SetHeaderMargin(5);
        $pdf->SetFooterMargin(10);
        $pdf->SetAutoPageBreak(true, 0);
        $pdf->SetFont('dejavusans', '', 7);
        $pdf->AddPage();
        $pdf->writeHTML($html, true, false, true, false, '');
        $pdf->LastPage();
        $pdf->Output("PromesasPagos_002.pdf", "I");
    }
}
