<?php

class ProveedoresContactoController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column1';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('create','index','view','delete','ProveedoresContactoApi','eliminarContacto'),
				'users'=>array('@'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update','delete','GeneratePdf','GenerateExcel','ProveedoresContactoApi','eliminarContacto'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('create','admin','delete','ProveedoresContactoApi','eliminarContacto'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));
	}

	public function actionProveedoresContactoApi($id){
			$proveedorresult= ProveedoresContacto::model()->findAll('id_proveedor = '.$id);
			$array=$this->convertModelToArray($proveedorresult);
			echo json_encode($array);
		}
		
public function convertModelToArray($models) {
        if (is_array($models))
            $arrayMode = TRUE;
        else {
            $models = array($models);
            $arrayMode = FALSE;
        }

        $result = array();
        foreach ($models as $model) {
            $attributes = $model->getAttributes();
            $relations = array();
            foreach ($model->relations() as $key => $related) {
                if ($model->hasRelated($key)) {
                	if ($model->$key) {
                    	$relations[$key] = $this->convertModelToArray($model->$key);	
                	}else{
                		$relations[$key] =[];
                	}
                }
            }

            $all = array_merge($attributes, $relations);

            if ($arrayMode)
                array_push($result, $all);
            else
                $result = $all;
        }

        return $result;
    }

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate($id)
	{
		$model=new ProveedoresContacto;
		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);
		if(isset($_POST['ProveedoresContacto']))
		{
			$model->attributes=$_POST['ProveedoresContacto'];
			$model->id_proveedor=$id;
			if($model->save())
				$this->redirect(array('/proveedores/view','id' => $model->id_proveedor));
		}
		$this->render('create',array(
			'model'=>$model,));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);
		
		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['ProveedoresContacto']))
		{
			$model->attributes=$_POST['ProveedoresContacto'];
			if($model->save())
				$this->redirect(array('/proveedores/view','id' => $model->id_proveedor));		
		}
		if($_SESSION['Agencia']->id_agencia == $model->idProveedor->id_agencia){
		$this->render('update',array(
			'model'=>$model,));
		}
		else{
			$this->redirect(array('/proveedores/listaproveedores'));
		}
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
		public function actionDelete($id)
			{	//$proveedorresult= Proveedores::model()->with()->find('id_proveedor = '.$id);
			$model=$this->loadModel($id);
			$id_proveedor=$model->id_proveedor;
			if($model=$this->loadModel($id)->delete())
				$this->redirect(array('/proveedores/view','id' => $id_proveedor));
		
		
			
		}

public function actionEliminarContacto($id)
	{
		$modelocontacto=ProveedoresContacto::model()->findByPk($id);
		$response = array();
		if ($modelocontacto) {


			if ($modelocontacto->delete()) {
				$response = array(
					"estatus" => 200,
					"mensaje" => "Se ha eliminado correctamente"
				);
			} else {
				$response = array(
					"estatus" => 404,
					"mensaje" => "No se ha podido elminar el contacto"
				);
			}
		} else {
			$response = array(
				"estatus" => 404,
				"mensaje" => "No se ha encontrado ningún contacto"
			);
		}
		echo CJSON::encode($response);
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
            $session=new CHttpSession;
            $session->open();		
            $criteria = new CDbCriteria();            

                $model=new ProveedoresContacto('search');
                $model->unsetAttributes();  // clear any default values

                if(isset($_GET['ProveedoresContacto']))
		{
                        $model->attributes=$_GET['ProveedoresContacto'];
			
			
                   	
                       if (!empty($model->id)) $criteria->addCondition("id = '".$model->id."'");
                     
                    	
                       if (!empty($model->id_proveedor)) $criteria->addCondition("id_proveedor = '".$model->id_proveedor."'");
                     
                    	
                       if (!empty($model->telefono_1)) $criteria->addCondition("telefono_1 = '".$model->telefono_1."'");
                     
                    	
                       if (!empty($model->telefono_2)) $criteria->addCondition("telefono_2 = '".$model->telefono_2."'");
                     
                    	
                       if (!empty($model->nombre)) $criteria->addCondition("nombre = '".$model->nombre."'");
                     
                    	
                       if (!empty($model->correo)) $criteria->addCondition("correo = '".$model->correo."'");
                     
                    	
                       if (!empty($model->descripcion)) $criteria->addCondition("descripcion = '".$model->descripcion."'");
                     
                    			
                    $session['ProveedoresContacto_records']=ProveedoresContacto::model()->findAll($criteria); 
		}
       

                $this->render('index',array(
			'model'=>$model,
		));

	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new ProveedoresContacto('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['ProveedoresContacto']))
			$model->attributes=$_GET['ProveedoresContacto'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer the ID of the model to be loaded
	 */
	public function loadModel($id)
	{
		$model=ProveedoresContacto::model()->with('idProveedor')->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param CModel the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='proveedores-contacto-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
        public function actionGenerateExcel()
	{
            $session=new CHttpSession;
            $session->open();		
            
             if(isset($session['ProveedoresContacto_records']))
               {
                $model=$session['ProveedoresContacto_records'];
               }
               else
                 $model = ProveedoresContacto::model()->findAll();

		
		Yii::app()->request->sendFile(date('YmdHis').'.xls',
			$this->renderPartial('excelReport', array(
				'model'=>$model
			), true)
		);
	}
        public function actionGeneratePdf() 
	{
           $session=new CHttpSession;
           $session->open();
		Yii::import('application.extensions.bootstrap.gii.*');
		require_once('bootstrap/tcpdf/tcpdf.php');
		require_once('bootstrap/tcpdf/config/lang/eng.php');

             if(isset($session['ProveedoresContacto_records']))
               {
                $model=$session['ProveedoresContacto_records'];
               }
               else
                 $model = ProveedoresContacto::model()->findAll();



		$html = $this->renderPartial('expenseGridtoReport', array(
			'model'=>$model
		), true);
		
		//die($html);
		
		$pdf = new TCPDF();
		$pdf->SetCreator(PDF_CREATOR);
		$pdf->SetAuthor(Yii::app()->name);
		$pdf->SetTitle('ProveedoresContacto Report');
		$pdf->SetSubject('ProveedoresContacto Report');
		//$pdf->SetKeywords('example, text, report');
		$pdf->SetHeaderData('', 0, "Report", '');
		$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, "Example Report by ".Yii::app()->name, "");
		$pdf->setHeaderFont(Array('helvetica', '', 8));
		$pdf->setFooterFont(Array('helvetica', '', 6));
		$pdf->SetMargins(15, 18, 15);
		$pdf->SetHeaderMargin(5);
		$pdf->SetFooterMargin(10);
		$pdf->SetAutoPageBreak(TRUE, 0);
		$pdf->SetFont('dejavusans', '', 7);
		$pdf->AddPage();
		$pdf->writeHTML($html, true, false, true, false, '');
		$pdf->LastPage();
		$pdf->Output("ProveedoresContacto_002.pdf", "I");
	}
}
