<?php

class ProveedoresController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout = '//layouts/column1';
	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
		);
	}
	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array(
				'allow',  // allow all users to perform 'index' and 'view' actions
				'actions' => array('index', 'view', 'delete', 'proveedoresApi', 'listaProveedores', 'eliminarProveedor', 'Proveedor'),
				'users' => array('@'),
			),
			array(
				'allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions' => array('create', 'update', 'delete', 'GeneratePdf', 'GenerateExcel', 'proveedoresApi', 'listaProveedores', 'eliminarProveedor', 'createApi', 'getProviders', 'pago', 'getServicesSalesAgency', 'savePayment'),
				'users' => array('@'),
			),
			array(
				'allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions' => array('admin'),
				'users' => array('admin'),
			),
			array(
				'deny',  // deny all users
				'users' => array('*'),
			),
		);
	}

	public function actionSavePayment()
	{
		$model = new PagosProveedores;
		$model->attributes = $_POST;
		$model->log = date("Y-m-d H:m:s");
		if ($_POST["id_cuenta"] == "" || $_POST["id_forma_pago"] == 1) {
			$model->id_cuenta = null;
		}
		if ($model->save()) {
			$pagos = PagosProveedores::model()->findAll('id_ventaservicio = ' . $model->id_ventaservicio);
			$servicio = VentasServicios::model()->findByPk($model->id_ventaservicio);
			$total = 0;
			foreach ($pagos as $key => $value) {
				$total += floatval($value->monto);
			}
			if ($total >= floatval($servicio->costo)) {
				$servicio->pagado_proveedor = 1;
				$servicio->save();
			}
			echo CJSON::encode($model);
		} else {
			echo CJSON::encode($model->getErrors());
		}
	}

	public function actionGetServicesSalesAgency()
	{
		$model = VentasServicios::model()->with("idVenta.idCliente", "idProveedor", "idTipoServicio", "pagosProveedores")->findAll("idVenta.id_agencia = " . $_SESSION['Agencia']->id_agencia . " AND t.estatus != 'cancelado' AND pagado_proveedor = 0");
		$general = Yii::app()->createController('general')[0];
		$response = $general->convertModelToArray($model);
		echo json_encode($response);
	}

	public function actionPago()
	{
		$this->render("pago");
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$model = $this->loadModel($id);
		if ($_SESSION['Agencia']->id_agencia == $model->idAgencia->id_agencia) {
			// code...
			$this->render('view', array(
				'model' => $this->loadModel($id),
			));
		} else {
			$this->render('listaproveedores');
		}
	}

	public function actionProveedor($idproveedor)
	{
		$proveedorresult = Proveedores::model()->with('idAgencia')->findAll('t.id_agencia = "' . $_SESSION['Agencia']->id_agencia . '" AND id_proveedor="' . $idproveedor . '" ');
		$array = $this->convertModelToArray($proveedorresult);
		echo json_encode($array);
	}

	public function actionProveedoresApi()
	{
		$proveedorresult = Proveedores::model()->with('idAgencia', 'proveedoresContactos', 'proveedoresDetallesBancos', 'tiposerviciosProveedores.idTipoServicio')->findAll('t.id_agencia = "' . $_SESSION['Agencia']->id_agencia . '" AND t.estatus = "A"');
		$array = $this->convertModelToArray($proveedorresult);
		echo json_encode($array);
	}

	public function convertModelToArray($models)
	{
		if (is_array($models))
			$arrayMode = TRUE;
		else {
			$models = array($models);
			$arrayMode = FALSE;
		}

		$result = array();

		foreach ($models as $model) {
			$attributes = $model->getAttributes();
			$relations = array();

			foreach ($model->relations() as $key => $related) {
				if ($model->hasRelated($key)) {
					if ($model->$key) {
						$relations[$key] = $this->convertModelToArray($model->$key);
					} else {
						$relations[$key] = [];
					}
				}
			}

			$all = array_merge($attributes, $relations);

			if ($arrayMode)
				array_push($result, $all);
			else
				$result = $all;
		}

		return $result;
	}

	public function actionGetProviders()
	{
		if ($_GET['tsp']) {
			$tsp = $_GET['tsp'];
			$model = Proveedores::model()->findAll("id_agencia = " . $_SESSION['Agencia']->id_agencia . " AND tipo_proveedor = '" . $tsp . "' AND t.estatus = 'A'");
		} else {
			$model = Proveedores::model()->findAll("id_agencia = " . $_SESSION['Agencia']->id_agencia . " AND t.estatus = 'A'");
		}
		$response = array();
		foreach ($model as $key => $value) {
			array_push($response, array(
				"id" => $value->id_proveedor,
				"text" => $value->nombre_comercial,
				"comision" => $value->comision,
			));
		}
		echo json_encode($response);
	}

	public function actionCreateApi()
	{
		$model = new Proveedores;
		$model->attributes = $_POST;
		$model->estatus = "A";
		if ($model->save()) {
			echo CJSON::encode($model);
		} else {
			echo CJSON::encode($model->getErrors());
		}
	}
	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model = new Proveedores;

		$proveedoresContacto = new ProveedoresContacto;
		$proveedoresDetallesBanco = new ProveedoresDetallesBanco;
		$model->id_agencia = $_SESSION['Agencia']->id_agencia;
		if (isset($_POST['Proveedores'])) {
			$model->attributes = $_POST['Proveedores'];
			$model->estatus = "A";

			try {
				//code...

				if ($model->save()) {
					if (count($_POST["ProveedoresTipoServicioProveedor"]) > 0) {
						foreach ($_POST["ProveedoresTipoServicioProveedor"] as $key => $tsp) {
							$provedor_tipo_servicio = new TiposerviciosProveedor;
							$provedor_tipo_servicio->id_tipo_servicio = $tsp;
							$provedor_tipo_servicio->id_proveedor = $model->id_proveedor;
							$provedor_tipo_servicio->save();
						}
					}

					if (!empty($_POST['ProveedoresContacto']['nombre'])) {
						$proveedoresContacto->attributes = $_POST['ProveedoresContacto'];
						$proveedoresContacto->id_proveedor = $model->id_proveedor;
						$proveedoresContacto->save();
						if (!empty($_POST['ProveedoresDetallesBanco'])) {
							$proveedoresDetallesBanco->attributes = $_POST['ProveedoresDetallesBanco'];
							$proveedoresDetallesBanco->id_proveedor = $model->id_proveedor;
							$proveedoresDetallesBanco->save();
						}
					}
					Yii::app()->user->setFlash('success', "El provedor ha sido creado exitosamente.");
					$this->redirect('index');
				}
			} catch (Exception $e) {
				echo $e->getMessage();
			}
		}
		$this->render('create', array(
			'model' => $model,
			'proveedoresContacto' => $proveedoresContacto,
			'proveedoresDetallesBanco' => $proveedoresDetallesBanco,

		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model = $this->loadModel($id);
		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);
		if (isset($_POST['Proveedores'])) {
			$model->attributes = $_POST['Proveedores'];
			if ($model->save()) {
				if (count($_POST["ProveedoresTipoServicioProveedor"]) > 0) {
					$aux_tps = TiposerviciosProveedor::model()->findAll('id_proveedor = ' . $id);
					foreach ($aux_tps as $key => $value) {
						$index = array_search($value->id_tipo_servicio, $_POST["ProveedoresTipoServicioProveedor"]);
						if (!$index && gettype($index) == "boolean") {
							$value->delete();
						} else {
							unset($_POST["ProveedoresTipoServicioProveedor"][$index]);
						}
					}

					foreach ($_POST["ProveedoresTipoServicioProveedor"] as $key => $tsp) {
						$provedor_tipo_servicio = new TiposerviciosProveedor;
						$provedor_tipo_servicio->id_tipo_servicio = $tsp;
						$provedor_tipo_servicio->id_proveedor = $model->id_proveedor;
						$provedor_tipo_servicio->save();
					}
				}

				$this->redirect(array('view', 'id' => $model->id_proveedor));
			}
		}
		if ($_SESSION['Agencia']->id_agencia == $model->idAgencia->id_agencia) {
			$this->render('update', array(
				'model' => $model,
			));
		} else {
			$this->render('listaproveedores');
		}
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		$model = $this->loadModel($id);
		$id_agencia = $model->id_agencia;
		if ($this->loadModel($id)->delete())
			$this->redirect(array('/proveedores/listaproveedores', 'id' => $id_agencia));
	}

	public function actionEliminarProveedor($id)
	{
		$modelo = Proveedores::model()->findByPk($id);
		$modelo->estatus = "D";
		$response = array();
		if ($modelo) {
			if ($modelo->save()) {
				$response = array(
					"estatus" => 200,
					"mensaje" => "Se ha eliminado correctamente"
				);
			} else {
				$response = array(
					"estatus" => 404,
					"mensaje" => "No se ha podido elminar el contacto"
				);
			}
		} else {
			$response = array(
				"estatus" => 404,
				"mensaje" => "No se ha encontrado ningún contacto"
			);
		}
		echo CJSON::encode($response);
	}

	/**
	 * Lists all models.
	 */
	public function actionIndexV1()
	{
		$session = new CHttpSession;
		$session->open();
		$criteria = new CDbCriteria();
		$model = new Proveedores('search');
		$model->unsetAttributes();  // clear any default values

		if (isset($_GET['Proveedores'])) {
			$model->attributes = $_GET['Proveedores'];

			if (!empty($model->id_proveedor)) $criteria->addCondition("id_proveedor = '" . $model->id_proveedor . "'");

			if (!empty($model->id_agencia)) $criteria->addCondition("id_agencia = '" . $model->id_agencia . "'");

			if (!empty($model->nombre_comercial)) $criteria->addCondition("nombre_comercial = '" . $model->nombre_comercial . "'");

			if (!empty($model->correo)) $criteria->addCondition("correo = '" . $model->correo . "'");

			if (!empty($model->direccion)) $criteria->addCondition("direccion = '" . $model->direccion . "'");

			if (!empty($model->cuidad)) $criteria->addCondition("cuidad = '" . $model->cuidad . "'");

			if (!empty($model->estado)) $criteria->addCondition("estado = '" . $model->estado . "'");

			if (!empty($model->codigo_postal)) $criteria->addCondition("codigo_postal = '" . $model->codigo_postal . "'");

			if (!empty($model->detalles)) $criteria->addCondition("detalles = '" . $model->detalles . "'");

			if (!empty($model->log)) $criteria->addCondition("log = '" . $model->log . "'");

			$session['Proveedores_records'] = Proveedores::model()->findAll($criteria);
		}

		$this->render('index', array(
			'model' => $model,
		));
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model = new Proveedores('search');
		$model->unsetAttributes();  // clear any default values
		if (isset($_GET['Proveedores']))
			$model->attributes = $_GET['Proveedores'];

		$this->render('admin', array(
			'model' => $model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer the ID of the model to be loaded
	 */
	public function loadModel($id)
	{
		$model = Proveedores::model()->with('idAgencia')->findByPk($id);
		//$model=Proveedores::model()->with('idAgencia','proveedoresContactos','proveedoresDetallesBancos')->findByPk('t.id_agencia = '.$id);
		if ($model === null)
			throw new CHttpException(404, 'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param CModel the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if (isset($_POST['ajax']) && $_POST['ajax'] === 'proveedores-form') {
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}

	public function actionGenerateExcel()
	{
		$session = new CHttpSession;
		$session->open();

		if (isset($session['Proveedores_records'])) {
			$model = $session['Proveedores_records'];
		} else
			$model = Proveedores::model()->findAll();

		Yii::app()->request->sendFile(
			date('YmdHis') . '.xls',
			$this->renderPartial('excelReport', array(
				'model' => $model
			), true)
		);
	}

	public function actionGeneratePdf()
	{
		$session = new CHttpSession;
		$session->open();
		Yii::import('application.extensions.bootstrap.gii.*');
		require_once('bootstrap/tcpdf/tcpdf.php');
		require_once('bootstrap/tcpdf/config/lang/eng.php');

		if (isset($session['Proveedores_records'])) {
			$model = $session['Proveedores_records'];
		} else
			$model = Proveedores::model()->findAll();

		$html = $this->renderPartial('expenseGridtoReport', array(
			'model' => $model
		), true);

		//die($html);

		$pdf = new TCPDF();
		$pdf->SetCreator(PDF_CREATOR);
		$pdf->SetAuthor(Yii::app()->name);
		$pdf->SetTitle('Proveedores Report');
		$pdf->SetSubject('Proveedores Report');
		//$pdf->SetKeywords('example, text, report');
		$pdf->SetHeaderData('', 0, "Report", '');
		$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, "Example Report by " . Yii::app()->name, "");
		$pdf->setHeaderFont(array('helvetica', '', 8));
		$pdf->setFooterFont(array('helvetica', '', 6));
		$pdf->SetMargins(15, 18, 15);
		$pdf->SetHeaderMargin(5);
		$pdf->SetFooterMargin(10);
		$pdf->SetAutoPageBreak(TRUE, 0);
		$pdf->SetFont('dejavusans', '', 7);
		$pdf->AddPage();
		$pdf->writeHTML($html, true, false, true, false, '');
		$pdf->LastPage();
		$pdf->Output("Proveedores_002.pdf", "I");
	}

	public function actionIndex()
	{
		$this->render('listaproveedores');
	}
}
