<?php

class ProveedoresDetallesBancoController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column1';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view','delete','ProveedoresBancoApi','eliminarBancario'),
				'users'=>array('@'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update','delete','GeneratePdf','GenerateExcel','ProveedoresBancoApi','eliminarBancario'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete','ProveedoresBancoApi','eliminarBancario'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));
	}

		public function actionProveedoresBancoApi($id){
			$proveedorresult= ProveedoresDetallesBanco::model()->findAll('id_proveedor = '.$id);
			$array=$this->convertModelToArray($proveedorresult);
			echo json_encode($array);
		}
		
public function convertModelToArray($models) {
        if (is_array($models))
            $arrayMode = TRUE;
        else {
            $models = array($models);
            $arrayMode = FALSE;
        }

        $result = array();
        foreach ($models as $model) {
            $attributes = $model->getAttributes();
            $relations = array();
            foreach ($model->relations() as $key => $related) {
                if ($model->hasRelated($key)) {
                	if ($model->$key) {
                    	$relations[$key] = $this->convertModelToArray($model->$key);	
                	}else{
                		$relations[$key] =[];
                	}
                }
            }

            $all = array_merge($attributes, $relations);

            if ($arrayMode)
                array_push($result, $all);
            else
                $result = $all;
        }

        return $result;
    }

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate($id)
	{
		$model=new ProveedoresDetallesBanco;
		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['ProveedoresDetallesBanco']))
		{
			$model->attributes=$_POST['ProveedoresDetallesBanco'];
			$model->id_proveedor=$id;
			if($model->save())
				$this->redirect(array('/proveedores/view','id' => $model->id_proveedor));
		}

		$this->render('create',array(
			'model'=>$model,
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{		
		$model=$this->loadModel($id);	
		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);
		if(isset($_POST['ProveedoresDetallesBanco']))
		{
			$model->attributes=$_POST['ProveedoresDetallesBanco'];
			if($model->save())
				$this->redirect(array('/proveedores/view','id' => $model->id_proveedor));
		}
		if($_SESSION['Agencia']->id_agencia == $model->idProveedor->id_agencia){		
		$this->render('update',array(
			'model'=>$model,
		));		
		}
		else{
			$this->redirect(array('/proveedores/listaproveedores'));
		} 	
		
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{$model = $this->loadModel($id);
		$id_proveedor= $model->id_proveedor;
		if($this->loadModel($id)->delete())
			$this->redirect(array('/proveedores/view','id' => $id_proveedor));

	}

public function actionEliminarBancario($id)
	{
		$modelobancario=ProveedoresDetallesBanco::model()->findByPk($id);
		$response = array();
		if ($modelobancario) {


			if ($modelobancario->delete()) {
				$response = array(
					"estatus" => 200,
					"mensaje" => "Se ha eliminado correctamente"
				);
			} else {
				$response = array(
					"estatus" => 404,
					"mensaje" => "No se ha podido elminar el contacto"
				);
			}
		} else {
			$response = array(
				"estatus" => 404,
				"mensaje" => "No se ha encontrado ningún contacto"
			);
		}
		echo CJSON::encode($response);
	}	

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
            $session=new CHttpSession;
            $session->open();		
            $criteria = new CDbCriteria();            

                $model=new ProveedoresDetallesBanco('search');
                $model->unsetAttributes();  // clear any default values

                if(isset($_GET['ProveedoresDetallesBanco']))
		{
                        $model->attributes=$_GET['ProveedoresDetallesBanco'];
			
			
                   	
                       if (!empty($model->id)) $criteria->addCondition("id = '".$model->id."'");
                     
                    	
                       if (!empty($model->id_proveedor)) $criteria->addCondition("id_proveedor = '".$model->id_proveedor."'");
                     
                    	
                       if (!empty($model->alias)) $criteria->addCondition("alias = '".$model->alias."'");
                     
                    	
                       if (!empty($model->banco)) $criteria->addCondition("banco = '".$model->banco."'");
                     
                    	
                       if (!empty($model->sucursal)) $criteria->addCondition("sucursal = '".$model->sucursal."'");
                     
                    	
                       if (!empty($model->cuenta)) $criteria->addCondition("cuenta = '".$model->cuenta."'");
                     
                    	
                       if (!empty($model->clabe)) $criteria->addCondition("clabe = '".$model->clabe."'");
                     
                    			
                    $session['ProveedoresDetallesBanco_records']=ProveedoresDetallesBanco::model()->findAll($criteria); 
		}
       

                $this->render('index',array(
			'model'=>$model,
		));

	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new ProveedoresDetallesBanco('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['ProveedoresDetallesBanco']))
			$model->attributes=$_GET['ProveedoresDetallesBanco'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer the ID of the model to be loaded
	 */
	public function loadModel($id)
	{
		$model=ProveedoresDetallesBanco::model()->with('idProveedor')->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param CModel the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='proveedores-detalles-banco-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
        public function actionGenerateExcel()
	{
            $session=new CHttpSession;
            $session->open();		
            
             if(isset($session['ProveedoresDetallesBanco_records']))
               {
                $model=$session['ProveedoresDetallesBanco_records'];
               }
               else
                 $model = ProveedoresDetallesBanco::model()->findAll();

		
		Yii::app()->request->sendFile(date('YmdHis').'.xls',
			$this->renderPartial('excelReport', array(
				'model'=>$model
			), true)
		);
	}
        public function actionGeneratePdf() 
	{
           $session=new CHttpSession;
           $session->open();
		Yii::import('application.extensions.bootstrap.gii.*');
		require_once('bootstrap/tcpdf/tcpdf.php');
		require_once('bootstrap/tcpdf/config/lang/eng.php');

             if(isset($session['ProveedoresDetallesBanco_records']))
               {
                $model=$session['ProveedoresDetallesBanco_records'];
               }
               else
                 $model = ProveedoresDetallesBanco::model()->findAll();



		$html = $this->renderPartial('expenseGridtoReport', array(
			'model'=>$model
		), true);
		
		//die($html);
		
		$pdf = new TCPDF();
		$pdf->SetCreator(PDF_CREATOR);
		$pdf->SetAuthor(Yii::app()->name);
		$pdf->SetTitle('ProveedoresDetallesBanco Report');
		$pdf->SetSubject('ProveedoresDetallesBanco Report');
		//$pdf->SetKeywords('example, text, report');
		$pdf->SetHeaderData('', 0, "Report", '');
		$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, "Example Report by ".Yii::app()->name, "");
		$pdf->setHeaderFont(Array('helvetica', '', 8));
		$pdf->setFooterFont(Array('helvetica', '', 6));
		$pdf->SetMargins(15, 18, 15);
		$pdf->SetHeaderMargin(5);
		$pdf->SetFooterMargin(10);
		$pdf->SetAutoPageBreak(TRUE, 0);
		$pdf->SetFont('dejavusans', '', 7);
		$pdf->AddPage();
		$pdf->writeHTML($html, true, false, true, false, '');
		$pdf->LastPage();
		$pdf->Output("ProveedoresDetallesBanco_002.pdf", "I");
	}
}
