<?php
class ReportesController extends Controller {
	/**
	 * @return array action filters
	 */
	public function filters() {
		return array(
			'accessControl', // perform access control for CRUD operations
		);
	}

	public function accessRules() {
		return array(
			array(
				'allow',  // allow all users to perform 'index' and 'view' actions
				'actions' => array('cuentasPorPagar', 'index', 'ventas', 'pagos', 'cuentasPorCobrar', 'obtenerServiciosDeVentas', 'ObtenerServicios', 'pagosProveedores', 'getPagosProveedores','pagosBoda', 'infoContratosDeBoda', 'ventasBodasGrupos','infoContrato','ventasproximas','ventasProxFechas'),
				'users' => array('*'),
			),

			array(
				'deny',  // deny all users
				'users' => array('*'),
			),
		);
	}
	
	public function actionIndex() {
		$this->render('index');
	}

	public function actionVentas() {
		$this->render('ventas');
	}

	public function actionCuentasPorCobrar() {
		$this->render('cuentasporcobrar');
	}

	public function actionObtenerServicios() {
		$criteria = new CDbCriteria;
		$servicios = TipoServicios::model()->findAll($criteria);
		echo CJSON::encode($servicios);
	}

	public function actionObtenerServiciosDeVentas() {
		$criteria = new CDbCriteria;
		$criteria->with = array("idVentaservicio.idVenta", "idPago.idFormaPago");
		$criteria->addCondition("idVenta.id_agencia = '". $_SESSION['Agencia']->id_agencia ."'");

		if(isset($_GET)) {
			if($_GET["start"] == $_GET["end"]) {
				$criteria->addCondition("idPago.log = ". $_GET["start"]);
			} else {
				$criteria->addCondition("idPago.log BETWEEN '". $_GET["start"] ."' AND '". $_GET["end"] ."'");
			}
		}

		$pagos = PagosDetalle::model()->findAll($criteria);

		$array_final = array();
		foreach ($pagos as $index => $pago) {
			$model_pagos = Pagos::model()->findByPk($pago->id_pago);
			array_push($array_final, array(
				"id_pago" => $pago->id_pago,
				"id_venta" => $pago->idVentaservicio->idVenta->id_venta,
				"monto" => $pago->monto,
				"folio" => $pago->idVentaservicio->idVenta->folio,
				"forma_pago" => $pago->idPago->idFormaPago->descripcion,
				"comision" => $pago->idPago->idFormaPago->comision,
				"tipo_monto" => $pago->idPago->idFormaPago->tipo_monto,
				"codigo_cfdi" => $pago->idPago->idFormaPago->codigo_cfdi,
				"fecha" => $pago->idVentaservicio->idVenta->fecha,
				"fecha_pago" => date("Y-m-d", strtotime($model_pagos->log)),
				"pasajero_titular" => $pago->idVentaservicio->idVenta->pasajero_titular,
				"descripcion" => $pago->idVentaservicio->idVenta->descripcion,
				"observaciones" => $pago->idVentaservicio->idVenta->observaciones,
				"moneda" => $pago->idVentaservicio->idVenta->moneda,
				"usuario" => $pago->idPago->idUsuario->username,
				"estatus" => $pago->idVentaservicio->idVenta->estatus,
			));
		}
		echo CJSON::encode($array_final);
	}

	public function actionCuentasPorPagar() {
		$this->render('cuentasporpagar');
	}
	
	public function actionPagos() {
		$this->render('pagos');
	}

	public function actionPagosProveedores() {
		$this->render("pagosProveedores");
	}

	public function actionGetPagosProveedores() {
		$model = PagosProveedores::model()->with("idFormaPago", "idVentaservicio.idVenta", "idCuenta")->findAll("idVenta.id_agencia = ". $_SESSION["Agencia"]->id_agencia);
		$general = Yii::app()->createController('general')[0];
		$response = $general->convertModelToArray($model);
		echo json_encode($response);
	}

	public function actionPagosBoda() {
		$this->render('pagosBodas');
	}

	public function actionInfoContratosDeBoda($id_venta = null) {
		$criteria = new CDbCriteria;
		$criteria->addCondition("t.id_agencia = ". $_SESSION['Agencia']->id_agencia);
		$criteria->addCondition("t.estatus != 'cancelado'");
		if ($id_venta==null) {
			$id_venta=0;
		}
		$criteria->addCondition("t.pertenece_a=".$id_venta);

		$model = Ventas::model()->with("ventasServicioses", "ventasServicioses.pagosDetalles")->findAll($criteria);

		$general = Yii::app()->createController('general')[0];
		$response = $general->convertModelToArray($model);
		echo json_encode($response);
	}

	public function actionVentasproximas() {
		$this->render('ventasproximas');
	}
	public function actionVentasProxFechas(){
		if(isset($_GET)) {
			if($_GET["start"] == $_GET["end"]) {
				$fechaFiltro=' AND vs.inicio_servicio="'.$_GET["start"].'"';
			} else {
				$fechaFiltro=' AND vs.inicio_servicio BETWEEN "'.$_GET["start"].'" AND "'.$_GET["end"].'"';
			}
		}
		$filtroCompleto=' AND EXISTS(SELECT id_venta FROM tbl_ventas_servicios  AS vs WHERE vs.id_venta=t.id_venta '. $fechaFiltro.')';

		$ventasresult = Ventas::model()->with('idAgencia', 'ventasServicioses','idCliente')->findAll('t.id_agencia = "' . $_SESSION['Agencia']->id_agencia . '" AND t.estatus NOT LIKE "cancelado"  '.$filtroCompleto);
		$general = Yii::app()->createController('general')[0];
		$array = $general->convertModelToArray($ventasresult);
		$sumaservicios = 0;
		foreach ($array as $index1 => $ventas) {		
			$sumaserviciosporventa = 0;
			$costototalporventa = 0;
			foreach ($ventas['ventasServicioses'] as $index => $servicio) {
				// suma de las tarifas de todas las ventas
				$sumaservicios += $servicio['tarifa_publica']; //todos los servicios de todas las ventas
				$costototal += $servicio['costo'];
				$sumaserviciosporventa += $servicio['tarifa_publica']; //unaventa todos servicio
				$costototalporventa += $servicio['costo'];
				$array[$index1]['sumatotalporventa'] = $sumaserviciosporventa;
				$array[$index1]['costototalporventa'] = $costototalporventa;
			}
			$array[$index1]['sumatotal'] = $sumaservicios;
			$array[$index1]['costototal'] = $costototal;
			
		}
		echo json_encode($array);
	}
	

	public function actionInfoContrato($id_venta){ 
		header('Content-Type: application/json; charset=utf-8');
		$criteria = new CDbCriteria;
		$criteria->addCondition("t.id_agencia ='". $_SESSION['Agencia']->id_agencia ."'" ."AND ventasServicioses.id_tipo_servicio IN (3,4) AND t.id_venta=".$id_venta);
		$model = Ventas::model()->with("ventasServicioses")->findAll($criteria);

		
		$general = Yii::app()->createController('general')[0];
		$response = $general->convertModelToArray($model);
		echo json_encode($response);
		
	}

	public function actionVentasBodasGrupos() {
		$criteria = new CDbCriteria;
		$criteria->condition = "idVenta.id_agencia = ". $_SESSION['Agencia']->id_agencia ." AND id_tipo_servicio IN (3,4)";
		$criteria->order = "id_ventaservicio DESC";
		$model = VentasServicios::model()->with("idVenta")->findAll($criteria);
		
		$response = array();
		foreach ($model as $key => $item) {
			$find = Grupos::model()->find("id_ventaservicio = ". $item->id_ventaservicio);
			array_push($response, array(
				"id_venta" => $item->idVenta->id_venta,
				"folio" => $item->idVenta->folio ." - ". $find->titulo_evento
			));
		}
		echo json_encode($response);
	}
}