<?php
class SiteController extends Controller {
	/**
	 * Declares the behaviors.
	 * @return array the behaviors
	 */
	public function behaviors() {
		return array(
			'seo' => 'ext.seo.components.SeoControllerBehavior',
		);
	}

	/**
	 * Declares class-based actions.
	 * @return array the actions
	 */
	public function actions() {
		return array(
			'captcha' => array(
				'class' => 'CCaptchaAction',
				'backColor' => 0xFFFFFF,
			),
		);
	}

	/**
	 * @return array action filters
	 */
	public function filters() {
		return array(
			'accessControl', // perform access control for CRUD operations
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules() {
		return array(
			array(
				'allow',  // allow all users to perform 'index' and 'view' actions
				'actions' => array('index', 'pruebasChart', 'graficaVentas', 'ObtenerFechasPorVentas', 'ObtenerServiciosProximasAVencer', 'changeAgency', 'searchHotel', 'echoSession'),
				'users' => array('@'),
			),
			array(
				'deny',  // deny all users
				'users' => array('*'),
			),
		);
	}

	public function actionEchoSession() {
		echo CJSON::encode($_SESSION);
	}

	public function actionSearchHotel() {
		header('Content-Type: application/json');
		$curl = curl_init();

		curl_setopt_array($curl, array(
			CURLOPT_URL => 'https://rutamayatravel.com/sur4/busqueda/buscarHotelesERP?search='. urlencode($_GET["q"]),
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => '',
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => 'GET',
		));

		$response = curl_exec($curl);

		curl_close($curl);
		echo $response;
	}

	public function actionChangeAgency() {
		$model = Agencia::model()->findByPk($_POST["id_agencia"]);
		$_SESSION['Agencia'] = $model;
		echo "success";
	}

	public function actionPruebasChart() {
		$this->render('pruebaCharts');
	}

	public function actionObtenerFechasPorVentas() {
		$sql = 'SELECT EXTRACT(year FROM V.fecha) AS "year" FROM tbl_ventas V 
		INNER JOIN tbl_ventas_servicios VS ON VS.id_venta=V.id_venta 
		WHERE V.id_agencia = "' . $_SESSION['Agencia']->id_agencia . '"
		GROUP BY EXTRACT(year FROM V.fecha)';
		$response = Yii::app()->db->createCommand($sql)->queryAll();
		$exist_y = false;
		foreach($response as $y){
			if(intval($y["year"]) == intval(date('Y')))
				$exist_y = true;
		}
		if(!$exist_y)
			array_push($response, ['year'=>date('Y')]);
		echo CJSON::encode($response);
	}

	public function actionObtenerServiciosProximasAVencer() {
		//$additional_sql = $_SESSION["Usuario"]->rol == "Agente" ? " AND V.id_usuario = ". Yii::app()->user->id : "";
		$query = 'SELECT VS.*, V.* FROM tbl_ventas V INNER JOIN tbl_ventas_servicios as VS ON VS.id_venta = V.id_venta WHERE V.id_agencia = "'. $_SESSION['Agencia']->id_agencia .'" AND (DATEDIFF(VS.fecha_limite, curdate()) < 30 AND DATEDIFF(VS.fecha_limite, curdate()) > 0) AND VS.estatus="venta" '. $additional_sql .' ORDER BY VS.fecha_limite asc';
		$response = Yii::app()->db->createCommand($query)->queryAll();
		echo CJSON::encode($response);
	}

	public function actionGraficaVentas() {
		if (isset($_GET['year']) && !empty($_GET['year']) && !is_null($_GET['year'])) {
			$year = $_GET['year'];
		} else {
			$year = date('Y');
		}
		// $query = "SET lc_time_names = 'es_ES';";
		$query = "SELECT EXTRACT(year FROM ven.fecha) AS year,MONTHNAME(ven.fecha) AS x, (SUM(vs.tarifa_publica) + SUM(vs.fee)) AS y, ven.fecha as fecha FROM tbl_ventas ven
		INNER JOIN tbl_ventas_servicios vs ON vs.id_venta=ven.id_venta
		WHERE EXTRACT(year FROM ven.fecha) = $year AND ven.id_agencia = '" . $_SESSION['Agencia']->id_agencia . "' AND ven.estatus NOT LIKE 'cancelado'
		GROUP BY EXTRACT(month FROM ven.fecha); ";
		$response = Yii::app()->db->createCommand($query)->queryAll();
		echo CJSON::encode($response);
	}
	/**
	 * This is the default 'index' action that is invoked
	 * when an action is not explicitly requested by users.
	 */
	public function actionIndex() {
		$this->render('index');
	}

	public function actionMaintenance() {
		$this->layout = '/layouts/maintenance';
		$this->render('maintenance');
	}

	/**
	 * This is the action to handle external exceptions.
	 */

	public function actionError() {
		if ($error = Yii::app()->errorHandler->error) {
			if (Yii::app()->request->isAjaxRequest)
				echo $error['message'];
			else
				$this->render('error', $error);
		}
	}

	public function getTabularFormTabs($form, $model) {
		$tabs = array();
		$count = 0;

		foreach (array('en' => 'English', 'fi' => 'Finnish', 'sv' => 'Swedish') as $locale => $language) {
			$tabs[] = array(
				'active' => $count++ === 0,
				'label' => $language,
				'content' => $this->renderPartial('_tabular', array(
					'form' => $form,
					'model' => $model,
					'locale' => $locale,
					'language' => $language,
				), true),
			);
		}

		return $tabs;
	}
}