<?php

class SolicitudesController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column1';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index', 'view', 'indexV2'),
				'users'=>array('@'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create', 'update', 'delete', 'getRequests', 'getRequestInfo'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin', 'delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id) {
		$this->render('view');
	}

	public function actionGetRequestInfo($id) {
		$model = Solicitudes::model()->findByPk($id);
		$general = Yii::app()->createController('general')[0];
		$response = $general->convertModelToArray($model);
		echo json_encode($response);
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate() {
		$model = new Solicitudes;
		$model->attributes = $_POST;
		$model->id_usuario = $_POST["id_usuario"] == 0 ? Yii::app()->user->id : $_POST["id_usuario"];
		$model->id_agencia = $_SESSION["Agencia"]->id_agencia;
		$model->log = date("Y-m-d H:m:s");

		if($model->save()) {
			$response = Solicitudes::model()->with("idCliente", "idUsuario.profiles")->findByPk($model->id_solicitud);
			$general = Yii::app()->createController('general')[0];
			echo json_encode($general->convertModelToArray($response));
		} else {
			echo CJSON::encode($model->getErrors());
		}
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate() {
		$model = Solicitudes::model()->findByPk($_POST["id_solicitud"]);
		$model->attributes = $_POST;
		if($model->save()) {
			$response = Solicitudes::model()->with("idCliente", "idUsuario.profiles")->findByPk($model->id_solicitud);
			$general = Yii::app()->createController('general')[0];
			echo json_encode($general->convertModelToArray($response));
		} else {
			echo CJSON::encode($model->getErrors());
		}
	}

	public function actionDelete() {
		$request = Solicitudes::model()->findByPk($_POST["id"]);
		if($_POST["with_prices"] == 1) {
			$prices = Cotizaciones::model()->findAll("id_solicitud = ". $_POST["id"]);
			foreach ($prices as $i => $price) {
				$details = CotizacionDetalles::model()->findAll("id_cotizacion = ". $price->id_cotizacion);
				foreach ($details as $j => $detail) {
					if($_SESSION["Usuario"]->rol == "Propietario") {
						$detail->delete();
					}
				}

				if($_SESSION["Usuario"]->rol == "Propietario") {
					$price->delete();
				} else {
					$price->estatus = "cancelada";
					$price->save();
				}
			}

			if($_SESSION["Usuario"]->rol == "Propietario") {
				if($request->delete()) {
					echo json_encode(array(
						"success" => true
					));
				} else {
					echo json_encode(array(
						"success" => false
					));
				}
			} else {
				$request->estatus = "Cancelada";
				if($request->save()) {
					echo json_encode(array(
						"success" => true
					));
				} else {
					echo json_encode(array(
						"success" => false
					));
				}
			}
		} else {
			if($_SESSION["Usuario"]->rol == "Propietario") {
				if($request->delete()) {
					echo json_encode(array(
						"success" => true
					));
				} else {
					echo json_encode(array(
						"success" => false
					));
				}
			} else {
				$request->estatus = "Cancelada";
				if($request->save()) {
					echo json_encode(array(
						"success" => true
					));
				} else {
					echo json_encode(array(
						"success" => false
					));
				}
			}
		}
	}

	/**
	 * Lists all models.
	 */
	public function actionIndexV1() {
		$this->render('indexV1');
	}

	public function actionIndex() {
		$this->render('index');
	}

	public function actionGetRequests() {
		$model = Solicitudes::model()->with("idUsuario.profiles", "idCliente", "cotizaciones")->findAll("t.id_agencia = ". $_SESSION['Agencia']->id_agencia);
		$general = Yii::app()->createController('general')[0];
		$response = $general->convertModelToArray($model);
		echo json_encode($response);
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer the ID of the model to be loaded
	 */
	public function loadModel($id)
	{
		$model=Solicitudes::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param CModel the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='solicitudes-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
}
