<?php

class TerminosController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column1';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view'),
				'users'=>array('@'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update','GeneratePdf','GenerateExcel','getToS','saveToS'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}
	
	public function actionGetToS() {
		$model = Terminos::model()->find("id_agencia = ". $_SESSION['Agencia']->id_agencia);
		if(is_null($model)) {
			echo json_encode(array());
		} else {
			$general = Yii::app()->createController('general')[0];
			$response = $general->convertModelToArray($model);
			echo json_encode($response);
		}
	}

	public function actionSaveToS() {
		$model = Terminos::model()->find("id_agencia = ". $_SESSION['Agencia']->id_agencia);
		if(!isset($model->id)) {
			$model = new Terminos;
		}

		$model->attributes = $_POST;
		$model->id_agencia = $_SESSION['Agencia']->id_agencia;
		if($model->terminos_grupos == "") $model->terminos_grupos = NULL;
		if($model->save()) {
			echo CJSON::encode($model);
		} else {
			echo CJSON::encode($model->getErrors());
		}
	}
}