<?php

class UsuariosAgenciasController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column1';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
		);
	}
		public function actions()
	{
		return array(
			'captcha'=>array(
				'class'=>'CCaptchaAction',
				'backColor'=>0xFFFFFF,
			),
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view','delete','eliminarUsuario','usuariosapi','usuarioSesionApi','usuarioSesionApiV2'),
				'users'=>array('@'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update','delete','GeneratePdf','GenerateExcel','eliminarUsuario'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete','create','eliminarUsuario','usuariosapi'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	public function actionUsuariosApi(){
		$usuarios = UsuariosAgencias::model()->with(array('idUsuario', 'idUsuario.profiles'))->findAll('t.id_agencia='.$_SESSION['Agencia']->id_agencia);
		$general = Yii::app()->createController('general')[0];
		$usuario = $general->convertModelToArray($usuarios);
		echo json_encode($usuario);
	}

	public function actionusuarioSesionApi(){
		$usuariosesion = UsuariosAgencias::model()->with(array('idUsuario', 'idUsuario.profiles'))->findAll('t.id_agencia= "'. $_SESSION['Agencia']->id_agencia .'" AND t.id_usuario= "'. $_SESSION['Usuario']->id_usuario .'"');	
		$general = Yii::app()->createController('general')[0];
		$usersesion = $general->convertModelToArray($usuariosesion);
		echo json_encode($usersesion);				
	}
				
	public function actionusuarioSesionApiV2() {
		$usuariosesion = UsuariosAgencias::model()->with(
			//'idUsuario'=>array('select'=>'username')
			//'idUsuario.profiles' => array('select'=> ['firstname','lastname'])
		)->findAll((array(
			'select'=> ['telefono','direccion','fecha_nacimiento','foto','rol',],
			'condition' =>'t.id_agencia= "'.$_SESSION['Agencia']->id_agencia.'" AND t.id_usuario= "'.$_SESSION['Usuario']->id_usuario.'" '
		)));	
		$usersesion = $this->convertModelToArray($usuariosesion);
		echo json_encode($usersesion);				
	}
	
	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id) {
		$usuarios = UsuariosAgencias::model()->with(array('idUsuario', 'idUsuario.profiles'))->findAll('t.id_agencia = "'.$_SESSION['Agencia']->id_agencia.'" AND t.id_usuario = "'.$id.'" ');	
		if ($usuarios) {
			$this->render('view', array(
				'model'=>$this->loadModel($id),
			));
		} else {
			$this->redirect(array('/agencia/usuarios'));
		}
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate() {
		$datosusuario = new UsuariosAgencias;
		$profile = new Profile;
		$model = new RegistrationUserAgency;
		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);
		//echo json_encode($_POST);
		if(isset($_POST['RegistrationUserAgency'])) {
			$model->attributes = $_POST['RegistrationUserAgency'];
			$profile->attributes = ((isset($_POST['Profile']) ? $_POST['Profile'] : array()));
			if($model->validate() && $profile->validate()) {
				$model->activkey = UserModule::encrypting(microtime().$model->password);
				$model->password = UserModule::encrypting($model->password);

				$model->superuser = 0;
				$model->status = User::STATUS_ACTIVE;	
				$model->username = $_POST['RegistrationUserAgency']['username'];
				$model->email = $_POST['RegistrationUserAgency']['email'];				
				if ($model->save()) {
					$profile->user_id = $model->id;
					$profile->save();
					$datosusuario->attributes = $_POST['UsuariosAgencias'];
					$target_dir = "images/usuarios/";
					$target_file = $target_dir . date("is").$_FILES['UsuariosAgencias']['name']['foto'];
					if($_FILES['UsuariosAgencias']['tmp_name']['foto'] != ""){
						if (move_uploaded_file($_FILES['UsuariosAgencias']['tmp_name']['foto'], $target_file)){						
							$datosusuario->foto = date("is") . $_FILES['UsuariosAgencias']['name']['foto'];
						}
					}
					$datosusuario->id_agencia = $_SESSION['Agencia']->id_agencia;
					$datosusuario->id_usuario = $model->id;
					$datosusuario->status_laboral = $_POST['UsuariosAgencias']['status_laboral'];
					$datosusuario->rol = $_POST['UsuariosAgencias']['rol'];
					$datosusuario->save();
					$this->redirect(array('/agencia/usuarios'));
				} else {
					CJSON::encode($model->getErrors());
				}
			}	
		}

		$this->render('create',array(
			'model' => $model,
			'datosusuario' => $datosusuario,
			'profile' => $profile
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id) {	
		$datosusuario = $this->loadModel($id);
		$profile = $this->loadModelProfile($id);
		$model = $this->loadModelUser($id);		
		$fotoUsuario = $datosusuario->foto; 
		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);		
		if(isset($_POST['UsuariosAgencias'])) {
			$datosusuario->attributes = $_POST['UsuariosAgencias'];
			$datosusuario->status_laboral = $_POST['UsuariosAgencias']['status_laboral'];
			$target_dir = "images/usuarios/";
			$target_file = $target_dir . date("is") . $_FILES['UsuariosAgencias']['name']['foto'];
			if($_FILES['UsuariosAgencias']['tmp_name']['foto'] != ""){
				if (move_uploaded_file($_FILES['UsuariosAgencias']['tmp_name']['foto'], $target_file)){		
					$datosusuario->foto = date("is") . $_FILES['UsuariosAgencias']['name']['foto'];				
				}
			}				
			$profile->attributes = $_POST['Profile'];
			$model->attributes = $_POST['Users'];

			if($_POST["Users"]["password"] != "") {
				$model->password = md5($_POST["Users"]["password"]);
			}
				
			if($datosusuario->save()){
				if ($fotoUsuario != "" && $_FILES['UsuariosAgencias']['tmp_name']['foto'] != "") {
					unlink($target_dir . $fotoUsuario);
				}
				$profile->save();
				$model->save();
				$this->redirect(array('/agencia/usuarios'));
				// $this->redirect(array('view','id'=>$datosusuario->id_usuario));
			}
		}

		$model->password = "";
		$this->render('update',array(
			'model' => $model,
			'datosusuario' => $datosusuario,
			'profile' => $profile
		));
	}
	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id) {
		$modeluser = $this->loadModelUser($id);		
		$model = $this->loadModel($id);
		$id_agencia = $model->id_agencia;		
		if($modeluser->delete())				
			$this->redirect(array('/agencia/usuarios','id' => $id_agencia));
	}

	public function actionEliminarUsuario($id) {
		$modelo=UsuariosAgencias::model()->findByPk($id);
		$response = array();
		if ($modelo) {
			if ($modelo->delete()) {
				$response = array(
					"estatus" => 200,
					"mensaje" => "Se ha eliminado correctamente"
				);
			} else {
				$response = array(
					"estatus" => 404,
					"mensaje" => "No se ha podido elminar el contacto"
				);
			}
		} else {
			$response = array(
				"estatus" => 404,
				"mensaje" => "No se ha encontrado ningún contacto"
			);
		}
		echo CJSON::encode($response);
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex() {
		$session=new CHttpSession;
		$session->open();		
		$criteria = new CDbCriteria();            

		$model=new UsuariosAgencias('search');
		$model->unsetAttributes();  // clear any default values

        if(isset($_GET['UsuariosAgencias'])) {
            $model->attributes=$_GET['UsuariosAgencias'];
                   	
            if (!empty($model->id_usuario)) $criteria->addCondition("id_usuario = '".$model->id_usuario."'");
                    	
            if (!empty($model->id_agencia)) $criteria->addCondition("id_agencia = '".$model->id_agencia."'");
                    	
            if (!empty($model->fecha_nacimiento)) $criteria->addCondition("fecha_nacimiento = '".$model->fecha_nacimiento."'");
                    	
            if (!empty($model->telefono)) $criteria->addCondition("telefono = '".$model->telefono."'");
                    	
            if (!empty($model->direccion)) $criteria->addCondition("direccion = '".$model->direccion."'");
                    	
            if (!empty($model->foto)) $criteria->addCondition("foto = '".$model->foto."'");
                    	
            if (!empty($model->rol)) $criteria->addCondition("rol = '".$model->rol."'");
                    			
        	$session['UsuariosAgencias_records']=UsuariosAgencias::model()->findAll($criteria); 
		}

        $this->render('index',array(
			'model'=>$model,
		));

	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin() {
		$model=new UsuariosAgencias('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['UsuariosAgencias']))
			$model->attributes=$_GET['UsuariosAgencias'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}
	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer the ID of the model to be loaded
	 */
	public function loadModelUser($id){
			$model=Users::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');		
		return $model;
	}

	public function loadModelProfile($id)
	{
		$model=Profile::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');			
		return $model;
	}
	
	public function loadRegistrationUser($id) {
		$model=RegistrationUser::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');			
		return $model;
	}

	public function loadModel($id) {
		$model=UsuariosAgencias::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');			
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param CModel the model to be validated
	 */
	protected function performAjaxValidation($model) {
		if(isset($_POST['ajax']) && $_POST['ajax']==='usuarios-agencias-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
    
	public function actionGenerateExcel() {
        $session=new CHttpSession;
        $session->open();		
            
        if(isset($session['UsuariosAgencias_records'])) {
        	$model=$session['UsuariosAgencias_records'];
        }
        else
            $model = UsuariosAgencias::model()->findAll();
		
		Yii::app()->request->sendFile(date('YmdHis').'.xls',
			$this->renderPartial('excelReport', array(
				'model'=>$model
			), true)
		);
	}
        
	public function actionGeneratePdf()  {
        $session=new CHttpSession;
        $session->open();
		Yii::import('application.extensions.bootstrap.gii.*');
		require_once('bootstrap/tcpdf/tcpdf.php');
		require_once('bootstrap/tcpdf/config/lang/eng.php');

        if(isset($session['UsuariosAgencias_records'])) {
        	$model=$session['UsuariosAgencias_records'];
        }
        else
            $model = UsuariosAgencias::model()->findAll();

		$html = $this->renderPartial('expenseGridtoReport', array(
			'model'=>$model
		), true);
		
		//die($html);
		
		$pdf = new TCPDF();
		$pdf->SetCreator(PDF_CREATOR);
		$pdf->SetAuthor(Yii::app()->name);
		$pdf->SetTitle('UsuariosAgencias Report');
		$pdf->SetSubject('UsuariosAgencias Report');
		//$pdf->SetKeywords('example, text, report');
		$pdf->SetHeaderData('', 0, "Report", '');
		$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, "Example Report by ".Yii::app()->name, "");
		$pdf->setHeaderFont(Array('helvetica', '', 8));
		$pdf->setFooterFont(Array('helvetica', '', 6));
		$pdf->SetMargins(15, 18, 15);
		$pdf->SetHeaderMargin(5);
		$pdf->SetFooterMargin(10);
		$pdf->SetAutoPageBreak(TRUE, 0);
		$pdf->SetFont('dejavusans', '', 7);
		$pdf->AddPage();
		$pdf->writeHTML($html, true, false, true, false, '');
		$pdf->LastPage();
		$pdf->Output("UsuariosAgencias_002.pdf", "I");
	}
}