<?php
Yii::import('application.extensions.bootstrap.gii.*');
require_once('bootstrap/tcpdf/tcpdf.php');
require_once('bootstrap/tcpdf/config/lang/eng.php');

class VentasController extends Controller {
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout = '//layouts/column1';

	/**
	 * @return array action filters
	 */
	public function filters() {
		return array(
			'accessControl', // perform access control for CRUD operations
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules() {
		return array(
			array(
				'allow',  // allow all users to perform 'index' and 'view' actions
				'actions' => array('create', 'createV2', 'index', 'view', 'update', 'updateV2', 'deleteServicios', 'VentasApi', 'misVentas', 'listaventas', 'CreateServicio', 'VentasServiciosApi', 'EliminarVenta', 'updateServicio', 'loadModels', 'searchCustomers'),
				'users' => array('@'),
			),
			array(
				'allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions' => array('update', 'delete', 'GeneratePdf', 'GenerateExcel', 'VentasApi', 'misVentas', 'listaventas', 'createApi', 'getSaleInfo', 'updateApi', 'createRoominglist', 'createFolderTest', 'updatePaymentPromises'),
				'users' => array('@'),
			),
			array(
				'allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions' => array('admin', 'deleteServicios', 'VentasApi', 'Ventas', 'listaventas', 'CreateServicio', 'EliminarVenta'),
				'users' => array('admin'),
			),
			array(
				'deny',  // deny all users
				'users' => array('*'),
			),
		);
	}

	public function actionGetSaleInfo($id) {
		$model = Ventas::model()->with('idAgencia', 'ventasServicioses.pagosDetalles.idPago.idFormaPago', 'idCliente.usuariosClientes', 'contratos')->findByPk($id);
		$general = Yii::app()->createController('general')[0];
		$response = $general->convertModelToArray($model, "desglose");
		echo json_encode($response);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id) {
		$model = $this->loadModel($id);

		if ($_SESSION['Agencia']->id_agencia == $model->idAgencia->id_agencia) {
			$this->render('view', array(
				'model' => $this->loadModel($id),
			));
		} else {
			$this->render('ventas');
		}
	}

	public function actionVentasApi() {
		//$additional_sql = $_SESSION["Usuario"]->rol == "Agente" ? " AND t.id_usuario = ". Yii::app()->user->id : "";
		$ventasresult = Ventas::model()->with('idAgencia', 'ventasServicioses', 'ventasServicioses.idTipoServicio', 'ventasServicioses.idProveedor', 'idCliente', 'idTipoVenta', 'perteneceA')->findAll('t.id_agencia = "' . $_SESSION['Agencia']->id_agencia . '" AND t.estatus NOT LIKE "cancelado"'. $additional_sql);
		$general = Yii::app()->createController('general')[0];
		$array = $general->convertModelToArray($ventasresult);
		//echo json_encode($array[0]['ventasServicioses']);
		$sumaservicios = 0;
		foreach ($array as $index1 => $ventas) {
			$agente = Profiles::model()->findByPk($ventas['id_usuario']);
			$sumaserviciosporventa = 0;
			$costototalporventa = 0;
			foreach ($ventas['ventasServicioses'] as $index => $servicio) {

				// suma de las tarifas de todas las ventas
				$sumaservicios += $servicio['tarifa_publica']; //todos los servicios de todas las ventas
				$costototal += $servicio['costo'];
				$sumaserviciosporventa += $servicio['tarifa_publica']; //unaventa todos servicio
				$costototalporventa += $servicio['costo'];
				$array[$index1]['sumatotalporventa'] = $sumaserviciosporventa;
				$array[$index1]['costototalporventa'] = $costototalporventa;
			}
			$array[$index1]['sumatotal'] = $sumaservicios;
			$array[$index1]['costototal'] = $costototal;
			$array[$index1]['agente'] = $agente->firstname . ' ' . $agente->lastname;
		}

		echo json_encode($array);
	}

	public function actionVentasServiciosApi($id_venta) {
		$servicios = Ventas::model()->with('idAgencia', 'idCliente', 'ventasServicioses', 'ventasServicioses.idTipoServicio', 'ventasServicioses.idProveedor')->findAll(
			't.id_agencia = "' . $_SESSION['Agencia']->id_agencia . '"
		 AND t.id_venta= "' . $id_venta . '" '
		);
		$general = Yii::app()->createController('general')[0];
		$array = $general->convertModelToArray($servicios);

		foreach ($array as $index1 => $ventas) {
			$sumaserviciosporventa = 0;
			foreach ($ventas['ventasServicioses'] as $index => $servicio) {

				// code... suma de las tarifas de todas las ventas
				// $sumaservicios += $servicio['tarifa_publica']; //todos los servicios de todas las ventas
				$sumaserviciosporventa += $servicio['tarifa_publica']; //unaventa todos servicio
				$costototalporventa += $servicio['costo'];
			}
			$array[$index1]['totalServicios'] = $sumaserviciosporventa;
			$array[$index1]['costototalporventa'] = $costototalporventa;
			// $array[$index1]['sumatotal'] = $sumaservicios;
		}
		echo json_encode($array);
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreateV1() {
		$model = new Ventas;
		$cliente = new Clientes;
		$ventasServicios = new VentasServicios;
		$model->id_agencia = $_SESSION['Agencia']->id_agencia;
		$model->id_usuario = $_SESSION['Usuario']->id_usuario;  // Yii::app()->user->id;
		$this->render('create', array(
			'model' => $model,
			'cliente' => $cliente,
			'ventasServicios' => $ventasServicios,
		));
	}

	public function actionSearchCustomers() {
		$model = Clientes::model()->findAll("id_agencia = " . $_SESSION["Agencia"]->id_agencia);
		$response = array();
		foreach ($model as $key => $value) {
			array_push($response, array(
				"id" => $value->id_cliente,
				"text" => $value->nombre,
				"phone" => $value->telefono,
				"mail" => $value->correo,
			));
		}
		echo json_encode($response);
	}

	public function actionCreate() {
		$this->render('cu_form', array(
			"action" => "create"
		));
	}

	public function actionUpdate() {
		$this->render('cu_form', array(
			"action" => "update"
		));
	}

	public function actionCreateApi() {
		$transaction = Yii::app()->db->beginTransaction();
		if($_POST["price_code"]) {
			$price = Cotizaciones::model()->findByPk($_POST["price_code"]);
			$price->estatus = "venta";
			$price->save();
		}
		$model = new Ventas;
		$model->attributes = $_POST['sale'];
		if($model->id_tipo_venta == 0) {
			$model->id_tipo_venta = NULL;
			$model->pertenece_a = NULL;
		} else if(!in_array($model->id_tipo_venta, array(1,2))) {
			$model->pertenece_a = NULL;
		}

		if ($model->save()) {
			$folio = "ERP" . $model->id_venta . $model->id_cliente;
			$model->folio = $folio;
			if($_POST["price_code"]) $model->id_cotizacion = $_POST["price_code"];
			$model->save();

			$response = array(
				"success" => true,
				"error" => "",
				"sale" => $model,
				"contract" => "",
				"services" => array(),
				"group" => array(),
				"event" => "",
				"roominglist" => "",
			);

			$contract = new Contratos;
			$contract->id_user_creo = $model->id_usuario;
			$contract->estatus = "C";
			$contract->version = 1;
			$contract->id_venta = $model->id_venta;
			$contract->id_cliente = $model->id_cliente;
			$contract->id_agencia = $model->id_agencia;
			if($contract->save()) {
				$response["contract"] = $contract;
				
				foreach ($_POST['services'] as $shop) {
					$ventasServicios = new VentasServicios;
					$ventasServicios->attributes = $shop;
					$ventasServicios->id_venta = $model->id_venta;
					$ventasServicios->pagado_proveedor = 0;
					if($ventasServicios->id_tipo_servicio == 2 || $ventasServicios->id_tipo_servicio == 6) {
						$shop["desglose"]["redondo"] = intval($shop["desglose"]["redondo"]);
						if($ventasServicios->id_tipo_servicio == 6) {
							$shop["desglose"]["escala"] = intval($shop["desglose"]["escala"]);
							$shop["desglose"]["internacional"] = intval($shop["desglose"]["internacional"]);
							// Rodrigo
							// if (!isset($shop["desglose"]['pasajeros']['menores'])) {
							// 	$shop["desglose"]['pasajeros']["menores"] = array();
							// }
						}
					}
					if ($ventasServicios->id_tipo_servicio == 2 || $ventasServicios->id_tipo_servicio == 5 || $ventasServicios->id_tipo_servicio ==6 || $ventasServicios->id_tipo_servicio == 7 || $ventasServicios->id_tipo_servicio == 8 || $ventasServicios->id_tipo_servicio == 9 || $ventasServicios->id_tipo_servicio == 10) {
						if (!isset($shop["desglose"]["pasajeros"]["menores"])) {
							$shop["desglose"]["pasajeros"]["menores"] = array();
						}
					}

					if ($ventasServicios->id_tipo_servicio == 1) {
						foreach ($shop["desglose"]["habitaciones"] as $h1_index => $hab_pas) {
							if (!isset($shop["desglose"]["habitaciones"][$h1_index]["pasajeros"]["menores"])) {	
								$shop["desglose"]["habitaciones"][$h1_index]["pasajeros"]["menores"] = array();	
							}
							
						}
					}
			$ventasServicios->desglose = json_encode($shop["desglose"]);
					
					if($ventasServicios->save()) {
						array_push($response["services"], $ventasServicios);
						if($shop['id_tipo_servicio'] == 3 || $shop['id_tipo_servicio'] == 4) {
							$date1 = date_create_from_format('Y-m-d', $ventasServicios->fin_servicio);
							$date2 = date_create_from_format('Y-m-d', $ventasServicios->inicio_servicio);
							$diff = (array) date_diff($date1, $date2);

							$grupo = new Grupos;
							$grupo->id_agencia = $model->id_agencia;
							$grupo->id_cliente = $model->id_cliente;
							$grupo->id_usuario = $model->id_usuario;
							$grupo->id_ventaservicio = $ventasServicios->id_ventaservicio;
							$grupo->noches = $diff["days"];
							$grupo->num_habitaciones = $shop["desglose"]["no_hab"];
							$grupo->tipo_habitacion = $shop["desglose"]["tipo_hab"];
							$grupo->estatus = "Activo";
							$grupo->tipo = $shop["id_tipo_servicio"] == 3 ? "Grupo" : "Boda";
							if ($grupo->save()) {
								$response["group"] = $grupo;
								$roominglist = $this->createRoominglist($grupo->id_grupo, $ventasServicios, $shop["desglose"]["no_hab"], $shop["desglose"]["tipo_hab"]);
								$response["roominglist"] = $roominglist;
	
								$event = new Eventos;
								$event->slug = str_replace(" ", "-", strtolower($shop["desglose"]["novios"]));
								$event->template = 1;
								$event->id_grupo = $grupo->id_grupo;
								if($event->save()) {
									$folders = $this->createEventFolders($event->id);
									$response["event"] = $event;
								} else {
									$transaction->rollback();
									$response["success"] = false;
									$response["error"] = "event";
									$response["group"] = $event->getErrors();
								}
							} else {
								$transaction->rollback();
								$response["success"] = false;
								$response["error"] = "group";
								$response["group"] = $grupo->getErrors();
							}
						}
					} else {
						$transaction->rollback();
	
						$response["success"] = false;
						$response["error"] = "services";
						array_push($response["services"], $ventasServicios->getErrors());
						break;
					}
				}
			} else {
				$transaction->rollback();

				$response["success"] = false;
				$response["error"] = "contract";
				$response["contract"] = $contract->getErrors();
			}

			if($response["success"]) $transaction->commit();
			echo CJSON::encode($response);
		} else {
			$transaction->rollback();
			echo CJSON::encode(array(
				"success" => false,
				"error" => "sale",
				"sale" => $model->getErrors()
			));
		}
	}

	public function actionCreateFolderTest($id) {
		$response = $this->createEventFolders($id);
		echo json_encode($response);
	}

	public function createEventFolders($id_evento) {
		$principal = mkdir(("images/eventos/evento_". $id_evento), 0755, true);
		if($principal) {
			$galeria = mkdir(("images/eventos/evento_". $id_evento ."/galeria"), 0755, true);
			$multimedia = mkdir(("images/eventos/evento_". $id_evento ."/multimedia"), 0755, true);
			return array("success" => true);
		}
		return array("success" => false);
	}

	public function saveVentasServiciosDesglose($ventaServicio,$service) {
		$model = new VentasServiciosDesglose();
		$model->id_ventaservicio = $ventaServicio->id_ventaservicio;
		switch ($ventaServicio->id_tipo_servicio) {
			case '1':
				$desglose = $service['hospedajes_array'];
				break;
			case '2':
				$desglose = $service['traslados_array'];
				break;
			case '6':
				$desglose = $service['vuelos_array'];
				break;
		}
		$model->desglose = json_encode($desglose);
		if($model->save()) return true;
		else return false;
	}

	public function actionUpdateApi() {
		$transaction = Yii::app()->db->beginTransaction();
		$model = Ventas::model()->findByPk($_POST["sale"]["id_venta"]);
		$model->attributes = $_POST["sale"];
		if($model->id_tipo_venta == 0) {
			$model->id_tipo_venta = NULL;
			$model->pertenece_a = NULL;
		} else if(!in_array($model->id_tipo_venta, array(1,2))) {
			$model->pertenece_a = NULL;
		}
		if ($model->save()) {
			$aux_limit_date = "";
			$ventas = VentasServicios::model()->findAll("id_venta = ". $model->id_venta);
			foreach ($ventas as $key => $value) {
				$index = array_search($value->id_ventaservicio, array_column($_POST["services"], 'id_ventaservicio'));
				if (!$index && gettype($index) == "boolean") {
					$value->delete();
				}

				//update promesas de pago START
				/* if($value->id_tipo_servicio != 6) {
					if($aux_limit_date == "") {
						if($value->limite_cliente == "0000-00-00" || is_null($value->limite_cliente)) {
							$aux_limit_date = $value->fecha_limite;
						} else {
							$aux_limit_date = $value->limite_cliente;
						}
					} else {
						if($value->limite_cliente == "0000-00-00" || is_null($value->limite_cliente)) {
							if($value->fecha_limite < $aux_limit_date) {
								$aux_limit_date = $value->fecha_limite;
							}
						} else {
							if($value->limite_cliente < $aux_limit_date) {
								$aux_limit_date = $value->limite_cliente;
							}
						}
					}
				} */
				//update promesas de pago END
			}
			/* $aux_promises = PromesasPagos::model()->findAll('id_venta = '. $model->id_venta);
			if(count($aux_promises) > 0) $this->updatePaymentPromises($model->id_venta, $aux_limit_date); */

			$response = array(
				"success" => true,
				"error" => "",
				"sale" => $model,
				"services" => array(),
			);
			
			foreach ($_POST["services"] as $key => $value) {
				if ($value["id_ventaservicio"]) {
					$model_vs = VentasServicios::model()->findByPk($value["id_ventaservicio"]);
				} else {
					$model_vs = new VentasServicios;
				}
				$model_vs->attributes = $value;
				if($model_vs->id_tipo_servicio == 2 || $model_vs->id_tipo_servicio == 6) {
					$value["desglose"]["redondo"] = intval($value["desglose"]["redondo"]);
					if($model_vs->id_tipo_servicio == 6) {
						$value["desglose"]["escala"] = intval($value["desglose"]["escala"]);
						$value["desglose"]["internacional"] = intval($value["desglose"]["internacional"]);
						// // Rodrigo
						// if (!isset($value["desglose"]['pasajeros']['menores'])) {
						// 	$value["desglose"]['pasajeros']["menores"] = array();
						// }
					}
				}
				if ($model_vs->id_tipo_servicio == 2 || $model_vs->id_tipo_servicio == 5 || $model_vs->id_tipo_servicio == 6 || $model_vs->id_tipo_servicio == 7 || $model_vs->id_tipo_servicio == 8 || $model_vs->id_tipo_servicio == 9 || $model_vs->id_tipo_servicio == 10) {
					if (!isset($value["desglose"]["pasajeros"]["menores"])) {
						$value["desglose"]["pasajeros"]["menores"] = array();
					}
				}
				if ($model_vs->id_tipo_servicio == 1) {
					foreach ($value["desglose"]["habitaciones"] as $h_index => $hab_pas) {
						if (!isset($value["desglose"]["habitaciones"][$h_index]["pasajeros"]["menores"])) {	
							$value["desglose"]["habitaciones"][$h_index]["pasajeros"]["menores"] = array();	
						}
						
					}
				}

				$model_vs->desglose = json_encode($value["desglose"]);
				
				if ($model_vs->save()) {
					array_push($response["services"], $model_vs);
				} else {
					$transaction->rollback();

					$response["success"] = false;
					$response["error"] = "services";
					array_push($response["services"], $model_vs->getErrors());
				}
			}

			if($response["success"]) $transaction->commit();
			echo CJSON::encode($response);
		} else {
			$transaction->rollback();
			echo CJSON::encode(array(
				"success" => false,
				"error" => "sale",
				"sale" => $model->getErrors()
			));
		}
	}

	public function actionUpdatePaymentPromises($id, $limit_date = "2023-09-20", $total = 10000) { //id_venta
		$payment_promises = PromesasPagos::model()->findAll("id_venta = ". $id);
		if($payment_promises[count($payment_promises) - 1]->fecha != $limit_date) {
			$date1 = date_create($payment_promises[0]->fecha);
			$date2 = date_create($payment_promises[1]->fecha);
			$diff = date_diff($date1, $date2);

			$aux_date_add = "";
			if($diff->format("%a") >= 30) {
				$aux_date_add = "+1 month";
				$aux_date_diff = "m";
			} else if($diff->format("%a") == 7) {
				$aux_date_add = "+1 week";
				$aux_date_diff = "d";
			} else {
				$aux_date_add = "+2 week";
				$aux_date_diff = "d";
			}

			$total_payments = 0;
			$start_date = "";
			foreach ($payment_promises as $key => $payment) {
				if($payment->fecha < date('Y-m-d')) {
					$total_payments += $payment->monto;
					$start_date = $payment->fecha;
				} else {
					//$payment->delete();
				}
			}
			$start_d = new DateTime($start_date);
			$end_d = new DateTime($limit_date);
			$interval = $start_d->diff($end_d);
			print_r($interval);
			exit;

			$finance = $total - $total_payments;
			$periods = $interval->$aux_date_diff;
			if($aux_date_add == "+1 month") {
				$aux_date_limit = strtotime($start_date. ' +'. $periods .' month');
				if($aux_date_limit < $limit_date) $periods++;
			} else if($aux_date_add == "+2 week") {
				$aux_date_limit = strtotime($start_date. ' +'. $periods .' week');
				if($aux_date_limit < $limit_date) $periods++;
				$periods = (int)($periods / 14);
			} else if($aux_date_add == "+1 week") {
				$aux_date_limit = strtotime($start_date. ' +'. $periods .' week');
				if($aux_date_limit < $limit_date) $periods++;
				$periods = (int)($periods / 7);
			}
			
			for ($i = 0; $i < $periods; $i++) {
				$model = new PromesasPagos;
				$model->id_venta = $id;
				$model->monto = number_format(($finance / $periods), 2);

				$aux_date = strtotime($start_date. $aux_date_add);
				if($aux_date < $limit_date) {
					$model->fecha = $aux_date;
				} else {
					$model->fecha = $limit_date;
				}
				$model->save();
			}
		}
	}

	public function actionCreateRoominglist($id, $nohabs, $tipohab) {
		$group_model = Grupos::model()->findByPk($id);
		$vs_model = VentasServicios::model()->findByPk($group_model->id_ventaservicio);
		$roominglist = $this->createRoominglist($id, $vs_model, $nohabs, $tipohab);
		echo CJSON::encode($roominglist);
	}

	public function createRoominglist($id, $model_vs, $no_habs, $tipo_hab) {
		$response_roominglist = array();
		for ($i = 0; $i < $no_habs; $i++) {
			$date1 = date_create_from_format('Y-m-d', $model_vs->fin_servicio);
			$date2 = date_create_from_format('Y-m-d', $model_vs->inicio_servicio);
			$diff = (array) date_diff($date1, $date2);

			$model_gh = new GrupoHabitaciones;
			$model_gh->id_grupo = $id;
			$model_gh->tipo_habitacion = $tipo_hab;
			$model_gh->noches = $diff["days"];
			$model_gh->fecha_entrada = $model_vs->inicio_servicio;
			$model_gh->fecha_salida = $model_vs->fin_servicio;
			$model_gh->total_neto = (floatval($model_vs->costo) / $no_habs);
			$model_gh->total_publico = (floatval($model_vs->tarifa_publica) / $no_habs);

			if($model_gh->save()) {
				for ($j = 0; $j < 2; $j++) {
					$model_huesped = new HabitacionesHuespedes;
					$model_huesped->id_habitacion = $model_gh->id_habitacion;
					$model_huesped->nombres = "";
					$model_huesped->apellidos = "";
					$model_huesped->edad = NULL;
					$model_huesped->correo = NULL;
					$model_huesped->telefono = NULL;
					if($model_huesped->save()) {
						array_push($response_roominglist, $model_huesped);
					} else {
						array_push($response_roominglist, $model_huesped->getErrors());
					}
				}
			}
		}
		return $response_roominglist;
	}

	public function actionCreateServicio() {
		$model = new Ventas;
		$cliente = new Clientes;
		$model->id_agencia = $_SESSION['Agencia']->id_agencia;
		$model->id_usuario = $_SESSION['Usuario']->id_usuario;  // Yii::app()->user->id;
		$model->fecha = date('Y-m-d');
		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);
		if (isset($_POST['shop_datos'])) {
			//echo json_encode($_POST);
			$model->attributes = $_POST['shop_datos'];
			$cliente->attributes = $_POST['datos_cliente'];
			$cliente->id_agencia = $_SESSION['Agencia']->id_agencia;
			if ($_POST['datos_cliente']['id_cliente'] != "") {
				$model->id_cliente = $_POST['datos_cliente']['id_cliente'];
			} else {

				$cliente->save();
				$model->id_cliente = $cliente->id_cliente;
			}
			/*$cliente->save();
			$model->id_cliente = $cliente->id_cliente;*/
			if ($model->save()) {
				$folio = "ERP" . $model->id_venta . $model->id_cliente;
				$model->folio = $folio;
				if ($model->save()) {
					if (!empty($_POST['shop'])) {
						foreach ($_POST['shop'] as $shop) {
							$ventasServicios = new VentasServicios;
							$ventasServicios->inicio_servicio = $shop['inicio_servicio'];
							$ventasServicios->fin_servicio = $shop['fin_servicio'];
							$ventasServicios->attributes = $shop;
							$ventasServicios->id_venta = $model->id_venta;
							$ventasServicios->save();
							if ($shop['id_tipo_servicio'] == 3) {
								$grupo = new Grupos;
								//$huespedes = new HabitacionesHuespedes;
								//$habitaciones = new GrupoHabitaciones;
								$grupo->id_venta = $model->id_venta;
								$grupo->id_agencia = $model->id_agencia;
								$grupo->id_cliente = $model->id_cliente;
								$grupo->id_usuario = $model->id_usuario;
								$grupo->num_habitaciones = 3;
								$grupo->attributes = $shop;
								if (!$grupo->save()) {
									echo CJSON::encode($grupo->getErrors());
								}
							}
						}
					}
					echo CJSON::encode($ventasServicios);
				}
			}
		}
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdateV1($id) {
		$model = $this->loadModel($id);
		if (isset($_POST['Ventas'])) {
			$model->attributes = $_POST['Ventas'];
			if ($model->save())
				$this->redirect(array('view', 'id' => $model->id_venta));
		}
		if ($_SESSION['Agencia']->id_agencia == $model->idAgencia->id_agencia) {
			$this->render('update', array(
				'model' => $model,
			));
		} else {
			$this->render('ventas');
		}
	}

	public function actionupdateServicio($id) {
		$model = $this->loadModel($id);
		$model->fecha = date('Y-m-d');
		$id_cliente = $model->id_cliente;
		$cliente = $this->loadmodelCliente($id_cliente);
		if (isset($_POST['shop_datos'])) {
			//json_encode($_POST);
			//echo json_encode($_POST);
			//exit;
			$model->attributes = $_POST['shop_datos'];
			$cliente->attributes = $_POST['datos_cliente'];
			$cliente->save();
			if ($model->save()) {
				if (!empty($_POST['shop'])) {
					foreach ($_POST['shop'] as $shop) {
						if ($shop['id_ventaservicio'] != "") {
							$ventasServicios = $this->loadModelServicios($shop['id_ventaservicio']);
						} else {
							$ventasServicios = new VentasServicios;
						}
						$ventasServicios->inicio_servicio = $shop['inicio_servicio'];;
						$ventasServicios->fin_servicio = $shop['fin_servicio'];
						$ventasServicios->attributes = $shop;
						$ventasServicios->id_venta = $model->id_venta;
						$ventasServicios->save();
					}
				}
				echo CJSON::encode($ventasServicios);
			}
		}
		if ($_SESSION['Agencia']->id_agencia == $model->idAgencia->id_agencia) {
			$this->render('update', array(
				'model' => $model,
				'servicio' => $servicio,
			));
		} else {
			$this->render('ventas');
		}
	}

	public function actionDelete($id) {
		$model = Ventas::model()->findByPk($id);
		$model->estatus = "cancelado";
		$model->save();

		$services = VentasServicios::model()->findAll('id_venta = '. $id);
		foreach ($services as $key => $service) {
			$service->estatus = "cancelado";
			$service->save();
		}

		echo json_encode(array(
			"success" => true
		));
	}

	public function actionEliminarVenta($id) {
		$servicios = VentasServicios::model()->with('idVenta')->findAll($id);
		$response = array();
		foreach ($servicios as $venta) {
			if ($venta->id_venta == $id) {
				$venta->delete();
			}
		}
		$modelo = Ventas::model()->findByPk($id);

		if ($modelo->delete()) {
			$response = array(
				"estatus" => 200,
				"mensaje" => "Se ha eliminado correctamente"
			);

			echo CJSON::encode($response);
		} else {
			throw new CHttpException(400, 'Solicitud Invalida.');
		}
	}


	public function actionDeleteServicios($id) {
		$servicios = $this->loadModelServicios($id);
		$response = array();
		if ($servicios) {
			if ($servicios->delete()) {
				$response = array(
					"estatus" => 200,
					"mensaje" => "Se ha eliminado correctamente"
				);
			} else {
				$response = array(
					"estatus" => 404,
					"mensaje" => "No se ha podido elminar el contacto"
				);
			}
		} else {
			$response = array(
				"estatus" => 404,
				"mensaje" => "No se ha encontrado ningún contacto"
			);
		}
		echo CJSON::encode($response);
	}

	public function actionIndex() {
		$this->render('ventas');
	}

	public function actionListaVentas() {
		$this->render('listaventas');
	}

	public function actionAdmin() {
		$model = new Ventas('search');
		$model->unsetAttributes();  // clear any default values
		if (isset($_GET['Ventas']))
			$model->attributes = $_GET['Ventas'];

		$this->render('admin', array(
			'model' => $model,
		));
	}

	public function loadModel($id) {
		$model = Ventas::model()->with('idAgencia', 'ventasServicioses', 'idCliente')->findByPk($id);
		if ($model === null)
			throw new CHttpException(404, 'The requested page does not exist.');
		return $model;
	}

	public function loadModelServicios($id) {
		$servicios = VentasServicios::model()->with('idVenta')->findByPk($id);
		if ($servicios === null)
			throw new CHttpException(404, 'The requested page does not exist.');
		return $servicios;
	}

	public function loadModelVentaServicios($id) {
		$servicios = VentasServicios::model()->with('idVenta')->findAll('t.id_venta="' . $id . '"');
		if ($servicios === null)
			throw new CHttpException(404, 'The requested page does not exist.');
		return $servicios;
	}

	public function actionloadModels($id) {
		$model = $this->loadModel($id);
		$general = Yii::app()->createController('general')[0];
		$array = $general->convertModelToArray($model);
		echo json_encode($array);
	}

	public function loadmodelCliente($id_cliente) {
		$cliente = Clientes::model()->findByPk($id_cliente);
		if ($cliente === null)
			throw new CHttpException(404, 'The requested page does not exist.');
		return $cliente;
	}

	protected function performAjaxValidation($model) {
		if (isset($_POST['ajax']) && $_POST['ajax'] === 'ventas-form') {
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}

	public function actionGenerateExcel() {
		$session = new CHttpSession;
		$session->open();
		if (isset($session['Ventas_records'])) {
			$model = $session['Ventas_records'];
		} else
			$model = Ventas::model()->findAll();

		Yii::app()->request->sendFile(
			date('YmdHis') . '.xls',
			$this->renderPartial('excelReport', array(
				'model' => $model
			), true)
		);
	}

	public function actionGeneratePdf($id) {
		$session = new CHttpSession;
		$session->open();
		if (isset($session['Ventas_records'])) {
			$model = $session['Ventas_records'];
		} else {
			$html = $this->renderPartial('expenseGridtoReport', array(
				'model' => $model
			), true);
			//die($html);
			$pdf = new MYPDF();
			$model = Ventas::model()->find('id_venta=' . $_GET["id"]);
			///$model = Ventas::model()->findAll('id_venta = '.$id);
			$model_agencia = $model->idAgencia;
			$model_usuario = Profile::model()->find('user_id=' . Yii::app()->user->id);
			$agency_logo = $_SERVER['DOCUMENT_ROOT'] . "/imagenes/" . $model_agencia->logotipo;
			if (empty($model_agencia->logotipo) || !is_readable($_SERVER['DOCUMENT_ROOT'] . "/imagenes/" . $model_agencia->logotipo)) {
				$agency_logo = "https://rutamayatravel.com/images/logo-agencia-no-definido.png";
			}
			$tel_agencia = strlen($model_agencia->telefono) == 10 ? ("(" . substr($model_agencia->telefono, 0, 3) . ")" . substr($model_agencia->telefono, 3, 10)) : $model_agencia->telefono;
			$created_by = $model_usuario->firstname;
			$header_agency = '<div align="center" class="headerdiv"><img height="40" src="' . $agency_logo . '"><br><b style="font-size:9px;">' . $model_agencia->nombre_comercial . '</b><br> ' . $model_agencia->direccion . '</div>'; //.' No. '. /*$model_agencia->num_exterior_agencia*/ .' Colonia '. $model_agencia->id_colonia_agencia .'<br>'. $model_agencia->id_ciudad_agencia .', '. $estado->nombreestado .' '. $pais->nombre_pais .'<br>Tel. '. $tel_agencia .'</div>';
			$pdf_header = "<table class='tableHeader' style='margin-bottom: 3px;'><tr><td>" . $header_agency . "</td><td></td></tr></table><hr>";
			$pdf->pdf_header = $pdf_header;
			$pdf->footer_pdf = "
			<table>
				<tr>
					<td>Cotización generada: por </td>
				</tr>
				<tr>
					<td>
						* Precio sujetos a cambios sin previo aviso.
					</td>
				</tr>
				<tr>
					<td>
						* Estancia sujeta a disponibilidad y revisión por parte del ejecutivo.
					</td>
				</tr>
				<tr>
					<td></td>
				</tr>
			</table>";

			$pdf->SetCreator(PDF_CREATOR);
			$pdf->SetAuthor(Yii::app()->name);
			$pdf->SetTitle('Ventas Report');
			$pdf->SetSubject('Ventas Report');
			//$pdf->SetKeywords('example, text, report');
			/*$pdf->SetHeaderData('', 0, "Report", '');
			$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, "Example Report by " . Yii::app()->name, "");*/
			/*$pdf->setHeaderFont(array('helvetica', '', 8));
			$pdf->setFooterFont(array('helvetica', '', 6));
			$pdf->SetMargins(15, 18, 15);*/
			$pdf->SetHeaderMargin(5);
			$pdf->SetFooterMargin(10);
			$pdf->SetAutoPageBreak(TRUE, 0);
			$pdf->SetFont('dejavusans', '', 7);
			$pdf->AddPage();
			$pdf->writeHTML($html, true, false, true, false, '');
			$pdf->LastPage();
			$pdf->Output("Ventas_002.pdf", "I");
		}
	}

	public function actionmisVentas() {
		$this->render('ventas');
	}
}

class MYPDF extends TCPDF {
	public $header_pdf;
	public $footer_pdf;

	//Page header
	public function Header() {
		$this->SetFont('helvetica', '', 10);
		$this->writeHTML($this->pdf_header, false, true, false, true);
	}

	public function Footer() {
		$this->SetFont('helvetica', '', 10);
		$this->writeHTML($this->footer_pdf, false, true, false, true);
	}
}