<?php

/**
 * This is the model class for table "{{agencia}}".
 *
 * The followings are the available columns in table '{{agencia}}':
 * @property integer $id_agencia
 * @property string $nombre_comercial
 * @property string $telefono
 * @property string $whatsapp
 * @property string $correo
 * @property string $direccion
 * @property string $ciudad
 * @property string $estado
 * @property string $codigo_postal
 * @property string $rfc
 * @property string $rnt
 * @property string $logotipo
 * @property string $sitio_web
 * @property string $estatus
 * @property string $log
 * @property string $plan
 *
 * The followings are the available model relations:
 * @property Clientes[] $clientes
 * @property Proveedores[] $proveedores
 * @property UsuariosAgencias[] $usuariosAgenciases
 * @property Ventas[] $ventases
 */
class Agencia extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Agencia the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{agencia}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('nombre_comercial, telefono, correo', 'required'),
			array('nombre_comercial', 'length', 'max'=>35),
			array('telefono, whatsapp', 'length', 'max'=>18),
			array('correo', 'length', 'max'=>50,),
			array('direccion', 'length', 'max'=>85),			
			array('ciudad, estado, rfc, rnt', 'length', 'max'=>25),
			array('codigo_postal', 'length', 'max'=>5),
			array('sitio_web', 'length', 'max'=>128),
			array('estatus', 'length', 'max'=>10),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_agencia, nombre_comercial, telefono, whatsapp, correo, direccion, ciudad, estado, codigo_postal, rfc, rnt, logotipo, sitio_web, estatus, log', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'clientes' => array(self::HAS_MANY, 'Clientes', 'id_agencia'),
			'proveedores' => array(self::HAS_MANY, 'Proveedores', 'id_agencia'),
			'usuariosAgenciases' => array(self::HAS_MANY, 'UsuariosAgencias', 'id_agencia'),
			'ventases' => array(self::HAS_MANY, 'Ventas', 'id_agencia'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_agencia' => 'Id Agencia',
			'nombre_comercial' => 'Nombre Comercial',
			'telefono' => 'Telefono',
			'whatsapp' => 'Whatsapp',
			'correo' => 'Correo',
			'direccion' => 'Direccion',
			'ciudad' => 'Ciudad',
			'estado' => 'Estado',
			'codigo_postal' => 'Codigo Postal',
			'rfc' => 'Rfc',
			'rnt' => 'Rnt',
			'logotipo' => 'Logotipo',
			'sitio_web' => 'Sitio Web',
			'estatus' => 'Estatus',
			'log' => 'Log',
			'plan' => 'Plan',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_agencia',$this->id_agencia);
		$criteria->compare('nombre_comercial',$this->nombre_comercial,true);
		$criteria->compare('telefono',$this->telefono,true);
		$criteria->compare('whatsapp',$this->whatsapp,true);
		$criteria->compare('correo',$this->correo,true);
		$criteria->compare('direccion',$this->direccion,true);
		$criteria->compare('ciudad',$this->ciudad,true);
		$criteria->compare('estado',$this->estado,true);
		$criteria->compare('codigo_postal',$this->codigo_postal,true);
		$criteria->compare('rfc',$this->rfc,true);
		$criteria->compare('rnt',$this->rnt,true);
		$criteria->compare('logotipo',$this->logotipo,true);
		$criteria->compare('sitio_web',$this->sitio_web,true);
		$criteria->compare('estatus',$this->estatus,true);
		$criteria->compare('log',$this->log,true);
		$criteria->compare('plan',$this->plan,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}