<?php

/**
 * This is the model class for table "{{bodas}}".
 *
 * The followings are the available columns in table '{{bodas}}':
 * @property integer $id_boda
 * @property integer $id_venta
 * @property integer $id_agencia
 * @property integer $id_cliente
 * @property integer $id_usuario
 * @property string $titulo_evento
 * @property string $num_habitaciones
 * @property string $noches
 * @property string $hotel
 * @property string $tipo_habitacion
 * @property string $condiciones
 * @property string $estatus
 * @property string $log
 *
 * The followings are the available model relations:
 * @property Ventas $idVenta
 * @property Users $idUsuario
 * @property Clientes $idCliente
 * @property Agencia $idAgencia
 */
class Bodas extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Bodas the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{bodas}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_venta, id_agencia, id_cliente, id_usuario', 'required'),
			array('id_venta, id_agencia, id_cliente, id_usuario', 'numerical', 'integerOnly'=>true),
			array('titulo_evento, hotel', 'length', 'max'=>50),
			array('num_habitaciones, noches', 'length', 'max'=>2),
			array('tipo_habitacion', 'length', 'max'=>35),
			array('condiciones', 'length', 'max'=>250),
			array('estatus', 'length', 'max'=>15),
			array('log', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_boda, id_venta, id_agencia, id_cliente, id_usuario, titulo_evento, num_habitaciones, noches, hotel, tipo_habitacion, condiciones, estatus, log', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idVenta' => array(self::BELONGS_TO, 'Ventas', 'id_venta'),
			'idUsuario' => array(self::BELONGS_TO, 'Users', 'id_usuario'),
			'idCliente' => array(self::BELONGS_TO, 'Clientes', 'id_cliente'),
			'idAgencia' => array(self::BELONGS_TO, 'Agencia', 'id_agencia'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_boda' => 'Id Boda',
			'id_venta' => 'Id Venta',
			'id_agencia' => 'Id Agencia',
			'id_cliente' => 'Id Cliente',
			'id_usuario' => 'Id Usuario',
			'titulo_evento' => 'Titulo Evento',
			'num_habitaciones' => 'Num Habitaciones',
			'noches' => 'Noches',
			'hotel' => 'Hotel',
			'tipo_habitacion' => 'Tipo Habitacion',
			'condiciones' => 'Condiciones',
			'estatus' => 'Estatus',
			'log' => 'Log',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_boda',$this->id_boda);
		$criteria->compare('id_venta',$this->id_venta);
		$criteria->compare('id_agencia',$this->id_agencia);
		$criteria->compare('id_cliente',$this->id_cliente);
		$criteria->compare('id_usuario',$this->id_usuario);
		$criteria->compare('titulo_evento',$this->titulo_evento,true);
		$criteria->compare('num_habitaciones',$this->num_habitaciones,true);
		$criteria->compare('noches',$this->noches,true);
		$criteria->compare('hotel',$this->hotel,true);
		$criteria->compare('tipo_habitacion',$this->tipo_habitacion,true);
		$criteria->compare('condiciones',$this->condiciones,true);
		$criteria->compare('estatus',$this->estatus,true);
		$criteria->compare('log',$this->log,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}