<?php

/**
 * This is the model class for table "{{cliente_info_fiscal}}".
 *
 * The followings are the available columns in table '{{cliente_info_fiscal}}':
 * @property integer $id_cliente_info_fiscal
 * @property string $rfc
 * @property string $razon_social
 * @property string $calle
 * @property string $no_exterior
 * @property string $no_interior
 * @property string $cp
 * @property string $colonia
 * @property string $municipio
 * @property string $ciudad
 * @property string $estado
 * @property string $pais
 * @property string $correo
 * @property string $cfdi
 * @property string $metodo_pago
 * @property string $forma_pago
 * @property integer $id_cliente
 *
 * The followings are the available model relations:
 * @property Clientes $idCliente
 */
class ClienteInfoFiscal extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return ClienteInfoFiscal the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{cliente_info_fiscal}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('rfc, razon_social, cp, id_cliente', 'required'),
			array('id_cliente', 'numerical', 'integerOnly'=>true),
			array('rfc', 'length', 'max'=>50),
			array('razon_social', 'length', 'max'=>200),
			array('calle, colonia, municipio, ciudad, estado, pais, correo, cfdi, metodo_pago, forma_pago', 'length', 'max'=>100),
			array('no_exterior, no_interior', 'length', 'max'=>20),
			array('cp', 'length', 'max'=>10),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_cliente_info_fiscal, rfc, razon_social, calle, no_exterior, no_interior, cp, colonia, municipio, ciudad, estado, pais, correo, cfdi, metodo_pago, forma_pago, id_cliente', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idCliente' => array(self::BELONGS_TO, 'Clientes', 'id_cliente'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_cliente_info_fiscal' => 'Id Cliente Info Fiscal',
			'rfc' => 'Rfc',
			'razon_social' => 'Razon Social',
			'calle' => 'Calle',
			'no_exterior' => 'No Exterior',
			'no_interior' => 'No Interior',
			'cp' => 'Cp',
			'colonia' => 'Colonia',
			'municipio' => 'Municipio',
			'ciudad' => 'Ciudad',
			'estado' => 'Estado',
			'pais' => 'Pais',
			'correo' => 'Correo',
			'cfdi' => 'Cfdi',
			'metodo_pago' => 'Metodo Pago',
			'forma_pago' => 'Forma Pago',
			'id_cliente' => 'Id Cliente',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_cliente_info_fiscal',$this->id_cliente_info_fiscal);
		$criteria->compare('rfc',$this->rfc,true);
		$criteria->compare('razon_social',$this->razon_social,true);
		$criteria->compare('calle',$this->calle,true);
		$criteria->compare('no_exterior',$this->no_exterior,true);
		$criteria->compare('no_interior',$this->no_interior,true);
		$criteria->compare('cp',$this->cp,true);
		$criteria->compare('colonia',$this->colonia,true);
		$criteria->compare('municipio',$this->municipio,true);
		$criteria->compare('ciudad',$this->ciudad,true);
		$criteria->compare('estado',$this->estado,true);
		$criteria->compare('pais',$this->pais,true);
		$criteria->compare('correo',$this->correo,true);
		$criteria->compare('cfdi',$this->cfdi,true);
		$criteria->compare('metodo_pago',$this->metodo_pago,true);
		$criteria->compare('forma_pago',$this->forma_pago,true);
		$criteria->compare('id_cliente',$this->id_cliente);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}