<?php

/**
 * This is the model class for table "{{clientes}}".
 *
 * The followings are the available columns in table '{{clientes}}':
 * @property integer $id_cliente
 * @property string $nombre
 * @property string $telefono
 * @property string $telefono_secundario
 * @property string $correo
 * @property string $direccion
 * @property integer $id_agencia
 * @property string $log
 *
 * The followings are the available model relations:
 * @property ClienteInfoFiscal[] $clienteInfoFiscals
 * @property Agencia $idAgencia
 * @property Cotizaciones[] $cotizaciones
 * @property Grupos[] $gruposes
 * @property Solicitudes[] $solicitudes
 * @property UsuariosClientes[] $usuariosClientes
 * @property Ventas[] $ventases
 */
class Clientes extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Clientes the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{clientes}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('nombre, id_agencia', 'required'),
			array('id_agencia', 'numerical', 'integerOnly'=>true),
			array('telefono, telefono_secundario', 'length', 'max'=>15),
			array('correo', 'length', 'max'=>50),
			array('direccion', 'length', 'max'=>200),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_cliente, nombre, telefono, telefono_secundario, correo, direccion, id_agencia, log', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'clienteInfoFiscal' => array(self::HAS_ONE, 'ClienteInfoFiscal', 'id_cliente'),
			'idAgencia' => array(self::BELONGS_TO, 'Agencia', 'id_agencia'),
			'cotizaciones' => array(self::HAS_MANY, 'Cotizaciones', 'id_cliente'),
			'gruposes' => array(self::HAS_MANY, 'Grupos', 'id_cliente'),
			'solicitudes' => array(self::HAS_MANY, 'Solicitudes', 'id_cliente'),
			'usuariosClientes' => array(self::HAS_ONE, 'UsuariosClientes', 'id_cliente'),
			'ventases' => array(self::HAS_MANY, 'Ventas', 'id_cliente'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_cliente' => 'Id Cliente',
			'nombre' => 'Nombre',
			'telefono' => 'Telefono',
			'telefono_secundario' => 'Telefono Secundario',
			'correo' => 'Correo',
			'direccion' => 'Direccion',
			'id_agencia' => 'Id Agencia',
			'log' => 'Log',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_cliente',$this->id_cliente);
		$criteria->compare('nombre',$this->nombre,true);
		$criteria->compare('telefono',$this->telefono,true);
		$criteria->compare('telefono_secundario',$this->telefono_secundario,true);
		$criteria->compare('correo',$this->correo,true);
		$criteria->compare('direccion',$this->direccion,true);
		$criteria->compare('id_agencia',$this->id_agencia);
		$criteria->compare('log',$this->log,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}