<?php

/**
 * This is the model class for table "{{contrato_desglose}}".
 *
 * The followings are the available columns in table '{{contrato_desglose}}':
 * @property integer $id_contrato_desglose
 * @property string $desglose
 * @property string $observaciones
 * @property double $comision
 * @property double $comision_pesos
 * @property double $fee
 * @property double $total_neto
 * @property double $total_publico
 * @property integer $id_proveedor
 * @property integer $id_tipo_servicio
 * @property integer $id_contrato
 * @property string $log
 *
 * The followings are the available model relations:
 * @property Contratos $idContrato
 * @property Proveedores $idProveedor
 * @property TipoServicios $idTipoServicio
 */
class ContratoDesglose extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return ContratoDesglose the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{contrato_desglose}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('desglose, comision, comision_pesos, total_neto, total_publico, id_proveedor, id_tipo_servicio, id_contrato', 'required'),
			array('id_proveedor, id_tipo_servicio, id_contrato', 'numerical', 'integerOnly'=>true),
			array('comision, comision_pesos, fee, total_neto, total_publico', 'numerical'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_contrato_desglose, desglose, observaciones, comision, comision_pesos, fee, total_neto, total_publico, id_proveedor, id_tipo_servicio, id_contrato, log', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idContrato' => array(self::BELONGS_TO, 'Contratos', 'id_contrato'),
			'idProveedor' => array(self::BELONGS_TO, 'Proveedores', 'id_proveedor'),
			'idTipoServicio' => array(self::BELONGS_TO, 'TipoServicios', 'id_tipo_servicio'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_contrato_desglose' => 'Id Contrato Desglose',
			'desglose' => 'Desglose',
			'observaciones' => 'Observaciones',
			'comision' => 'Comision',
			'comision_pesos' => 'Comision Pesos',
			'fee' => 'Fee',
			'total_neto' => 'Total Neto',
			'total_publico' => 'Total Publico',
			'id_proveedor' => 'Id Proveedor',
			'id_tipo_servicio' => 'Id Tipo Servicio',
			'id_contrato' => 'Id Contrato',
			'log' => 'Log',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_contrato_desglose',$this->id_contrato_desglose);
		$criteria->compare('desglose',$this->desglose,true);
		$criteria->compare('observaciones',$this->observaciones,true);
		$criteria->compare('comision',$this->comision);
		$criteria->compare('comision_pesos',$this->comision_pesos);
		$criteria->compare('fee',$this->fee);
		$criteria->compare('total_neto',$this->total_neto);
		$criteria->compare('total_publico',$this->total_publico);
		$criteria->compare('id_proveedor',$this->id_proveedor);
		$criteria->compare('id_tipo_servicio',$this->id_tipo_servicio);
		$criteria->compare('id_contrato',$this->id_contrato);
		$criteria->compare('log',$this->log,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}