<?php

/**
 * This is the model class for table "{{contratos}}".
 *
 * The followings are the available columns in table '{{contratos}}':
 * @property integer $id_contrato
 * @property integer $id_user_creo
 * @property integer $id_user_firmo
 * @property string $hora
 * @property string $fecha
 * @property string $location
 * @property string $ip
 * @property string $estatus
 * @property integer $version
 * @property integer $id_cotizacion
 * @property integer $id_venta
 * @property integer $id_cliente
 * @property integer $id_agencia
 * @property string $log
 *
 * The followings are the available model relations:
 * @property ContratoDesglose[] $contratoDesgloses
 * @property Users $idUserCreo
 * @property Cotizaciones $idCotizacion
 * @property Users $idUserFirmo
 * @property Agencia $idAgencia
 * @property Clientes $idCliente
 * @property Ventas $idVenta
 */
class Contratos extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Contratos the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{contratos}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_user_creo, estatus, version, id_venta, id_cliente, id_agencia', 'required'),
			array('id_user_creo, id_user_firmo, version, id_cotizacion, id_venta, id_cliente, id_agencia', 'numerical', 'integerOnly'=>true),
			array('location', 'length', 'max'=>70),
			array('ip', 'length', 'max'=>20),
			array('estatus', 'length', 'max'=>3),
			array('hora, fecha', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_contrato, id_user_creo, id_user_firmo, hora, fecha, location, ip, estatus, version, id_cotizacion, id_venta, id_cliente, id_agencia, log', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'contratoDesgloses' => array(self::HAS_MANY, 'ContratoDesglose', 'id_contrato'),
			'idUserCreo' => array(self::BELONGS_TO, 'Users', 'id_user_creo'),
			'idCotizacion' => array(self::BELONGS_TO, 'Cotizaciones', 'id_cotizacion'),
			'idUserFirmo' => array(self::BELONGS_TO, 'Users', 'id_user_firmo'),
			'idAgencia' => array(self::BELONGS_TO, 'Agencia', 'id_agencia'),
			'idCliente' => array(self::BELONGS_TO, 'Clientes', 'id_cliente'),
			'idVenta' => array(self::BELONGS_TO, 'Ventas', 'id_venta'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_contrato' => 'Id Contrato',
			'id_user_creo' => 'Id User Creo',
			'id_user_firmo' => 'Id User Firmo',
			'hora' => 'Hora',
			'fecha' => 'Fecha',
			'location' => 'Location',
			'ip' => 'Ip',
			'estatus' => 'Estatus',
			'version' => 'Version',
			'id_cotizacion' => 'Id Cotizacion',
			'id_venta' => 'Id Venta',
			'id_cliente' => 'Id Cliente',
			'id_agencia' => 'Id Agencia',
			'log' => 'Log',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_contrato',$this->id_contrato);
		$criteria->compare('id_user_creo',$this->id_user_creo);
		$criteria->compare('id_user_firmo',$this->id_user_firmo);
		$criteria->compare('hora',$this->hora,true);
		$criteria->compare('fecha',$this->fecha,true);
		$criteria->compare('location',$this->location,true);
		$criteria->compare('ip',$this->ip,true);
		$criteria->compare('estatus',$this->estatus,true);
		$criteria->compare('version',$this->version);
		$criteria->compare('id_cotizacion',$this->id_cotizacion);
		$criteria->compare('id_venta',$this->id_venta);
		$criteria->compare('id_cliente',$this->id_cliente);
		$criteria->compare('id_agencia',$this->id_agencia);
		$criteria->compare('log',$this->log,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}