<?php

/**
 * This is the model class for table "{{cotizacion_detalles}}".
 *
 * The followings are the available columns in table '{{cotizacion_detalles}}':
 * @property integer $id_cotizacion_detalle
 * @property string $desglose
 * @property string $observaciones
 * @property double $comision
 * @property double $comision_pesos
 * @property double $fee
 * @property double $total_neto
 * @property double $total_publico
 * @property integer $id_proveedor
 * @property integer $id_cotizacion
 * @property integer $id_tipo_servicio
 * @property string $log
 *
 * The followings are the available model relations:
 * @property Cotizaciones $idCotizacion
 * @property TipoServicios $idTipoServicio
 * @property Proveedores $idProveedor
 */
class CotizacionDetalles extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return CotizacionDetalles the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{cotizacion_detalles}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('desglose, comision, comision_pesos, total_neto, total_publico, id_proveedor, id_cotizacion, id_tipo_servicio', 'required'),
			array('id_proveedor, id_cotizacion, id_tipo_servicio', 'numerical', 'integerOnly'=>true),
			array('comision, comision_pesos, fee, total_neto, total_publico', 'numerical'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_cotizacion_detalle, desglose, observaciones, comision, comision_pesos, fee, total_neto, total_publico, id_proveedor, id_cotizacion, id_tipo_servicio, log', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idCotizacion' => array(self::BELONGS_TO, 'Cotizaciones', 'id_cotizacion'),
			'idTipoServicio' => array(self::BELONGS_TO, 'TipoServicios', 'id_tipo_servicio'),
			'idProveedor' => array(self::BELONGS_TO, 'Proveedores', 'id_proveedor'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_cotizacion_detalle' => 'Id Cotizacion Detalle',
			'desglose' => 'Desglose',
			'observaciones' => 'Observaciones',
			'comision' => 'Comision',
			'comision_pesos' => 'Comision Pesos',
			'fee' => 'Fee',
			'total_neto' => 'Total Neto',
			'total_publico' => 'Total Publico',
			'id_proveedor' => 'Id Proveedor',
			'id_cotizacion' => 'Id Cotizacion',
			'id_tipo_servicio' => 'Id Tipo Servicio',
			'log' => 'Log',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_cotizacion_detalle',$this->id_cotizacion_detalle);
		$criteria->compare('desglose',$this->desglose,true);
		$criteria->compare('observaciones',$this->observaciones,true);
		$criteria->compare('comision',$this->comision);
		$criteria->compare('comision_pesos',$this->comision_pesos);
		$criteria->compare('fee',$this->fee);
		$criteria->compare('total_neto',$this->total_neto);
		$criteria->compare('total_publico',$this->total_publico);
		$criteria->compare('id_proveedor',$this->id_proveedor);
		$criteria->compare('id_cotizacion',$this->id_cotizacion);
		$criteria->compare('id_tipo_servicio',$this->id_tipo_servicio);
		$criteria->compare('log',$this->log,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}