<?php

/**
 * This is the model class for table "{{cotizaciones}}".
 *
 * The followings are the available columns in table '{{cotizaciones}}':
 * @property integer $id_cotizacion
 * @property string $observaciones
 * @property string $fecha_inicial
 * @property string $fecha_final
 * @property double $cargo_servicios
 * @property string $estatus
 * @property integer $id_usuario
 * @property integer $id_agencia
 * @property integer $id_cliente
 * @property integer $id_solicitud
 * @property string $log
 *
 * The followings are the available model relations:
 * @property Contratos[] $contrato
 * @property CotizacionDetalles[] $cotizacionDetalles
 * @property Users $idUsuario
 * @property Agencia $idAgencia
 * @property Clientes $idCliente
 * @property Solicitudes $idSolicitud
 */
class Cotizaciones extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Cotizaciones the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{cotizaciones}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('fecha_inicial, fecha_final, estatus, id_usuario, id_agencia, id_cliente', 'required'),
			array('id_usuario, id_agencia, id_cliente, id_solicitud', 'numerical', 'integerOnly'=>true),
			array('estatus', 'length', 'max'=>10),
			array('cargo_servicios', 'numerical'),
			array('observaciones', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_cotizacion, observaciones, fecha_inicial, fecha_final, estatus, id_usuario, id_agencia, id_cliente, id_solicitud, log', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'contrato' => array(self::HAS_ONE, 'Contratos', 'id_cotizacion'),
			'cotizacionDetalles' => array(self::HAS_MANY, 'CotizacionDetalles', 'id_cotizacion'),
			'idUsuario' => array(self::BELONGS_TO, 'Users', 'id_usuario'),
			'idAgencia' => array(self::BELONGS_TO, 'Agencia', 'id_agencia'),
			'idCliente' => array(self::BELONGS_TO, 'Clientes', 'id_cliente'),
			'idSolicitud' => array(self::BELONGS_TO, 'Solicitudes', 'id_solicitud'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_cotizacion' => 'Id Cotizacion',
			'observaciones' => 'Observaciones',
			'fecha_inicial' => 'Fecha Inicial',
			'fecha_final' => 'Fecha Final',
			'cargo_servicios' => 'Cargo Servicios',
			'estatus' => 'Estatus',
			'id_usuario' => 'Id Usuario',
			'id_agencia' => 'Id Agencia',
			'id_cliente' => 'Id Cliente',
			'id_solicitud' => 'Id Solicitud',
			'log' => 'Log',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_cotizacion',$this->id_cotizacion);
		$criteria->compare('observaciones',$this->observaciones,true);
		$criteria->compare('fecha_inicial',$this->fecha_inicial,true);
		$criteria->compare('fecha_final',$this->fecha_final,true);
		$criteria->compare('cargo_servicios',$this->cargo_servicios);
		$criteria->compare('estatus',$this->estatus,true);
		$criteria->compare('id_usuario',$this->id_usuario);
		$criteria->compare('id_agencia',$this->id_agencia);
		$criteria->compare('id_cliente',$this->id_cliente);
		$criteria->compare('id_solicitud',$this->id_solicitud);
		$criteria->compare('log',$this->log,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}