<?php

/**
 * This is the model class for table "{{cuentas_agencia}}".
 *
 * The followings are the available columns in table '{{cuentas_agencia}}':
 * @property integer $id_cuenta
 * @property string $cuenta
 * @property string $descripcion
 * @property integer $id_agencia
 * @property integer $estatus
 *
 * The followings are the available model relations:
 * @property Agencia $idAgencia
 * @property Pagos[] $pagoses
 */
class CuentasAgencia extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return CuentasAgencia the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{cuentas_agencia}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('cuenta, descripcion, id_agencia, estatus', 'required'),
			array('id_agencia, estatus', 'numerical', 'integerOnly'=>true),
			array('cuenta', 'length', 'max'=>100),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_cuenta, cuenta, descripcion, id_agencia, estatus', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idAgencia' => array(self::BELONGS_TO, 'Agencia', 'id_agencia'),
			'pagoses' => array(self::HAS_MANY, 'Pagos', 'id_cuenta'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_cuenta' => 'Id Cuenta',
			'cuenta' => 'Cuenta',
			'descripcion' => 'Descripcion',
			'id_agencia' => 'Id Agencia',
			'estatus' => 'Estatus',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_cuenta',$this->id_cuenta);
		$criteria->compare('cuenta',$this->cuenta,true);
		$criteria->compare('descripcion',$this->descripcion,true);
		$criteria->compare('id_agencia',$this->id_agencia);
		$criteria->compare('estatus',$this->estatus);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}