<?php

/**
 * This is the model class for table "{{datos_facturacion}}".
 *
 * The followings are the available columns in table '{{datos_facturacion}}':
 * @property integer $id_agencia
 * @property integer $id_datos_facturacion
 * @property string $usuario
 * @property string $password
 * @property string $log
 *
 * The followings are the available model relations:
 * @property Agencia $idAgencia
 */
class DatosFacturacion extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return DatosFacturacion the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{datos_facturacion}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('usuario, password', 'required'),
			array('id_agencia', 'numerical', 'integerOnly'=>true),
			array('usuario, password', 'length', 'max'=>50),
			array('log', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_agencia, id_datos_facturacion, usuario, password, log', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idAgencia' => array(self::BELONGS_TO, 'Agencia', 'id_agencia'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_agencia' => 'Id Agencia',
			'id_datos_facturacion' => 'Id Datos Facturacion',
			'usuario' => 'Usuario',
			'password' => 'Password',
			'log' => 'Log',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_agencia',$this->id_agencia);
		$criteria->compare('id_datos_facturacion',$this->id_datos_facturacion);
		$criteria->compare('usuario',$this->usuario,true);
		$criteria->compare('password',$this->password,true);
		$criteria->compare('log',$this->log,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}