<?php

/**
 * This is the model class for table "{{eventos}}".
 *
 * The followings are the available columns in table '{{eventos}}':
 * @property integer $id
 * @property string $correo_contacto
 * @property string $correo_aux
 * @property string $slug
 * @property integer $template
 * @property integer $id_grupo
 *
 * The followings are the available model relations:
 * @property Grupos $idGrupo
 * @property EventosComentarios[] $eventoComentarios
 * @property EventosGaleria[] $eventoGaleria
 * @property EventosMultimedia[] $eventoMultimedia
 */
class Eventos extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Eventos the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{eventos}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('slug, template, id_grupo', 'required'),
			array('template, id_grupo', 'numerical', 'integerOnly'=>true),
			array('correo_contacto, correo_aux', 'length', 'max'=>100),
			array('slug', 'length', 'max'=>255),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, correo_contacto, correo_aux, slug, template, id_grupo', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idGrupo' => array(self::BELONGS_TO, 'Grupos', 'id_grupo'),
			'eventoComentarios' => array(self::HAS_MANY, 'EventosComentarios', 'id_evento'),
			'eventoGaleria' => array(self::HAS_MANY, 'EventosGaleria', 'id_evento'),
			'eventoMultimedia' => array(self::HAS_MANY, 'EventosMultimedia', 'id_evento'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'correo_contacto' => 'Correo Contacto',
			'correo_aux' => 'Correo Aux',
			'slug' => 'Slug',
			'template' => 'Template',
			'id_grupo' => 'Id Grupo',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('correo_contacto',$this->correo_contacto,true);
		$criteria->compare('correo_aux',$this->correo_aux,true);
		$criteria->compare('slug',$this->slug,true);
		$criteria->compare('template',$this->template);
		$criteria->compare('id_grupo',$this->id_grupo);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}