<?php

/**
 * This is the model class for table "{{eventos_comentarios}}".
 *
 * The followings are the available columns in table '{{eventos_comentarios}}':
 * @property integer $id
 * @property string $autor
 * @property string $comentario
 * @property string $fecha
 * @property integer $id_evento
 *
 * The followings are the available model relations:
 * @property Eventos $idEvento
 */
class EventosComentarios extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return EventosComentarios the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{eventos_comentarios}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('autor, comentario, id_evento', 'required'),
			array('id_evento', 'numerical', 'integerOnly'=>true),
			array('autor', 'length', 'max'=>100),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, autor, comentario, fecha, id_evento', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idEvento' => array(self::BELONGS_TO, 'Eventos', 'id_evento'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'autor' => 'Autor',
			'comentario' => 'Comentario',
			'fecha' => 'Fecha',
			'id_evento' => 'Id Evento',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('autor',$this->autor,true);
		$criteria->compare('comentario',$this->comentario,true);
		$criteria->compare('fecha',$this->fecha,true);
		$criteria->compare('id_evento',$this->id_evento);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}