<?php

/**
 * This is the model class for table "{{gastos}}".
 *
 * The followings are the available columns in table '{{gastos}}':
 * @property integer $id_gasto
 * @property string $descripcion
 * @property string $fecha_gasto
 * @property double $importe
 * @property string $referencia
 * @property integer $id_forma_pago
 * @property integer $id_cuenta
 * @property string $comprobante
 * @property string $observaciones
 * @property integer $id_usuario
 * @property integer $id_agencia
 * @property integer $id_proveedor
 * @property string $log
 *
 * The followings are the available model relations:
 * @property FormaPago $idFormaPago
 * @property Users $idUsuario
 * @property CuentasAgencia $idCuenta
 * @property Agencia $idAgencia
 * @property Proveedores $idProveedor
 */
class Gastos extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Gastos the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{gastos}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('descripcion, fecha_gasto, importe, id_forma_pago, id_cuenta, id_usuario, id_agencia', 'required'),
			array('id_forma_pago, id_cuenta, id_usuario, id_agencia, id_proveedor', 'numerical', 'integerOnly'=>true),
			array('importe', 'numerical'),
			array('referencia, comprobante', 'length', 'max'=>150),
			array('observaciones', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_gasto, descripcion, fecha_gasto, importe, referencia, id_forma_pago, id_cuenta, comprobante, observaciones, id_usuario, id_agencia, id_proveedor, log', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idFormaPago' => array(self::BELONGS_TO, 'FormaPago', 'id_forma_pago'),
			'idUsuario' => array(self::BELONGS_TO, 'Users', 'id_usuario'),
			'idCuenta' => array(self::BELONGS_TO, 'CuentasAgencia', 'id_cuenta'),
			'idAgencia' => array(self::BELONGS_TO, 'Agencia', 'id_agencia'),
			'idProveedor' => array(self::BELONGS_TO, 'Proveedores', 'id_proveedor'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_gasto' => 'Id Gasto',
			'descripcion' => 'Descripcion',
			'fecha_gasto' => 'Fecha Gasto',
			'importe' => 'Importe',
			'referencia' => 'Referencia',
			'id_forma_pago' => 'Id Forma Pago',
			'id_cuenta' => 'Id Cuenta',
			'comprobante' => 'Comprobante',
			'observaciones' => 'Observaciones',
			'id_usuario' => 'Id Usuario',
			'id_agencia' => 'Id Agencia',
			'id_proveedor' => 'Id Proveedor',
			'log' => 'Log',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_gasto',$this->id_gasto);
		$criteria->compare('descripcion',$this->descripcion,true);
		$criteria->compare('fecha_gasto',$this->fecha_gasto,true);
		$criteria->compare('importe',$this->importe);
		$criteria->compare('referencia',$this->referencia,true);
		$criteria->compare('id_forma_pago',$this->id_forma_pago);
		$criteria->compare('id_cuenta',$this->id_cuenta);
		$criteria->compare('comprobante',$this->comprobante,true);
		$criteria->compare('observaciones',$this->observaciones,true);
		$criteria->compare('id_usuario',$this->id_usuario);
		$criteria->compare('id_agencia',$this->id_agencia);
		$criteria->compare('id_proveedor',$this->id_proveedor);
		$criteria->compare('log',$this->log,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}