<?php

/**
 * This is the model class for table "{{grupo_habitaciones}}".
 *
 * The followings are the available columns in table '{{grupo_habitaciones}}':
 * @property integer $id_habitacion
 * @property integer $id_grupo
 * @property string $tipo_habitacion
 * @property string $noches
 * @property string $fecha_entrada
 * @property string $fecha_salida
 * @property double $total_neto
 * @property double $total_publico
 * @property string $log
 *
 * The followings are the available model relations:
 * @property Grupos $idGrupo
 * @property HabitacionesHuespedes[] $habitacionesHuespedes
 */
class GrupoHabitaciones extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return GrupoHabitaciones the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{grupo_habitaciones}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_grupo, tipo_habitacion, total_neto, total_publico', 'required'),
			array('id_grupo', 'numerical', 'integerOnly'=>true),
			array('total_neto, total_publico', 'numerical'),
			array('tipo_habitacion', 'length', 'max'=>35),
			array('noches', 'length', 'max'=>2),
			array('fecha_entrada, fecha_salida', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_habitacion, id_grupo, tipo_habitacion, noches, fecha_entrada, fecha_salida, total_neto, total_publico, log', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idGrupo' => array(self::BELONGS_TO, 'Grupos', 'id_grupo'),
			'habitacionesHuespedes' => array(self::HAS_MANY, 'HabitacionesHuespedes', 'id_habitacion'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_habitacion' => 'Id Habitacion',
			'id_grupo' => 'Id Grupo',
			'tipo_habitacion' => 'Tipo Habitacion',
			'noches' => 'Noches',
			'fecha_entrada' => 'Fecha Entrada',
			'fecha_salida' => 'Fecha Salida',
			'total_neto' => 'Total Neto',
			'total_publico' => 'Total Publico',
			'log' => 'Log',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_habitacion',$this->id_habitacion);
		$criteria->compare('id_grupo',$this->id_grupo);
		$criteria->compare('tipo_habitacion',$this->tipo_habitacion,true);
		$criteria->compare('noches',$this->noches,true);
		$criteria->compare('fecha_entrada',$this->fecha_entrada,true);
		$criteria->compare('fecha_salida',$this->fecha_salida,true);
		$criteria->compare('total_neto',$this->total_neto);
		$criteria->compare('total_publico',$this->total_publico);
		$criteria->compare('log',$this->log,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}