<?php

/**
 * This is the model class for table "{{grupos}}".
 *
 * The followings are the available columns in table '{{grupos}}':
 * @property integer $id_grupo
 * @property integer $id_ventaservicio
 * @property integer $id_agencia
 * @property integer $id_cliente
 * @property integer $id_usuario
 * @property string $titulo_evento
 * @property integer $num_habitaciones
 * @property integer $noches
 * @property string $hotel
 * @property string $tipo_habitacion
 * @property string $condiciones
 * @property string $tipo
 * @property string $estatus
 * @property string $log
 *
 * The followings are the available model relations:
 * @property Eventos[] $evento
 * @property GrupoHabitaciones[] $grupoHabitaciones
 * @property Clientes $idCliente
 * @property VentasServicios $idVentaservicio
 * @property Agencia $idAgencia
 * @property UsuariosAgencias $idUsuario
 * @property GruposArchivos[] $gruposArchivoses
 * @property Invitaciones[] $invitaciones
 */
class Grupos extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Grupos the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{grupos}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_ventaservicio, id_agencia, id_cliente, id_usuario, tipo, estatus', 'required'),
			array('id_ventaservicio, id_agencia, id_cliente, id_usuario, num_habitaciones, noches', 'numerical', 'integerOnly'=>true),
			array('titulo_evento, hotel', 'length', 'max'=>50),
			array('tipo_habitacion', 'length', 'max'=>35),
			//array('condiciones', 'length', 'max'=>250),
			array('tipo', 'length', 'max'=>10),
			array('estatus', 'length', 'max'=>15),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_grupo, id_ventaservicio, id_agencia, id_cliente, id_usuario, titulo_evento, num_habitaciones, noches, hotel, tipo_habitacion, condiciones, tipo, estatus, log', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'evento' => array(self::HAS_ONE, 'Eventos', 'id_grupo'),
			'grupoHabitaciones' => array(self::HAS_MANY, 'GrupoHabitaciones', 'id_grupo'),
			'idCliente' => array(self::BELONGS_TO, 'Clientes', 'id_cliente'),
			'idVentaservicio' => array(self::BELONGS_TO, 'VentasServicios', 'id_ventaservicio'),
			'idAgencia' => array(self::BELONGS_TO, 'Agencia', 'id_agencia'),
			'idUsuario' => array(self::BELONGS_TO, 'UsuariosAgencias', 'id_usuario'),
			'gruposArchivoses' => array(self::HAS_MANY, 'GruposArchivos', 'id_grupo'),
			'invitaciones' => array(self::HAS_MANY, 'Invitaciones', 'id_boda'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_grupo' => 'Id Grupo',
			'id_ventaservicio' => 'Id Ventaservicio',
			'id_agencia' => 'Id Agencia',
			'id_cliente' => 'Id Cliente',
			'id_usuario' => 'Id Usuario',
			'titulo_evento' => 'Titulo Evento',
			'num_habitaciones' => 'Num Habitaciones',
			'noches' => 'Noches',
			'hotel' => 'Hotel',
			'tipo_habitacion' => 'Tipo Habitacion',
			'condiciones' => 'Condiciones',
			'tipo' => 'Tipo',
			'estatus' => 'Estatus',
			'log' => 'Log',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_grupo',$this->id_grupo);
		$criteria->compare('id_ventaservicio',$this->id_ventaservicio);
		$criteria->compare('id_agencia',$this->id_agencia);
		$criteria->compare('id_cliente',$this->id_cliente);
		$criteria->compare('id_usuario',$this->id_usuario);
		$criteria->compare('titulo_evento',$this->titulo_evento,true);
		$criteria->compare('num_habitaciones',$this->num_habitaciones);
		$criteria->compare('noches',$this->noches);
		$criteria->compare('hotel',$this->hotel,true);
		$criteria->compare('tipo_habitacion',$this->tipo_habitacion,true);
		$criteria->compare('condiciones',$this->condiciones,true);
		$criteria->compare('tipo',$this->tipo,true);
		$criteria->compare('estatus',$this->estatus,true);
		$criteria->compare('log',$this->log,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}