<?php

/**
 * This is the model class for table "{{grupos_archivos}}".
 *
 * The followings are the available columns in table '{{grupos_archivos}}':
 * @property integer $id_grupo_archivo
 * @property string $path
 * @property integer $id_grupo
 * @property string $log
 *
 * The followings are the available model relations:
 * @property Grupos $idGrupo
 */
class GruposArchivos extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return GruposArchivos the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{grupos_archivos}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('path, id_grupo', 'required'),
			array('id_grupo', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_grupo_archivo, path, id_grupo, log', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idGrupo' => array(self::BELONGS_TO, 'Grupos', 'id_grupo'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_grupo_archivo' => 'Id Grupo Archivo',
			'path' => 'Path',
			'id_grupo' => 'Id Grupo',
			'log' => 'Log',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_grupo_archivo',$this->id_grupo_archivo);
		$criteria->compare('path',$this->path,true);
		$criteria->compare('id_grupo',$this->id_grupo);
		$criteria->compare('log',$this->log,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}