<?php

/**
 * This is the model class for table "{{habitaciones_huespedes}}".
 *
 * The followings are the available columns in table '{{habitaciones_huespedes}}':
 * @property integer $id_huesped
 * @property integer $id_habitacion
 * @property string $nombres
 * @property string $apellidos
 * @property integer $edad
 * @property string $correo
 * @property string $telefono
 * @property string $log
 *
 * The followings are the available model relations:
 * @property GrupoHabitaciones $idHabitacion
 */
class HabitacionesHuespedes extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return HabitacionesHuespedes the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{habitaciones_huespedes}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_habitacion', 'required'),
			array('id_habitacion, edad', 'numerical', 'integerOnly'=>true),
			array('nombres, apellidos', 'length', 'max'=>25),
			array('correo', 'length', 'max'=>100),
			array('telefono', 'length', 'max'=>20),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_huesped, id_habitacion, nombres, apellidos, edad, correo, telefono, log', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idHabitacion' => array(self::BELONGS_TO, 'GrupoHabitaciones', 'id_habitacion'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_huesped' => 'Id Huesped',
			'id_habitacion' => 'Id Habitacion',
			'nombres' => 'Nombres',
			'apellidos' => 'Apellidos',
			'edad' => 'Edad',
			'correo' => 'Correo',
			'telefono' => 'Telefono',
			'log' => 'Log',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_huesped',$this->id_huesped);
		$criteria->compare('id_habitacion',$this->id_habitacion);
		$criteria->compare('nombres',$this->nombres,true);
		$criteria->compare('apellidos',$this->apellidos,true);
		$criteria->compare('edad',$this->edad);
		$criteria->compare('correo',$this->correo,true);
		$criteria->compare('telefono',$this->telefono,true);
		$criteria->compare('log',$this->log,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}